/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.tycho.p2resolver.P2ResolverImpl;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="eclipse-test-plugin-packaging")
public class TestPluginPackagingInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private Logger logger;
    private Collection<IInstallableUnit> eclipseTestPackagingIUs;

    public TestPluginPackagingInstallableUnitProvider() {
        ArrayList<IRequirement> list = new ArrayList<IRequirement>();
        P2ResolverImpl.addDependenciesForTests(list::add);
        this.eclipseTestPackagingIUs = this.createIU(list);
    }

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        if ("eclipse-test-plugin".equals(project.getPackaging())) {
            return this.eclipseTestPackagingIUs;
        }
        return Collections.emptyList();
    }

    private Collection<IInstallableUnit> createIU(Collection<IRequirement> additionalBundleRequirements) {
        if (additionalBundleRequirements.isEmpty()) {
            return Collections.emptyList();
        }
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        result.setId("eclipse-test-plugin-packaging-" + UUID.randomUUID());
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)String.valueOf(System.currentTimeMillis())));
        result.addRequirements(additionalBundleRequirements);
        return List.of(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result));
    }
}

