/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.TargetPlatformConfigurationException;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseModuleConnector;
import org.eclipse.tycho.osgi.framework.EclipseWorkspace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EclipseApplication {
    public static final String ARG_APPLICATION = "-application";
    private static final Set<String> ALWAYS_START_BUNDLES = Set.of("org.eclipse.core.runtime", "org.apache.felix.scr", "org.eclipse.equinox.app");
    private P2Resolver resolver;
    private TargetPlatform targetPlatform;
    private Logger logger;
    private boolean needResolve;
    private List<Path> resolvedBundles;
    private String name;
    private Map<String, String> frameworkProperties = new LinkedHashMap<String, String>();
    private Predicate<LogEntry> loggingFilter = always -> true;
    private Set<String> startBundles = new HashSet<String>(ALWAYS_START_BUNDLES);
    private Map<File, MavenProject> baseDirMap;

    EclipseApplication(String name, P2Resolver resolver, TargetPlatform targetPlatform, Logger logger, Map<File, MavenProject> baseDirMap) {
        this.name = name;
        this.resolver = resolver;
        this.targetPlatform = targetPlatform;
        this.logger = logger;
        this.baseDirMap = baseDirMap;
    }

    public synchronized Collection<Path> getApplicationBundles() {
        if (this.needResolve) {
            this.resolvedBundles = this.resolveBundles(this.resolver);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Eclipse Application " + this.name + " resolved with " + this.resolvedBundles.size() + " bundles.");
                for (Path path : this.resolvedBundles) {
                    this.logger.debug("\t" + path);
                }
            }
        }
        return this.resolvedBundles;
    }

    private List<Path> resolveBundles(P2Resolver resolver) {
        ArrayList<Path> resolvedBundles = new ArrayList<Path>();
        for (P2ResolutionResult result : resolver.resolveTargetDependencies(this.targetPlatform, null).values()) {
            for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
                File artifactFile;
                MavenProject mavenProject;
                if (!"eclipse-plugin".equals(entry.getType()) || "org.eclipse.osgi".equals(entry.getId())) continue;
                File location = entry.getLocation(true);
                Path path = location.toPath();
                if (location.isDirectory() && (mavenProject = this.baseDirMap.get(location)) != null && (artifactFile = mavenProject.getArtifact().getFile()) != null && artifactFile.exists()) {
                    path = artifactFile.toPath();
                }
                resolvedBundles.add(path);
            }
        }
        return resolvedBundles;
    }

    public synchronized void addBundle(String bundleSymbolicName) {
        try {
            this.resolver.addDependency("eclipse-plugin", bundleSymbolicName, "0.0.0");
            this.needResolve = true;
        }
        catch (IllegalArtifactReferenceException e) {
            throw new TargetPlatformConfigurationException("Can't add API tools requirement", e);
        }
    }

    public synchronized void addFeature(String featureId) {
        try {
            this.resolver.addDependency("eclipse-feature", featureId, "0.0.0");
            this.needResolve = true;
        }
        catch (IllegalArtifactReferenceException e) {
            throw new TargetPlatformConfigurationException("Can't add API tools requirement", e);
        }
    }

    public synchronized void addConditionalBundle(String bundleSymbolicName, String filter) {
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleSymbolicName, (VersionRange)VersionRange.emptyRange, (String)filter, (boolean)true, (boolean)false, (boolean)true);
        this.resolver.addRequirement(requirement);
        this.needResolve = true;
    }

    public String getName() {
        return this.name;
    }

    public void addFrameworkProperty(String key, String value) {
        this.frameworkProperties.put(key, value);
    }

    public void setLoggingFilter(Predicate<LogEntry> loggingFilter) {
        this.loggingFilter = loggingFilter;
    }

    public void setBundleStart(String id, boolean start) {
        if (start) {
            this.startBundles.add(id);
        } else {
            this.startBundles.remove(id);
        }
    }

    public <T> EclipseFramework startFramework(EclipseWorkspace<T> workspace, List<String> applicationArguments) throws BundleException {
        Map<String, String> frameworkProperties = this.getFrameworkProperties(workspace.getWorkDir());
        frameworkProperties.putAll(this.frameworkProperties);
        if (!applicationArguments.contains(ARG_APPLICATION)) {
            frameworkProperties.put("eclipse.ignoreApp", "true");
            frameworkProperties.put("osgi.noShutdown", "true");
        }
        ServiceLoader<ConnectFrameworkFactory> loader = ServiceLoader.load(ConnectFrameworkFactory.class, this.getClass().getClassLoader());
        ConnectFrameworkFactory factory = loader.findFirst().orElseThrow(() -> new BundleException("No ConnectFrameworkFactory found"));
        EclipseModuleConnector connector = new EclipseModuleConnector();
        Framework framework = factory.newFramework(frameworkProperties, (ModuleConnector)connector);
        framework.init();
        BundleContext systemBundleContext = framework.getBundleContext();
        EquinoxConfiguration configuration = this.setupArguments(systemBundleContext, applicationArguments);
        this.setupLogging(systemBundleContext);
        for (Path bundleFile : this.getApplicationBundles()) {
            String location = bundleFile.toUri().toString();
            Bundle bundle = systemBundleContext.getBundle(location);
            if (bundle == null) {
                if (Files.isDirectory(bundleFile, new LinkOption[0])) {
                    bundle = systemBundleContext.installBundle(location);
                } else if (this.isDirectoryBundly(bundleFile)) {
                    Path explodePath = workspace.getWorkDir().resolve("exploded").resolve(bundleFile.getFileName());
                    try {
                        Files.createDirectories(explodePath, new FileAttribute[0]);
                        ZipUnArchiver unArchiver = new ZipUnArchiver(bundleFile.toFile());
                        unArchiver.setDestDirectory(explodePath.toFile());
                        unArchiver.extract();
                    }
                    catch (IOException e) {
                        throw new BundleException("can't explode bundle " + bundleFile, (Throwable)e);
                    }
                    bundle = systemBundleContext.installBundle(explodePath.toUri().toASCIIString());
                } else {
                    try (InputStream stream = Files.newInputStream(bundleFile, new OpenOption[0]);){
                        bundle = systemBundleContext.installBundle(location, stream);
                    }
                    catch (IOException e) {
                        throw new BundleException("can't read bundle " + bundleFile, (Throwable)e);
                    }
                }
            }
            if (!this.startBundles.contains(bundle.getSymbolicName())) continue;
            bundle.start();
        }
        FrameworkWiring wiring = (FrameworkWiring)framework.adapt(FrameworkWiring.class);
        wiring.resolveBundles(Collections.emptyList());
        return new EclipseFramework(framework, configuration, this, connector);
    }

    private boolean isDirectoryBundly(Path bundleFile) {
        boolean bl;
        JarFile jarFile = new JarFile(bundleFile.toFile());
        try {
            bl = "dir".equals(jarFile.getManifest().getMainAttributes().getValue("Eclipse-BundleShape"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    private void setupLogging(final BundleContext bundleContext) {
        final LogListener logListener = new LogListener(){

            public void logged(LogEntry entry) {
                if (!EclipseApplication.this.loggingFilter.test(entry) && !EclipseApplication.this.logger.isDebugEnabled()) {
                    return;
                }
                switch (entry.getLogLevel()) {
                    case AUDIT: 
                    case ERROR: {
                        EclipseApplication.this.logger.error(entry.getMessage(), entry.getException());
                        break;
                    }
                    case WARN: {
                        EclipseApplication.this.logger.warn(entry.getMessage(), entry.getException());
                        break;
                    }
                    case INFO: {
                        EclipseApplication.this.logger.info(entry.getMessage(), entry.getException());
                        break;
                    }
                    case TRACE: 
                    case DEBUG: {
                        EclipseApplication.this.logger.debug(entry.getMessage(), entry.getException());
                    }
                }
            }
        };
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, LogReaderService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<LogReaderService, LogReaderService>(){

            public LogReaderService addingService(ServiceReference<LogReaderService> reference) {
                LogReaderService service = (LogReaderService)bundleContext.getService(reference);
                if (service != null) {
                    service.addLogListener(logListener);
                }
                return service;
            }

            public void modifiedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
            }

            public void removedService(ServiceReference<LogReaderService> reference, LogReaderService service) {
                service.removeLogListener(logListener);
                bundleContext.ungetService(reference);
            }
        });
        serviceTracker.open();
    }

    private EquinoxConfiguration setupArguments(BundleContext systemBundleContext, List<String> applicationArguments) {
        ServiceTracker environmentInfoTracker = new ServiceTracker(systemBundleContext, EnvironmentInfo.class, null);
        environmentInfoTracker.open();
        EquinoxConfiguration configuration = (EquinoxConfiguration)environmentInfoTracker.getService();
        configuration.setAppArgs((String[])applicationArguments.toArray(String[]::new));
        environmentInfoTracker.close();
        return configuration;
    }

    private Map<String, String> getFrameworkProperties(Path workDir) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("osgi.configuration.area", workDir.resolve("configuration").toAbsolutePath().toString());
        map.put("osgi.instance.area", workDir.resolve("data").toAbsolutePath().toString());
        map.put("osgi.compatibility.bootdelegation", "true");
        map.put("osgi.framework.useSystemProperties", "false");
        return map;
    }

    Logger getLogger() {
        return this.logger;
    }
}

