/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.internal.adaptor.EclipseAppLauncher;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseModuleConnector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class EclipseFramework
implements AutoCloseable {
    private final Framework framework;
    private final EquinoxConfiguration configuration;
    private final EclipseApplication application;
    private final EclipseModuleConnector connector;
    private AtomicBoolean started = new AtomicBoolean();

    EclipseFramework(Framework framework, EquinoxConfiguration configuration, EclipseApplication application, EclipseModuleConnector connector) {
        this.framework = framework;
        this.configuration = configuration;
        this.application = application;
        this.connector = connector;
    }

    @Override
    public void close() {
        if (this.started.compareAndSet(true, false)) {
            try {
                this.framework.stop();
                this.framework.waitForStop(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            String[] args;
            this.framework.start();
            for (String arg : args = this.configuration.getNonFrameworkArgs()) {
                if (!"-application".equals(arg)) continue;
                int exitCode = this.launchApplication(this.framework.getBundleContext(), this.configuration);
                if (exitCode != 0) {
                    throw new Exception("Application returned exit code " + exitCode);
                }
                return;
            }
        }
    }

    private int launchApplication(BundleContext systemBundleContext, EquinoxConfiguration configuration) throws Exception {
        Object returnValue;
        EclipseAppLauncher appLauncher = new EclipseAppLauncher(systemBundleContext, false, true, null, configuration);
        systemBundleContext.registerService(ApplicationLauncher.class, (Object)appLauncher, null);
        try {
            returnValue = appLauncher.start(null);
        }
        catch (Exception e) {
            throw this.applicationStartupError(systemBundleContext, e);
        }
        if (returnValue instanceof Integer) {
            Integer retCode = (Integer)returnValue;
            return retCode;
        }
        if (returnValue == null) {
            throw this.applicationStartupError(systemBundleContext, new NullPointerException("Application return value is null!"));
        }
        throw this.applicationStartupError(systemBundleContext, new IllegalStateException("Unsupported return value: " + returnValue + " of type " + returnValue.getClass().getName()));
    }

    private Exception applicationStartupError(BundleContext systemBundleContext, Exception e) {
        String bundleState = Arrays.stream(systemBundleContext.getBundles()).map(b -> EclipseFramework.toBundleState(b.getState()) + " | " + b.getSymbolicName()).collect(Collectors.joining(System.lineSeparator()));
        this.application.getLogger().error(String.format("Internal error execute the " + this.application.getName() + " application, the current framework state is:\r\n%s", bundleState), (Throwable)e);
        return e;
    }

    private static String toBundleState(int state) {
        return switch (state) {
            case 32 -> "ACTIVE   ";
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED ";
            case 8 -> "STARTING ";
            case 16 -> "STOPPING ";
            default -> String.valueOf(state);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <X extends Callable<R> & Serializable, R extends Serializable> R execute(X runnable) throws InvocationTargetException {
        try {
            this.start();
            byte[] runnableBytes = EclipseFramework.getBytes(runnable);
            BundleContext bundleContext = this.framework.getBundleContext();
            String newBundleId = this.connector.newBundle(runnable.getClass());
            Bundle bundle = bundleContext.installBundle(newBundleId);
            try {
                bundle.start();
                Class foreignClass = bundle.loadClass(runnable.getClass().getName());
                Object foreignObject = this.readObject(runnableBytes, foreignClass.getClassLoader());
                Method method = foreignClass.getMethod("call", new Class[0]);
                byte[] resultBytes = EclipseFramework.getBytes(method.invoke(foreignObject, new Object[0]));
                if (resultBytes == null) {
                    R r = null;
                    return r;
                }
                Serializable serializable = (Serializable)this.readObject(resultBytes, runnable.getClass().getClassLoader());
                return (R)serializable;
            }
            finally {
                bundle.uninstall();
                this.connector.release(newBundleId);
            }
        }
        catch (Exception e) {
            if (!(e instanceof InvocationTargetException)) throw new InvocationTargetException(e);
            InvocationTargetException ite = (InvocationTargetException)e;
            throw ite;
        }
    }

    private Object readObject(byte[] runnableBytes, ClassLoader loader) throws IOException, ClassNotFoundException, StreamCorruptedException {
        Object foreignObject;
        try (ClassLoaderObjectInputStream stream = new ClassLoaderObjectInputStream(loader, (InputStream)new ByteArrayInputStream(runnableBytes));){
            foreignObject = stream.readObject();
        }
        return foreignObject;
    }

    private static byte[] getBytes(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(byteStream);){
            stream.writeObject(o);
        }
        return byteStream.toByteArray();
    }

    public void printState() {
        Logger logger = this.application.getLogger();
        logger.info("==== " + this.application.getName() + " ====");
        for (Bundle bundle : this.framework.getBundleContext().getBundles()) {
            logger.info(EclipseFramework.toBundleState(bundle.getState()) + " | " + bundle.getSymbolicName());
        }
    }

    public boolean hasBundle(String bsn) {
        for (Bundle bundle : this.framework.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().equals(bsn)) continue;
            return true;
        }
        return false;
    }

    public Bundle install(File file) throws IOException, BundleException {
        try (FileInputStream stream = new FileInputStream(file);){
            Bundle bundle = this.framework.getBundleContext().installBundle(file.getAbsolutePath(), (InputStream)stream);
            return bundle;
        }
    }
}

