/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.Mojo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.osgi.framework.EclipseWorkspace;

@Component(role=EclipseWorkspaceManager.class)
public class EclipseWorkspaceManager
implements Disposable {
    private final Map<Thread, Map<Object, EclipseWorkspace<?>>> cache = new WeakHashMap();
    private final List<EclipseWorkspace<?>> toclean = new ArrayList();
    @Requirement
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> EclipseWorkspace<T> getWorkspace(T key) {
        Thread currentThread = Thread.currentThread();
        Map<Thread, Map<Object, EclipseWorkspace<?>>> map = this.cache;
        synchronized (map) {
            return this.cache.computeIfAbsent(currentThread, t -> new ConcurrentHashMap()).computeIfAbsent(key, x -> {
                try {
                    EclipseWorkspace<Object> workspace = new EclipseWorkspace<Object>(Files.createTempDirectory("eclipseWorkspace", new FileAttribute[0]), key, currentThread);
                    this.toclean.add(workspace);
                    return workspace;
                }
                catch (IOException e) {
                    throw new IllegalStateException("can't create a temporary directory for the workspace!", e);
                }
            });
        }
    }

    public void dispose() {
        this.cache.clear();
        for (EclipseWorkspace<?> workspace : this.toclean) {
            FileUtils.deleteQuietly((File)workspace.getWorkDir().toFile());
        }
    }

    public EclipseWorkspace<?> getWorkspace(URI uri, Mojo mojo) {
        return this.getWorkspace(new MojoKey(uri.normalize(), mojo.getClass().getName()));
    }

    private record MojoKey(URI uri, String mojoClassName) {
    }
}

