/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.publisher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.IDependencyMetadata;

public class DependencyMetadata
implements IDependencyMetadata {
    private Map<IDependencyMetadata.DependencyMetadataType, Set<IInstallableUnit>> typeMap = new TreeMap<IDependencyMetadata.DependencyMetadataType, Set<IInstallableUnit>>();
    private Set<IArtifactDescriptor> artifacts;

    public Set<IInstallableUnit> getDependencyMetadata(IDependencyMetadata.DependencyMetadataType type) {
        return this.typeMap.getOrDefault(type, Collections.emptySet());
    }

    public Set<IInstallableUnit> getDependencyMetadata() {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        result.addAll(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED));
        result.addAll(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE));
        return result;
    }

    public void setDependencyMetadata(IDependencyMetadata.DependencyMetadataType type, Collection<IInstallableUnit> units) {
        this.typeMap.put(type, new LinkedHashSet<IInstallableUnit>(units));
    }

    public void setArtifacts(Collection<IArtifactDescriptor> artifacts) {
        this.artifacts = new LinkedHashSet<IArtifactDescriptor>(artifacts);
    }

    public Set<IArtifactDescriptor> getArtifactDescriptors() {
        return this.artifacts;
    }

    public Set<IInstallableUnit> getInstallableUnits() {
        return this.typeMap.values().stream().flatMap(Collection::stream).filter(IInstallableUnit.class::isInstance).map(IInstallableUnit.class::cast).distinct().collect(Collectors.toSet());
    }
}

