/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.p2.repository.ArtifactRepositoryBaseImpl;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicies;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicy;
import org.eclipse.tycho.p2.repository.ArtifactsIO;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.GAVArtifactDescriptor;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class LocalArtifactRepository
extends ArtifactRepositoryBaseImpl<GAVArtifactDescriptor> {
    private Set<IArtifactKey> descriptorsOnLastSave;
    private final LocalRepositoryP2Indices localRepoIndices;
    private final RepositoryReader contentLocator;
    private final Map<IArtifactKey, Lock> downloadLocks = new ConcurrentHashMap<IArtifactKey, Lock>();

    public LocalArtifactRepository(IProvisioningAgent agent, LocalRepositoryP2Indices localRepoIndices) {
        this(agent, localRepoIndices, new LocalRepositoryReader(localRepoIndices.getMavenContext()));
    }

    public LocalArtifactRepository(IProvisioningAgent agent, LocalRepositoryP2Indices localRepoIndices, RepositoryReader contentLocator) {
        super(agent, localRepoIndices.getBasedir().toURI(), ArtifactTransferPolicies.forLocalArtifacts());
        this.localRepoIndices = localRepoIndices;
        this.contentLocator = contentLocator;
        this.loadMaven();
    }

    private void loadMaven() {
        ArtifactsIO io = new ArtifactsIO();
        TychoRepositoryIndex index = this.localRepoIndices.getArtifactsIndex();
        for (GAV gav : index.getProjectGAVs()) {
            try {
                File localArtifactFileLocation = this.contentLocator.getLocalArtifactLocation(gav, "p2artifacts", "p2-artifacts");
                if (localArtifactFileLocation.isFile()) {
                    FileInputStream is = new FileInputStream(localArtifactFileLocation);
                    try {
                        Set<IArtifactDescriptor> gavDescriptors = io.readXML(is);
                        for (IArtifactDescriptor descriptor : gavDescriptors) {
                            if (ArtifactTransferPolicy.isCanonicalFormat(descriptor) && gav.getGroupId().startsWith("p2.")) {
                                GAVArtifactDescriptor copy = new GAVArtifactDescriptor(descriptor.getArtifactKey());
                                descriptor.getProperties().forEach((arg_0, arg_1) -> ((GAVArtifactDescriptor)copy).setProperty(arg_0, arg_1));
                                copy.setProcessingSteps(descriptor.getProcessingSteps());
                                copy.setRepository((IArtifactRepository)this);
                                super.internalAddDescriptor((IArtifactDescriptor)copy);
                                continue;
                            }
                            super.internalAddDescriptor(descriptor);
                        }
                        continue;
                    }
                    finally {
                        ((InputStream)is).close();
                        continue;
                    }
                }
                index.removeGav(gav);
            }
            catch (IOException e) {
                index.removeGav(gav);
                this.localRepoIndices.getMavenContext().getLogger().debug("Cannot read stored metadata", e);
            }
        }
        this.descriptorsOnLastSave = this.currentKeys();
    }

    public synchronized void save() {
        TychoRepositoryIndex index = this.localRepoIndices.getArtifactsIndex();
        ArtifactsIO io = new ArtifactsIO();
        HashSet<IArtifactKey> descriptors = this.currentKeys();
        for (IArtifactKey key : descriptors) {
            Set keyDescriptors;
            if (this.descriptorsOnLastSave.contains(key) || (keyDescriptors = (Set)this.descriptorsMap.get(key)) == null || keyDescriptors.isEmpty()) continue;
            GAVArtifactDescriptor anyDescriptorOfKey = (GAVArtifactDescriptor)((Object)keyDescriptors.iterator().next());
            GAV gav = anyDescriptorOfKey.getMavenCoordinates().getGav();
            index.addGav(gav);
            File file = this.contentLocator.getLocalArtifactLocation(gav, "p2artifacts", "p2-artifacts");
            file.getParentFile().mkdirs();
            this.localRepoIndices.getMavenContext().getLogger().debug("Writing P2 metadata for " + key + " to " + file);
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                io.writeXML((Set<? extends IArtifactDescriptor>)keyDescriptors, os);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            index.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.descriptorsOnLastSave = new HashSet<IArtifactKey>(descriptors);
    }

    protected HashSet<IArtifactKey> currentKeys() {
        return this.flattenedValues().map(IArtifactDescriptor::getArtifactKey).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public File internalGetArtifactStorageLocation(IArtifactDescriptor descriptor) {
        String relativePath = this.toInternalDescriptor(descriptor).getMavenCoordinates().getLocalRepositoryPath(this.localRepoIndices.getMavenContext());
        return new File(this.getBasedir(), relativePath);
    }

    public GAVArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        GAVArtifactDescriptor descriptor = new GAVArtifactDescriptor(key);
        descriptor.setRepository((IArtifactRepository)this);
        return descriptor;
    }

    @Override
    protected IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor descriptor) {
        return this.toInternalDescriptor(descriptor);
    }

    @Override
    protected GAVArtifactDescriptor getInternalDescriptorForAdding(IArtifactDescriptor descriptor) {
        return this.toInternalDescriptor(descriptor);
    }

    private GAVArtifactDescriptor toInternalDescriptor(IArtifactDescriptor descriptor) {
        if (descriptor instanceof GAVArtifactDescriptor) {
            GAVArtifactDescriptor gavArtifactDescriptor = (GAVArtifactDescriptor)descriptor;
            if (descriptor.getRepository() == this) {
                return gavArtifactDescriptor;
            }
        }
        GAVArtifactDescriptor internalDescriptor = new GAVArtifactDescriptor(descriptor);
        internalDescriptor.setRepository((IArtifactRepository)this);
        return internalDescriptor;
    }

    private File getBasedir() {
        return new File(this.getLocation());
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.contains(artifactKey);
    }

    public Lock getLockForDownload(IArtifactKey key) {
        return this.downloadLocks.computeIfAbsent(key, k -> new ReentrantLock());
    }

    @Override
    protected void internalRemoveDescriptors(IArtifactKey key) {
        super.internalRemoveDescriptors(key);
        this.descriptorsOnLastSave.remove(key);
    }

    @Override
    public void internalAddDescriptor(IArtifactDescriptor descriptor) {
        super.internalAddDescriptor(descriptor);
        this.descriptorsOnLastSave.remove(descriptor.getArtifactKey());
    }
}

