/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.IArtifactSink;
import org.eclipse.tycho.WriteSessionContext;
import org.eclipse.tycho.p2.repository.ArtifactRepositoryBaseImpl;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicies;
import org.eclipse.tycho.p2.repository.ArtifactsIO;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.GAVArtifactDescriptorBase;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.p2.repository.module.ModuleArtifactMap;

public class ModuleArtifactRepository
extends ArtifactRepositoryBaseImpl<ModuleArtifactDescriptor> {
    public static final String REPOSITORY_TYPE = "org.eclipse.tycho.repository.module.ModuleArtifactRepository";
    private static final GAV DUMMY_GAV = null;
    private final File p2DataFile;
    private final ModuleArtifactMap artifactsMap;
    private GAV moduleGAV;

    public static boolean canAttemptRead(File repositoryDir) {
        File requiredP2ArtifactsFile = new File(repositoryDir, "p2artifacts.xml");
        File requiredLocalArtifactsFile = new File(repositoryDir, "local-artifacts.properties");
        return requiredP2ArtifactsFile.isFile() && requiredLocalArtifactsFile.isFile();
    }

    public static ModuleArtifactRepository restoreInstance(IProvisioningAgent agent, File repositoryDir) throws ProvisionException {
        ModuleArtifactRepository restoredInstance = new ModuleArtifactRepository(agent, repositoryDir, ModuleArtifactMap.restoreInstance(repositoryDir));
        restoredInstance.load();
        return restoredInstance;
    }

    public static ModuleArtifactRepository createInstance(IProvisioningAgent agent, File repositoryDir) throws ProvisionException {
        ModuleArtifactRepository newInstance = new ModuleArtifactRepository(agent, repositoryDir, ModuleArtifactRepository.createArtifactLocationMap(repositoryDir));
        newInstance.storeOrProvisioningException();
        return newInstance;
    }

    private static ModuleArtifactMap createArtifactLocationMap(File repositoryDir) throws ProvisionException {
        ModuleArtifactMap artifactLocationMap = ModuleArtifactMap.createInstance(repositoryDir);
        artifactLocationMap.add("p2artifacts", new File(repositoryDir, "p2artifacts.xml"));
        return artifactLocationMap;
    }

    private ModuleArtifactRepository(IProvisioningAgent agent, File location, ModuleArtifactMap artifactsMap) {
        super(agent, location.toURI(), ArtifactTransferPolicies.forLocalArtifacts());
        this.artifactsMap = artifactsMap;
        this.p2DataFile = artifactsMap.getLocalArtifactLocation(new MavenRepositoryCoordinates(DUMMY_GAV, "p2artifacts", "xml"));
    }

    public void setGAV(String groupId, String artifactId, String version) {
        this.moduleGAV = new GAV(groupId, artifactId, version);
    }

    public ModuleArtifactMap getArtifactsMap() {
        return this.artifactsMap;
    }

    @Override
    protected File internalGetArtifactStorageLocation(IArtifactDescriptor descriptor) {
        return this.artifactsMap.getLocalArtifactLocation(ModuleArtifactRepository.readMavenCoordinates(descriptor));
    }

    private static MavenRepositoryCoordinates readMavenCoordinates(IArtifactDescriptor descriptor) {
        if (descriptor instanceof ModuleArtifactDescriptor) {
            ModuleArtifactDescriptor moduleArtifactDescriptor = (ModuleArtifactDescriptor)descriptor;
            return moduleArtifactDescriptor.getMavenCoordinates();
        }
        MavenRepositoryCoordinates result = GAVArtifactDescriptorBase.readMavenCoordinateProperties(descriptor);
        if (result == null) {
            throw new IllegalArgumentException("Maven coordinate properties are missing in artifact descriptor " + descriptor);
        }
        return result;
    }

    @Override
    protected IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor descriptor) {
        if (descriptor instanceof ModuleArtifactDescriptor) {
            return descriptor;
        }
        return new ModuleArtifactComparableDescriptor(descriptor);
    }

    @Override
    protected ModuleArtifactDescriptor getInternalDescriptorForAdding(IArtifactDescriptor descriptor) throws IllegalArgumentException {
        if (descriptor == null) {
            throw new NullPointerException();
        }
        if (!(descriptor instanceof ModuleArtifactDescriptor) || descriptor.getRepository() != this) {
            throw new IllegalArgumentException("Cannot add artifact descriptor which has not been created by this repository");
        }
        ModuleArtifactDescriptor internalDescriptor = (ModuleArtifactDescriptor)descriptor;
        try {
            MavenRepositoryCoordinates coordinates = internalDescriptor.getMavenCoordinates();
            this.artifactsMap.addToAutomaticLocation(coordinates.getClassifier(), coordinates.getType());
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
        return internalDescriptor;
    }

    public ModuleArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        throw new UnsupportedOperationException();
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key, WriteSessionContext writeSession) {
        WriteSessionContext.ClassifierAndExtension additionalProperties = writeSession.getClassifierAndExtensionForNewKey(key);
        MavenRepositoryCoordinates mavenCoordinates = new MavenRepositoryCoordinates(this.moduleGAV, additionalProperties.classifier, additionalProperties.fileExtension);
        return new ModuleArtifactDescriptor(key, mavenCoordinates);
    }

    public IArtifactSink newAddingArtifactSink(IArtifactKey key, WriteSessionContext writeSession) throws ProvisionException {
        ModuleArtifactDescriptor internalDescriptorForAdding = this.getInternalDescriptorForAdding(this.createArtifactDescriptor(key, writeSession));
        return this.internalNewAddingArtifactSink(internalDescriptorForAdding);
    }

    @Override
    protected void internalStore(IProgressMonitor monitor) {
        try {
            this.saveToDisk();
        }
        catch (IOException e) {
            String message = "Error while writing repository to " + this.p2DataFile;
            throw new RuntimeException(message, e);
        }
    }

    private void storeOrProvisioningException() throws ProvisionException {
        try {
            this.saveToDisk();
        }
        catch (IOException e) {
            String message = "Error while writing repository to " + this.p2DataFile;
            int code = 1003;
            Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)e);
            throw new ProvisionException((IStatus)status);
        }
    }

    public void saveToDisk() throws IOException {
        ArtifactsIO io = new ArtifactsIO();
        io.writeXML(this.flattenedValues().collect(Collectors.toSet()), this.p2DataFile);
    }

    private void load() throws ProvisionException {
        try (FileInputStream p2DataFileStream = new FileInputStream(this.p2DataFile);){
            Set<IArtifactDescriptor> descriptors = new ArtifactsIO().readXML(p2DataFileStream);
            for (IArtifactDescriptor descriptor : descriptors) {
                ModuleArtifactDescriptor internalDescriptor = this.getInternalDescriptorFromLoadedDescriptor(descriptor, this.p2DataFile);
                this.internalAddInternalDescriptor(internalDescriptor);
            }
        }
        catch (IOException e) {
            throw ModuleArtifactRepository.failedReadException(this.p2DataFile, null, e);
        }
    }

    private ModuleArtifactDescriptor getInternalDescriptorFromLoadedDescriptor(IArtifactDescriptor loadedDescriptor, File sourceFile) throws ProvisionException {
        MavenRepositoryCoordinates mavenCoordinates = GAVArtifactDescriptorBase.readMavenCoordinateProperties(loadedDescriptor);
        if (mavenCoordinates != null) {
            return new ModuleArtifactDescriptor(loadedDescriptor, mavenCoordinates);
        }
        throw ModuleArtifactRepository.failedReadException(sourceFile, "Maven coordinate properties are missing in artifact descriptor " + loadedDescriptor, null);
    }

    static ProvisionException failedReadException(File sourceFile, String details, Exception exception) {
        String message = "Error while reading repository from " + sourceFile;
        if (details != null) {
            message = message + ": " + details;
        }
        int code = 1002;
        Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)exception);
        return new ProvisionException((IStatus)status);
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.contains(artifactKey);
    }

    class ModuleArtifactDescriptor
    extends GAVArtifactDescriptorBase {
        ModuleArtifactDescriptor(IArtifactDescriptor base, MavenRepositoryCoordinates mavenCoordinates) {
            super(base, mavenCoordinates, false);
        }

        ModuleArtifactDescriptor(IArtifactKey p2Key, MavenRepositoryCoordinates mavenCoordinates) {
            super(p2Key, mavenCoordinates, true);
        }

        public IArtifactRepository getRepository() {
            return ModuleArtifactRepository.this;
        }

        public boolean equals(Object obj) {
            IArtifactDescriptor other;
            if (obj == this) {
                return true;
            }
            return obj == this || obj instanceof IArtifactDescriptor && ((other = (IArtifactDescriptor)obj) instanceof ModuleArtifactDescriptor || other instanceof ModuleArtifactComparableDescriptor) && Objects.equals(this.key, other.getArtifactKey()) && Objects.equals(this.getProperty("format"), other.getProperty("format")) && Arrays.equals(this.processingSteps, other.getProcessingSteps());
        }
    }

    private static class ModuleArtifactComparableDescriptor
    extends ArtifactDescriptor {
        public ModuleArtifactComparableDescriptor(IArtifactDescriptor descriptor) {
            super(descriptor);
        }

        public boolean equals(Object obj) {
            IArtifactDescriptor other;
            return obj instanceof IArtifactDescriptor && ((other = (IArtifactDescriptor)obj) instanceof ModuleArtifactDescriptor || other instanceof ModuleArtifactComparableDescriptor) && Objects.equals(this.key, other.getArtifactKey()) && Objects.equals(this.getProperty("format"), other.getProperty("format")) && Arrays.equals(this.processingSteps, other.getProcessingSteps());
        }
    }
}

