/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.shared.MavenLogger;

public class FeaturePublisher {
    public static void publishFeatures(List<Feature> features, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, MavenLogger logger) {
        if (features.isEmpty()) {
            return;
        }
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        final HashMap featureMap = new HashMap();
        FeaturesAction action = new FeaturesAction((Feature[])features.toArray(Feature[]::new)){

            protected void publishFeatureArtifacts(Feature feature, IInstallableUnit featureIU, IPublisherInfo publisherInfo) {
            }

            protected IInstallableUnit generateFeatureJarIU(Feature feature, IPublisherInfo publisherInfo) {
                IInstallableUnit iu = super.generateFeatureJarIU(feature, publisherInfo);
                featureMap.put(iu, feature);
                return iu;
            }
        };
        PublisherResult results = new PublisherResult();
        action.perform((IPublisherInfo)publisherInfo, (IPublisherResult)results, null);
        IQueryResult result = results.query(QueryUtil.ALL_UNITS, null);
        for (IInstallableUnit unit : result) {
            Collection artifacts;
            if (logger != null) {
                logger.debug("Publishing installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
            }
            if ((artifacts = unit.getArtifacts()).isEmpty()) {
                consumer.accept(new IUArtifactDescriptor(unit), unit);
                continue;
            }
            Feature publishedFeature = (Feature)featureMap.get(unit);
            if (publishedFeature == null) {
                for (IArtifactKey key : artifacts) {
                    consumer.accept((IArtifactDescriptor)new ArtifactDescriptor(key), unit);
                }
                continue;
            }
            for (IArtifactKey key : artifacts) {
                IArtifactDescriptor fileDescriptor = FileArtifactRepository.forFile(new File(publishedFeature.getLocation()), key);
                consumer.accept(fileDescriptor, unit);
            }
        }
    }

    public static boolean isMetadataOnly(IArtifactDescriptor descriptor) {
        return descriptor instanceof IUArtifactDescriptor;
    }

    private static final class IUArtifactDescriptor
    implements IArtifactDescriptor {
        private IInstallableUnit iu;
        private ArtifactKey artifactKey;

        public IUArtifactDescriptor(IInstallableUnit iu) {
            this.iu = iu;
        }

        public IArtifactKey getArtifactKey() {
            if (this.artifactKey == null) {
                this.artifactKey = new ArtifactKey("org.eclipse.equinox.p2.iu", this.iu.getId(), this.iu.getVersion());
            }
            return this.artifactKey;
        }

        public String getProperty(String key) {
            return null;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public IProcessingStepDescriptor[] getProcessingSteps() {
            return new IProcessingStepDescriptor[0];
        }

        public IArtifactRepository getRepository() {
            return null;
        }
    }
}

