/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.repository.LazyArtifactRepository;
import org.eclipse.tycho.p2.repository.ListCompositeMetadataRepository;
import org.eclipse.tycho.p2.repository.RepositoryArtifactProvider;
import org.eclipse.tycho.p2.resolver.EmptyArtifactRepository;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;

public class URITargetDefinitionContent
implements TargetDefinitionContent {
    private IArtifactRepository artifactRepository;
    private IProvisioningAgent agent;
    private URI location;
    private String id;
    private IMetadataRepository metadataRepository;
    private ReferencedRepositoryMode referencedRepositoryMode;
    private MavenLogger logger;

    public URITargetDefinitionContent(IProvisioningAgent agent, URI location, String id, ReferencedRepositoryMode referencedRepositoryMode, MavenLogger logger) {
        this.agent = agent;
        this.location = location;
        this.id = id;
        this.referencedRepositoryMode = referencedRepositoryMode;
        this.logger = logger;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.preload((IProgressMonitor)subMonitor.split(100));
        subMonitor.setWorkRemaining(100);
        return this.getMetadataRepository().query(query, (IProgressMonitor)subMonitor.split(100));
    }

    public IMetadataRepository getMetadataRepository() {
        this.preload(null);
        return this.metadataRepository;
    }

    private synchronized void preload(IProgressMonitor monitor) {
        if (this.metadataRepository == null) {
            LinkedHashMap<URI, IMetadataRepository> metadataRepositoriesMap = new LinkedHashMap<URI, IMetadataRepository>();
            LinkedHashMap<URI, IArtifactRepository> artifactRepositoriesMap = new LinkedHashMap<URI, IArtifactRepository>();
            URI uri = this.location;
            try {
                URITargetDefinitionContent.loadMetadataRepositories(uri, this.id, metadataRepositoriesMap, artifactRepositoriesMap, this.referencedRepositoryMode == ReferencedRepositoryMode.include, this.agent, monitor, this.logger);
                URITargetDefinitionContent.loadArtifactRepositories(uri, artifactRepositoriesMap, this.agent, false, this.logger);
            }
            catch (ProvisionException e) {
                throw new TargetDefinitionResolutionException("Failed to load p2 metadata repository from location " + uri, (Throwable)e);
            }
            Collection metadataRepositories = metadataRepositoriesMap.values();
            this.metadataRepository = metadataRepositories.size() == 1 ? (IMetadataRepository)metadataRepositories.iterator().next() : new ListCompositeMetadataRepository(List.copyOf(metadataRepositories), this.agent);
            Collection artifactRepositories = artifactRepositoriesMap.values();
            this.artifactRepository = artifactRepositories.size() == 1 ? (IArtifactRepository)artifactRepositories.iterator().next() : new ListCompositeArtifactRepository(List.copyOf(artifactRepositories), this.agent);
        }
    }

    private static void loadMetadataRepositories(URI uri, String id, Map<URI, IMetadataRepository> metadataRepositories, Map<URI, IArtifactRepository> artifactRepositories, boolean includeReferenced, IProvisioningAgent agent, IProgressMonitor monitor, MavenLogger logger) throws ProvisionException {
        URI key = uri.normalize();
        if (metadataRepositories.containsKey(key)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
        if (metadataManager == null) {
            throw new TargetDefinitionResolutionException("IMetadataRepositoryManager is null in IProvisioningAgent");
        }
        IRepositoryIdManager repositoryIdManager = (IRepositoryIdManager)agent.getService(IRepositoryIdManager.class);
        if (repositoryIdManager != null) {
            repositoryIdManager.addMapping(id, uri);
        }
        IMetadataRepository repository = metadataManager.loadRepository(uri, (IProgressMonitor)subMonitor.split(50));
        metadataRepositories.put(key, repository);
        if (includeReferenced) {
            Collection references = repository.getReferences();
            subMonitor.setWorkRemaining(references.size());
            for (IRepositoryReference reference : references) {
                if ((reference.getOptions() & 1) == 0) continue;
                URI location = reference.getLocation();
                if (reference.getType() == 0) {
                    try {
                        URITargetDefinitionContent.loadMetadataRepositories(location, reference.getNickname(), metadataRepositories, artifactRepositories, includeReferenced, agent, (IProgressMonitor)subMonitor.split(1), logger);
                    }
                    catch (ProvisionException e) {
                        logger.warn("Skip referenced repository: " + location + ": " + e);
                    }
                    continue;
                }
                if (reference.getType() != 1) continue;
                URITargetDefinitionContent.loadArtifactRepositories(location, artifactRepositories, agent, true, logger);
                subMonitor.worked(1);
            }
        }
    }

    private static void loadArtifactRepositories(URI uri, Map<URI, IArtifactRepository> artifactRepositories, IProvisioningAgent agent, boolean referenced, MavenLogger logger) {
        URI key = uri.normalize();
        if (artifactRepositories.containsKey(key)) {
            return;
        }
        LazyArtifactRepository repository = referenced ? new LazyArtifactRepository(agent, uri, (u, a) -> {
            IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
            if (repositoryManager != null) {
                try {
                    return repositoryManager.loadRepository(u, null);
                }
                catch (ProvisionException e) {
                    logger.warn("Skip referenced repository: " + u + ": " + e);
                }
            }
            return new EmptyArtifactRepository((IProvisioningAgent)a, (URI)u);
        }) : new LazyArtifactRepository(agent, uri, RepositoryArtifactProvider::loadRepository);
        artifactRepositories.put(key, (IArtifactRepository)repository);
    }

    public IArtifactRepository getArtifactRepository() {
        this.preload(null);
        return this.artifactRepository;
    }
}

