/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.ArtifactFacadeProxy;

public final class WrappedArtifact
extends ArtifactFacadeProxy {
    private static final String WRAPPED_CLASSIFIER = "wrapped";
    private final File file;
    private final String classifier;
    private final String wrappedBsn;
    private final String wrappedVersion;
    private final Manifest manifest;

    public WrappedArtifact(File file, IArtifactFacade wrapped, String classifier, String wrappedBsn, String wrappedVersion, Manifest manifest) {
        super(wrapped);
        this.file = file;
        this.classifier = classifier;
        this.wrappedBsn = wrappedBsn;
        this.wrappedVersion = wrappedVersion;
        this.manifest = manifest;
    }

    @Override
    public File getLocation() {
        return this.file;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getPackagingType() {
        return "bundle";
    }

    public String getWrappedBsn() {
        return this.wrappedBsn;
    }

    public String getWrappedVersion() {
        return this.wrappedVersion;
    }

    public String getReferenceHint() {
        return "The artifact can be referenced in feature files with the following data: <plugin id=\"" + this.wrappedBsn + "\" version=\"" + this.wrappedVersion + "\"/>";
    }

    public String getGeneratedManifest() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Manifest manifest2 = this.getManifest();
            if (manifest2 != null) {
                manifest2.write(bout);
            }
        }
        catch (IOException e) {
            throw new AssertionError("should never happen", e);
        }
        return bout.toString(StandardCharsets.UTF_8);
    }

    public String toString() {
        return "WrappedArtifact [file=" + this.file + ", wrapped=" + super.toString() + ", classifier=" + this.classifier + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.classifier, this.file);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WrappedArtifact other = (WrappedArtifact)obj;
        return Objects.equals(this.classifier, other.classifier) && Objects.equals(this.file, other.file);
    }

    public static WrappedArtifact createWrappedArtifact(IArtifactFacade mavenArtifact, String prefix, File wrappedFile) throws Exception {
        return WrappedArtifact.createWrappedArtifact(mavenArtifact, WrappedArtifact.createPropertiesForPrefix(prefix), wrappedFile);
    }

    public static WrappedArtifact createWrappedArtifact(IArtifactFacade mavenArtifact, Properties bndInstructions, File wrappedFile) throws Exception {
        Object wrappedClassifier = WRAPPED_CLASSIFIER;
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            wrappedClassifier = classifier + "-wrapped";
        }
        wrappedFile.getParentFile().mkdirs();
        try (Jar jar = new Jar(mavenArtifact.getLocation());){
            WrappedArtifact wrappedArtifact;
            Manifest originalManifest = jar.getManifest();
            try (Analyzer analyzer = new Analyzer();){
                analyzer.setJar(jar);
                if (originalManifest != null) {
                    analyzer.mergeManifest(originalManifest);
                }
                analyzer.setProperty("mvnGroupId", mavenArtifact.getGroupId());
                analyzer.setProperty("mvnArtifactId", mavenArtifact.getArtifactId());
                analyzer.setProperty("mvnVersion", mavenArtifact.getVersion());
                analyzer.setProperty("mvnClassifier", Objects.requireNonNullElse(mavenArtifact.getClassifier(), ""));
                analyzer.setProperty("generatedOSGiVersion", WrappedArtifact.createOSGiVersionFromArtifact(mavenArtifact).toString());
                analyzer.setProperties(bndInstructions);
                Manifest manifest = analyzer.calcManifest();
                jar.setManifest(manifest);
                jar.write(wrappedFile);
                wrappedArtifact = new WrappedArtifact(wrappedFile, mavenArtifact, (String)wrappedClassifier, manifest.getMainAttributes().getValue("Bundle-SymbolicName").trim(), manifest.getMainAttributes().getValue("Bundle-Version").trim(), manifest);
            }
            return wrappedArtifact;
        }
    }

    public static Properties createPropertiesForPrefix(String prefix) {
        Properties properties = new Properties();
        properties.setProperty("Bundle-Name", "Bundle derived from maven artifact ${mvnGroupId}:${mvnArtifactId}:${mvnVersion}");
        properties.setProperty("Bundle-SymbolicName", prefix + ".${mvnGroupId}.${mvnArtifactId}");
        properties.setProperty("version", " ${version_cleanup;${mvnVersion}}");
        properties.setProperty("Bundle-Version", "${version}");
        properties.setProperty("Import-Package", "*;resolution:=optional");
        properties.setProperty("Export-Package", "*;version=\"${version}\";-noimport:=true");
        properties.setProperty("DynamicImport-Package", "*");
        return properties;
    }

    public static String createClassifierFromArtifact(String classifier) {
        if (classifier != null && !classifier.isEmpty()) {
            return classifier + "-wrapped";
        }
        return WRAPPED_CLASSIFIER;
    }

    public static String createClassifierFromArtifact(IArtifactFacade mavenArtifact) {
        return WrappedArtifact.createClassifierFromArtifact(mavenArtifact.getClassifier());
    }

    public static String createBundleSymbolicNameFromArtifact(String prefix, IArtifactFacade mavenArtifact) {
        String generatedBsn = prefix + "." + mavenArtifact.getGroupId() + "." + mavenArtifact.getArtifactId();
        String classifier = mavenArtifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            generatedBsn = generatedBsn + "." + classifier;
        }
        return generatedBsn;
    }

    public static Version createOSGiVersionFromArtifact(IArtifactFacade mavenArtifact) {
        String version = mavenArtifact.getVersion();
        return WrappedArtifact.createOSGiVersionFromMaven(version);
    }

    protected static Version createOSGiVersionFromMaven(String version) {
        if (version == null) {
            return Version.emptyVersion;
        }
        try {
            int index = version.indexOf(45);
            if (index > -1) {
                StringBuilder sb = new StringBuilder(version);
                sb.setCharAt(index, '.');
                return Version.parseVersion((String)sb.toString());
            }
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            return new Version(0, 0, 1, version);
        }
    }

    private Manifest getManifest() {
        if (this.manifest == null) {
            Manifest manifest;
            JarFile jarFile = new JarFile(this.file);
            try {
                manifest = jarFile.getManifest();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            jarFile.close();
            return manifest;
        }
        return this.manifest;
    }
}

