/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredPropertiesMatch;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2resolver.ResolverDebugUtils;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;
import org.eclipse.tycho.p2tools.copiedfromp2.Slicer;

abstract class AbstractSlicerResolutionStrategy
extends AbstractResolutionStrategy {
    protected AbstractSlicerResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    protected final IQueryable<IInstallableUnit> slice(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        return this.slice(properties, Collections.emptyList(), monitor);
    }

    protected final IQueryable<IInstallableUnit> slice(Map<String, String> properties, List<IInstallableUnit> additionalUnits, IProgressMonitor monitor) throws ResolverException {
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Properties: " + properties.toString());
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getAvailableIUs(), false));
            this.logger.debug("JRE IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getEEResolutionHints().getMandatoryUnits(), false));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getRootIUs(), true));
            if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IRequirement req : this.data.getAdditionalRequirements()) {
                    sb.append("   ").append(req.toString()).append("\n");
                }
                this.logger.debug("Extra Requirements:\n" + sb.toString());
            }
        }
        LinkedHashSet<IInstallableUnit> availableIUs = new LinkedHashSet<IInstallableUnit>(this.data.getAvailableIUs());
        availableIUs.addAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        availableIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        availableIUs.addAll(additionalUnits);
        LinkedHashSet<IInstallableUnit> seedIUs = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
        if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-extra", null, this.data.getAdditionalRequirements()));
        }
        seedIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        if (!this.data.getEEResolutionHints().getMandatoryRequires().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-ee", null, this.data.getEEResolutionHints().getMandatoryRequires()));
        }
        QueryableArray baseIUCollection = new QueryableArray(availableIUs, false);
        Slicer slicer = this.newSlicer((IQueryable<IInstallableUnit>)((IQueryable)(arg_0, arg_1) -> this.lambda$slice$0((IQueryable)baseIUCollection, arg_0, arg_1)), properties);
        IQueryable<IInstallableUnit> slice = slicer.slice(seedIUs, monitor);
        MultiStatus slicerStatus = slicer.getStatus();
        if (slice == null || this.isSlicerError(slicerStatus)) {
            throw new ResolverException(StatusTool.toLogMessage((IStatus)slicerStatus), properties.toString(), StatusTool.findException((IStatus)slicerStatus));
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Slice:\n" + ResolverDebugUtils.toDebugString(slice, false, monitor));
        }
        return slice;
    }

    protected abstract boolean isSlicerError(MultiStatus var1);

    protected abstract Slicer newSlicer(IQueryable<IInstallableUnit> var1, Map<String, String> var2);

    protected static IInstallableUnit createUnitRequiring(String name, Collection<IInstallableUnit> units, Collection<IRequirement> additionalRequirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        result.setId(name + "-" + time);
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        if (units != null) {
            for (IInstallableUnit unit : units) {
                requirements.add(AbstractSlicerResolutionStrategy.createStrictRequirementTo(unit));
            }
        }
        if (additionalRequirements != null) {
            requirements.addAll(additionalRequirements);
        }
        result.addRequirements(requirements);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    protected IInstallableUnit createUnitProviding(String name, Collection<IRequirement> requirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        result.setId(name + "-" + UUID.randomUUID());
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        for (IRequirement requirement : requirements) {
            if (requirement instanceof IRequiredCapability) {
                IRequiredCapability capability = (IRequiredCapability)requirement;
                try {
                    String namespace = capability.getNamespace();
                    IMatchExpression matches = capability.getMatches();
                    String extractName = RequiredCapability.extractName((IMatchExpression)matches);
                    Version version = RequiredCapability.extractRange((IMatchExpression)matches).getMinimum();
                    IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)extractName, (Version)version);
                    result.addProvidedCapabilities(Collections.singleton(providedCapability));
                }
                catch (RuntimeException e) {
                    this.logger.debug("Cannot convert requirement " + requirement + " to capability: " + e.toString(), e);
                }
                continue;
            }
            if (!(requirement instanceof RequiredPropertiesMatch)) continue;
            RequiredPropertiesMatch propertiesMatch = (RequiredPropertiesMatch)requirement;
            try {
                if (!AbstractSlicerResolutionStrategy.isEERequirement(requirement)) continue;
                IMatchExpression matches = propertiesMatch.getMatches();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Object p = matches.getParameters()[1];
                if (p instanceof IExpression) {
                    IExpression[] operands;
                    IExpression expression = (IExpression)p;
                    IExpression operand = ExpressionUtil.getOperand((IExpression)expression);
                    for (IExpression eq : operands = ExpressionUtil.getOperands((IExpression)operand)) {
                        IExpression lhs = ExpressionUtil.getLHS((IExpression)eq);
                        IExpression rhs = ExpressionUtil.getRHS((IExpression)eq);
                        Object value = ExpressionUtil.getValue((IExpression)rhs);
                        String key = ExpressionUtil.getName((IExpression)lhs);
                        if ("version".equals(key)) {
                            properties.put(key, Version.create((String)value.toString()));
                            continue;
                        }
                        properties.put(key, value.toString());
                    }
                }
                IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)RequiredPropertiesMatch.extractNamespace((IMatchExpression)matches), properties);
                result.addProvidedCapabilities(Collections.singleton(providedCapability));
            }
            catch (RuntimeException e) {
                this.logger.debug("Cannot convert requirement " + requirement + " to capability: " + e, e);
            }
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    protected static boolean isEERequirement(IRequirement requirement) {
        if (requirement instanceof RequiredPropertiesMatch) {
            RequiredPropertiesMatch propertiesMatch = (RequiredPropertiesMatch)requirement;
            String namespace = RequiredPropertiesMatch.extractNamespace((IMatchExpression)propertiesMatch.getMatches());
            return "osgi.ee".equals(namespace);
        }
        return false;
    }

    private static IRequirement createStrictRequirementTo(IInstallableUnit unit) {
        VersionRange strictRange = new VersionRange(unit.getVersion(), true, unit.getVersion(), true);
        int min = 1;
        int max = Integer.MAX_VALUE;
        boolean greedy = true;
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)strictRange, (IMatchExpression)unit.getFilter(), (int)min, (int)max, (boolean)greedy);
        return requirement;
    }

    private /* synthetic */ IQueryResult lambda$slice$0(IQueryable baseIUCollection, IQuery query, IProgressMonitor monitor1) {
        IQueryable<IInstallableUnit> additionalUnitStore;
        IQueryResult queryResult = baseIUCollection.query(query, monitor1);
        if (queryResult.isEmpty() && (additionalUnitStore = this.data.getAdditionalUnitStore()) != null) {
            return additionalUnitStore.query(query, monitor1);
        }
        return queryResult;
    }
}

