/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.repository.FileBasedTychoRepositoryIndex;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

@Component(role=LocalRepositoryP2Indices.class)
public class LocalRepositoryP2IndicesImpl
implements LocalRepositoryP2Indices {
    @Requirement
    private FileLockService fileLockService;
    @Requirement
    private MavenContext mavenContext;
    private File localRepositoryRoot;
    private boolean initialized = false;
    private TychoRepositoryIndex artifactsIndex;
    private TychoRepositoryIndex metadataIndex;

    public void setFileLockService(FileLockService fileLockService) {
        this.fileLockService = fileLockService;
    }

    private void checkInitialized() {
        if (this.initialized) {
            return;
        }
        this.artifactsIndex = FileBasedTychoRepositoryIndex.createArtifactsIndex(this.getLocalRepositoryRoot(), this.fileLockService, this.mavenContext);
        this.metadataIndex = FileBasedTychoRepositoryIndex.createMetadataIndex(this.getLocalRepositoryRoot(), this.fileLockService, this.mavenContext);
        this.initialized = true;
    }

    @Override
    public TychoRepositoryIndex getArtifactsIndex() {
        this.checkInitialized();
        return this.artifactsIndex;
    }

    @Override
    public TychoRepositoryIndex getMetadataIndex() {
        this.checkInitialized();
        return this.metadataIndex;
    }

    @Override
    public File getBasedir() {
        return this.getLocalRepositoryRoot();
    }

    @Override
    public MavenContext getMavenContext() {
        return this.mavenContext;
    }

    @Override
    public synchronized void add(GAV gav) throws IOException {
        TychoRepositoryIndex artifactsIndex = this.getArtifactsIndex();
        TychoRepositoryIndex metadataIndex = this.getMetadataIndex();
        LocalRepositoryP2IndicesImpl.addGavAndSave(gav, artifactsIndex);
        LocalRepositoryP2IndicesImpl.addGavAndSave(gav, metadataIndex);
    }

    private static void addGavAndSave(GAV gav, TychoRepositoryIndex index) throws IOException {
        index.addGav(gav);
        index.save();
    }

    public File getLocalRepositoryRoot() {
        if (this.localRepositoryRoot == null) {
            this.localRepositoryRoot = this.mavenContext.getLocalRepositoryRoot();
        }
        return this.localRepositoryRoot;
    }

    public void setLocalRepositoryRoot(File localRepositoryRoot) {
        this.localRepositoryRoot = localRepositoryRoot;
    }

    public void setMavenContext(MavenContext context) {
        this.mavenContext = context;
    }
}

