/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.maven.MavenArtifactFacade;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.p2.resolver.WrappedArtifact;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;

class PomInstallableUnitStore
implements IQueryable<IInstallableUnit> {
    private static final IQueryResult<IInstallableUnit> EMPTY_RESULT = new CollectionResult(Collections.emptyList());
    private IQueryable<IInstallableUnit> collection;
    private TychoProject tychoProject;
    private ReactorProject reactorProject;
    private Map<IInstallableUnit, PomDependency> installableUnitLookUp = new HashMap<IInstallableUnit, PomDependency>();
    private Collection<PomDependency> gatheredDependencies = new HashSet<PomDependency>();
    private List<Consumer<PomDependency>> dependencyConsumer = new ArrayList<Consumer<PomDependency>>();
    private InstallableUnitGenerator generator;
    private PomDependencies considerPomDependencies;
    private ArtifactHandlerManager artifactHandlerManager;
    private Logger logger;
    private TargetPlatformConfiguration configuration;

    public PomInstallableUnitStore(TychoProject tychoProject, ReactorProject reactorProject, InstallableUnitGenerator generator, ArtifactHandlerManager artifactHandlerManager, Logger logger, TargetPlatformConfiguration configuration) {
        this.tychoProject = tychoProject;
        this.reactorProject = reactorProject;
        this.generator = generator;
        this.artifactHandlerManager = artifactHandlerManager;
        this.logger = logger;
        this.configuration = configuration;
        this.considerPomDependencies = Optional.ofNullable(configuration).map(TargetPlatformConfiguration::getPomDependencies).orElse(PomDependencies.ignore);
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (this.considerPomDependencies == PomDependencies.ignore) {
            return EMPTY_RESULT;
        }
        IQueryResult result = this.getPomIUs().query(query, monitor);
        for (IInstallableUnit unit : result) {
            PomDependency pomDependency = this.installableUnitLookUp.get(unit);
            if (pomDependency == null || !this.gatheredDependencies.add(pomDependency)) continue;
            for (Consumer<PomDependency> consumer : this.dependencyConsumer) {
                consumer.accept(pomDependency);
            }
        }
        return result;
    }

    private IQueryable<IInstallableUnit> getPomIUs() {
        if (this.collection == null) {
            PublisherInfo publisherInfo = new PublisherInfo();
            publisherInfo.setArtifactOptions(1);
            ArrayList<Artifact> initalArtifacts = new ArrayList<Artifact>(this.tychoProject.getInitialArtifacts(this.reactorProject, List.of("test")));
            this.addBuildReactorProjects(initalArtifacts);
            Map<Artifact, IArtifactFacade> facadeMap = this.tychoProject.getArtifactFacades(this.reactorProject, initalArtifacts);
            for (Artifact artifact : initalArtifacts) {
                IArtifactFacade facade = facadeMap.get(artifact);
                this.getArtifactStream(artifact, facade).forEach(a -> {
                    Collection units;
                    if (a.getFile() == null) {
                        Object patt5629$temp = facadeMap.get(a);
                        if (!(patt5629$temp instanceof ReactorProjectFacade)) {
                            this.logger.debug("Skip artifact " + a + " because it is not resolved!");
                            return;
                        }
                        ReactorProjectFacade reactorFacade = (ReactorProjectFacade)patt5629$temp;
                        ReactorProject prj = reactorFacade.getReactorProject();
                        units = this.generator.getProvidedInstallableUnits(prj);
                        if (units.isEmpty()) {
                            this.logger.debug("Skip artifact " + a + " because it is not resolved and can't gather any units for it...");
                            return;
                        }
                    } else {
                        if (this.configuration.isExcluded(a.getGroupId(), a.getArtifactId())) {
                            this.logger.debug("Skip artifact " + a + " because it is excluded...");
                            return;
                        }
                        units = this.generator.getInstallableUnits(a);
                    }
                    this.logger.debug("artifact " + a + " maps to " + units);
                    IArtifactFacade artifactFacade = a.hasClassifier() ? new MavenArtifactFacade((Artifact)a) : facade;
                    boolean wrapHasErrors = false;
                    if (this.considerPomDependencies == PomDependencies.wrapAsBundle && units.isEmpty() && a == artifact) {
                        String relativePath = RepositoryLayoutHelper.getRelativePath(a.getGroupId(), a.getArtifactId(), a.getVersion(), WrappedArtifact.createClassifierFromArtifact(a.getClassifier()), this.artifactHandlerManager.getArtifactHandler(a.getType()).getExtension());
                        File wrappedFile = new File(new File(this.reactorProject.getBasedir(), ".m2"), relativePath);
                        try {
                            WrappedArtifact wrappedArtifact = WrappedArtifact.createWrappedArtifact(artifactFacade, this.reactorProject.getGroupId(), wrappedFile);
                            artifactFacade = wrappedArtifact;
                            File wrappedLocation = artifactFacade.getLocation();
                            a.setFile(wrappedLocation);
                            units = this.generator.getInstallableUnits(a);
                            this.logger.warn("Maven Artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + " is not a bundle and was automatically wrapped with bundle-symbolic name " + wrappedArtifact.getWrappedBsn() + ", ignoring such artifacts can be enabled with <pomDependencies>" + PomDependencies.consider + "</pomDependencies> in target platform configuration.");
                            this.logger.info(wrappedArtifact.getReferenceHint());
                        }
                        catch (Exception e) {
                            wrapHasErrors = true;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.error("wrapping " + a.getId() + " @ " + a.getFile() + " failed and is ignored", (Throwable)e);
                            }
                            this.logger.warn("wrapping " + a.getId() + " failed and is ignored, enable debug output for details.");
                        }
                    }
                    if (units.isEmpty()) {
                        if (a != artifact) return;
                        if (this.considerPomDependencies == PomDependencies.wrapAsBundle) return;
                        if (wrapHasErrors) return;
                        this.logger.info("Maven Artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + " @ " + a.getFile() + " is not a bundle and will be ignored, automatic wrapping of such artifacts can be enabled with <pomDependencies>" + PomDependencies.wrapAsBundle.name() + "</pomDependencies> in target platform configuration.");
                        return;
                    }
                    PomDependency value = a.hasClassifier() ? new PomDependency(new MavenArtifactFacade((Artifact)a), units, a.getFile()) : new PomDependency(facade, units, a.getFile());
                    Iterator iterator = units.iterator();
                    while (iterator.hasNext()) {
                        IInstallableUnit unit = (IInstallableUnit)iterator.next();
                        this.installableUnitLookUp.put(unit, value);
                    }
                });
            }
            this.collection = new QueryableArray(this.installableUnitLookUp.keySet(), false);
        }
        return this.collection;
    }

    private void addBuildReactorProjects(Collection<Artifact> initalArtifacts) {
        MavenSession mavenSession = (MavenSession)this.reactorProject.adapt(MavenSession.class);
        if (mavenSession != null) {
            for (MavenProject mavenProject : mavenSession.getProjects()) {
                if (!"jar".equals(mavenProject.getPackaging())) continue;
                initalArtifacts.add(mavenProject.getArtifact());
            }
        }
    }

    private Stream<Artifact> getArtifactStream(Artifact artifact, IArtifactFacade facade) {
        ReactorProjectFacade projectFacade;
        MavenProject mavenProject;
        if (facade instanceof ReactorProjectFacade && (mavenProject = (MavenProject)(projectFacade = (ReactorProjectFacade)facade).getReactorProject().adapt(MavenProject.class)) != null) {
            return Stream.concat(Stream.of(mavenProject.getArtifact()), this.safeCopy(mavenProject.getAttachedArtifacts()).stream());
        }
        return Stream.of(artifact);
    }

    private List<Artifact> safeCopy(List<Artifact> list) {
        while (true) {
            try {
                ArrayList<Artifact> copyList = new ArrayList<Artifact>();
                for (Artifact a : list) {
                    if (a == null) continue;
                    copyList.add(a);
                }
                return copyList;
            }
            catch (ConcurrentModificationException e) {
                Thread.yield();
                continue;
            }
            break;
        }
    }

    void addPomDependencyConsumer(Consumer<PomDependency> consumer) {
        this.gatheredDependencies.forEach(consumer);
        this.dependencyConsumer.add(consumer);
    }

    record PomDependency(IArtifactFacade artifactFacade, Collection<IInstallableUnit> installableUnit, File location) {
    }
}

