/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.core.resolver.target.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.repository.LocalArtifactRepository;
import org.eclipse.tycho.p2.repository.LocalMetadataRepository;
import org.eclipse.tycho.p2.repository.ProviderOnlyArtifactRepository;
import org.eclipse.tycho.p2resolver.TargetPlatformBaseImpl;

public class PreliminaryTargetPlatformImpl
extends TargetPlatformBaseImpl {
    private final Collection<IInstallableUnit> externalIUs;
    private final LocalMetadataRepository localMetadataRepository;
    private final MavenLogger logger;
    private final TargetPlatformFilterEvaluator filter;
    private final boolean includeLocalRepo;
    private IArtifactRepository artifactRepository;

    public PreliminaryTargetPlatformImpl(Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectIUs, Collection<IInstallableUnit> externalIUs, ExecutionEnvironmentResolutionHints executionEnvironment, TargetPlatformFilterEvaluator filter, LocalMetadataRepository localMetadataRepository, IRawArtifactFileProvider externalArtifacts, LocalArtifactRepository localArtifactRepository, boolean includeLocalRepo, MavenLogger logger, Set<IInstallableUnit> shadowed, IProvisioningAgent remoteAgent) {
        super(PreliminaryTargetPlatformImpl.collectAllInstallableUnits(reactorProjectIUs, externalIUs, executionEnvironment), executionEnvironment, externalArtifacts, localArtifactRepository, reactorProjectIUs, new HashMap<IInstallableUnit, IArtifactFacade>(), shadowed);
        this.externalIUs = externalIUs;
        this.filter = filter;
        this.localMetadataRepository = localMetadataRepository;
        this.includeLocalRepo = includeLocalRepo;
        this.logger = logger;
        this.artifactRepository = new ProviderOnlyArtifactRepository(this.artifacts, remoteAgent, URI.create("preliminary:/"));
    }

    public static LinkedHashSet<IInstallableUnit> collectAllInstallableUnits(Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectIUs, Collection<IInstallableUnit> externalIUs, ExecutionEnvironmentResolutionHints executionEnvironment) {
        LinkedHashSet<IInstallableUnit> allius = new LinkedHashSet<IInstallableUnit>();
        allius.addAll(reactorProjectIUs.keySet());
        allius.addAll(externalIUs);
        allius.addAll(executionEnvironment.getMandatoryUnits());
        return allius;
    }

    public void reportUsedLocalIUs(Collection<IInstallableUnit> usedUnits) {
        if (!this.includeLocalRepo) {
            return;
        }
        Set localIUs = this.localMetadataRepository.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, null).toSet();
        localIUs.retainAll(usedUnits);
        Iterator iterator = localIUs.iterator();
        while (iterator.hasNext()) {
            if (!this.executionEnvironment.isNonApplicableEEUnit((IInstallableUnit)iterator.next())) continue;
            iterator.remove();
        }
        if (!localIUs.isEmpty()) {
            this.logger.warn("The following locally built units have been used to resolve project dependencies:");
            for (IInstallableUnit localIu : localIUs) {
                this.logger.warn("  " + localIu.getId() + "/" + localIu.getVersion());
            }
        }
    }

    public LinkedHashSet<IInstallableUnit> getExternalUnits() {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        result.addAll(this.externalIUs);
        result.addAll(this.executionEnvironment.getMandatoryUnits());
        return result;
    }

    public TargetPlatformFilterEvaluator getFilter() {
        return this.filter;
    }

    public IRawArtifactFileProvider getExternalArtifacts() {
        return this.artifacts;
    }

    public IMetadataRepository getMetadataRepository() {
        throw new UnsupportedOperationException();
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

