/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.resolver.target.SupplierMetadataRepository;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.resolver.BundlePublisher;
import org.eclipse.tycho.p2.resolver.FeaturePublisher;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.p2maven.transport.TychoRepositoryTransport;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class RepositoryLocationContent
implements TargetDefinitionContent {
    private final Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private SupplierMetadataRepository metadataRepository;
    private FileArtifactRepository artifactRepository;

    public RepositoryLocationContent(URI uri, Collection<Requirement> requirements, IProvisioningAgent agent, MavenLogger logger) throws TargetDefinitionResolutionException {
        ResourcesRepository repository;
        TychoRepositoryTransport tychoTransport = (TychoRepositoryTransport)agent.getService(Transport.class);
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.repositoryContent.values().iterator());
        this.metadataRepository.setLocation(uri);
        this.metadataRepository.setName(String.valueOf(uri));
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.repositoryContent.keySet().stream().filter(Predicate.not(FeaturePublisher::isMetadataOnly)).iterator());
        this.artifactRepository.setName(String.valueOf(uri));
        this.artifactRepository.setLocation(uri);
        ArrayList<Feature> features = new ArrayList<Feature>();
        try (InputStream stream = tychoTransport.stream(uri, null);){
            repository = new ResourcesRepository((Collection)XMLResourceParser.getResources((InputStream)stream, (URI)uri));
        }
        catch (Exception e) {
            throw new TargetDefinitionResolutionException("Can't load the repository from URI " + uri, (Throwable)e);
        }
        Map providers = repository.findProviders(requirements);
        List<ResourceUtils.ContentCapability> contentCapabilities = providers.values().stream().flatMap(Collection::stream).map(Capability::getResource).distinct().map(ResourceUtils::getContentCapability).filter(Objects::nonNull).toList();
        for (ResourceUtils.ContentCapability content : contentCapabilities) {
            URI url = content.url();
            logger.info("Loading " + url + "...");
            try {
                File file = tychoTransport.downloadToFile(url);
                if (!"jar".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()))) {
                    logger.info("Skip non-jar artifact (" + file + ")");
                    continue;
                }
                Feature feature = new FeatureParser().parse(file);
                if (feature != null) {
                    feature.setLocation(file.getAbsolutePath());
                    features.add(feature);
                    continue;
                }
                BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)file);
                if (bundleDescription == null || bundleDescription.getSymbolicName() == null) continue;
                this.publish(bundleDescription, file);
            }
            catch (Exception e) {
                throw new TargetDefinitionResolutionException("Can't fetch resource from " + url, (Throwable)e);
            }
        }
        FeaturePublisher.publishFeatures(features, this.repositoryContent::put, logger);
    }

    private void publish(BundleDescription bundleDescription, File bundleLocation) {
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(bundleLocation, key);
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        IInstallableUnit iu = BundlePublisher.publishBundle(bundleDescription, descriptor, publisherInfo);
        this.repositoryContent.put(descriptor, iu);
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

