/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2resolver.ResolutionData;

public class ResolutionDataImpl
implements ResolutionData {
    private final ExecutionEnvironmentResolutionHints eeResolutionHints;
    private Collection<IInstallableUnit> availableIUs;
    private Collection<IInstallableUnit> rootIUs;
    private List<IRequirement> additionalRequirements;
    private Map<String, String> additionalFilterProperties;
    private Predicate<IInstallableUnit> slicerPredicate;
    private IQueryable<IInstallableUnit> additionalUnitStore;

    public ResolutionDataImpl(ExecutionEnvironmentResolutionHints eeResolutionHints) {
        this.eeResolutionHints = eeResolutionHints;
    }

    @Override
    public Collection<IInstallableUnit> getAvailableIUs() {
        return this.availableIUs;
    }

    public void setAvailableIUs(Collection<IInstallableUnit> availableIUs) {
        this.availableIUs = availableIUs;
    }

    public void setAvailableIUsAndFilter(IQueryable<IInstallableUnit> unfilteredAvailableUnits) {
        this.availableIUs = new LinkedHashSet<IInstallableUnit>();
        IQueryResult allUnits = unfilteredAvailableUnits.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor());
        ResolutionDataImpl.copyApplyingEEFilter(allUnits.iterator(), this.availableIUs, this.eeResolutionHints);
    }

    private static void copyApplyingEEFilter(Iterator<IInstallableUnit> source, Collection<IInstallableUnit> sink, ExecutionEnvironmentResolutionHints eeResolutionHints) {
        while (source.hasNext()) {
            IInstallableUnit unit = source.next();
            if (eeResolutionHints.isNonApplicableEEUnit(unit)) continue;
            sink.add(unit);
        }
    }

    @Override
    public Collection<IInstallableUnit> getRootIUs() {
        return this.rootIUs;
    }

    public void setRootIUs(Collection<IInstallableUnit> rootIUs) {
        this.rootIUs = rootIUs;
    }

    @Override
    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public void setAdditionalRequirements(List<IRequirement> additionalRequirements) {
        this.additionalRequirements = additionalRequirements;
    }

    @Override
    public ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.eeResolutionHints;
    }

    @Override
    public Map<String, String> getAdditionalFilterProperties() {
        if (this.additionalFilterProperties == null) {
            return Collections.emptyMap();
        }
        return this.additionalFilterProperties;
    }

    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        this.additionalFilterProperties = additionalFilterProperties;
    }

    @Override
    public Predicate<IInstallableUnit> getIInstallableUnitAcceptor() {
        return this.slicerPredicate;
    }

    public void setSlicerPredicate(Predicate<IInstallableUnit> slicerPredicate) {
        this.slicerPredicate = slicerPredicate;
    }

    @Override
    public IQueryable<IInstallableUnit> getAdditionalUnitStore() {
        return this.additionalUnitStore;
    }

    public void setAdditionalUnitStore(IQueryable<IInstallableUnit> additionalUnitStore) {
        this.additionalUnitStore = additionalUnitStore;
    }
}

