/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.p2.repository.MetadataIO;

class ResolverDebugUtils {
    ResolverDebugUtils() {
    }

    public static String toDebugString(IQueryable<IInstallableUnit> ius, boolean verbose, IProgressMonitor monitor) {
        IQueryResult collector = ius.query(QueryUtil.ALL_UNITS, monitor);
        return ResolverDebugUtils.toDebugString(collector.toUnmodifiableSet(), verbose);
    }

    public static String toDebugString(Collection<IInstallableUnit> ius, boolean verbose) {
        if (ius == null || ius.isEmpty()) {
            return "<empty>";
        }
        if (verbose) {
            String string;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                new MetadataIO().writeXML(new LinkedHashSet<IInstallableUnit>(ius), os);
                string = os.toString(StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            os.close();
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (IInstallableUnit iu : ius) {
            sb.append("  ").append(iu.toString()).append("\n");
        }
        return sb.toString();
    }
}

