/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenArtifactKey;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.ee.impl.ExecutionEnvironmentResolutionHandler;
import org.eclipse.tycho.core.osgitools.ClasspathReader;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.core.resolver.target.DuplicateReactorIUsException;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.resolver.target.TargetPlatformFilterEvaluator;
import org.eclipse.tycho.core.shared.DuplicateFilteringLoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.model.classpath.JUnitBundle;
import org.eclipse.tycho.model.classpath.JUnitClasspathContainerEntry;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;
import org.eclipse.tycho.p2.repository.ArtifactRepositoryBlackboard;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicies;
import org.eclipse.tycho.p2.repository.CompositeArtifactProvider;
import org.eclipse.tycho.p2.repository.FileRepositoryArtifactProvider;
import org.eclipse.tycho.p2.repository.LazyArtifactRepository;
import org.eclipse.tycho.p2.repository.LocalArtifactRepository;
import org.eclipse.tycho.p2.repository.LocalMetadataRepository;
import org.eclipse.tycho.p2.repository.MirroringArtifactProvider;
import org.eclipse.tycho.p2.repository.ProviderOnlyArtifactRepository;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.repository.RepositoryArtifactProvider;
import org.eclipse.tycho.p2.repository.RepositoryBlackboardKey;
import org.eclipse.tycho.p2.resolver.BundlePublisher;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;
import org.eclipse.tycho.p2resolver.FinalTargetPlatformImpl;
import org.eclipse.tycho.p2resolver.MissingBundlesArtifactFileProvider;
import org.eclipse.tycho.p2resolver.PomDependencyCollectorImpl;
import org.eclipse.tycho.p2resolver.PreliminaryTargetPlatformImpl;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolverService;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;
import org.eclipse.tycho.targetplatform.P2TargetPlatform;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetPlatformFilter;
import org.osgi.framework.BundleException;

public class TargetPlatformFactoryImpl
implements TargetPlatformFactory {
    private static final Version DEFAULT_P2_ADVICE_VERSION = Version.parseVersion((String)"1.0.0.qualifier");
    private final MavenContext mavenContext;
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private final IProvisioningAgent remoteAgent;
    private final IRepositoryIdManager remoteRepositoryIdManager;
    private final IMetadataRepositoryManager remoteMetadataRepositoryManager;
    private final IArtifactRepositoryManager remoteArtifactRepositoryManager;
    private final boolean offline;
    private final LocalArtifactRepository localArtifactRepository;
    private final LocalMetadataRepository localMetadataRepository;
    private final TargetDefinitionResolverService targetDefinitionResolverService;
    private TychoProjectManager projectManager;
    private MavenBundleResolver mavenBundleResolver;

    public TargetPlatformFactoryImpl(MavenContext mavenContext, IProvisioningAgent remoteAgent, LocalArtifactRepository localArtifactRepo, LocalMetadataRepository localMetadataRepo, TargetDefinitionResolverService targetDefinitionResolverService, IRepositoryIdManager repositoryIdManager, TychoProjectManager projectManager, MavenBundleResolver mavenBundleResolver) {
        this.mavenContext = mavenContext;
        this.projectManager = projectManager;
        this.mavenBundleResolver = mavenBundleResolver;
        this.logger = mavenContext.getLogger();
        this.monitor = new DuplicateFilteringLoggingProgressMonitor(this.logger);
        this.remoteAgent = remoteAgent;
        this.remoteRepositoryIdManager = repositoryIdManager;
        this.offline = mavenContext.isOffline();
        this.remoteMetadataRepositoryManager = (IMetadataRepositoryManager)remoteAgent.getService(IMetadataRepositoryManager.class);
        if (this.remoteMetadataRepositoryManager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        this.remoteArtifactRepositoryManager = (IArtifactRepositoryManager)remoteAgent.getService(IArtifactRepositoryManager.class);
        if (this.remoteArtifactRepositoryManager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        this.localMetadataRepository = localMetadataRepo;
        this.localArtifactRepository = localArtifactRepo;
        this.targetDefinitionResolverService = targetDefinitionResolverService;
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects) {
        return this.createTargetPlatform(tpConfiguration, ExecutionEnvironmentResolutionHandler.adapt(eeConfiguration, this.logger), reactorProjects);
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects, ReactorProject project) {
        return this.createTargetPlatform(tpConfiguration, ExecutionEnvironmentResolutionHandler.adapt(eeConfiguration, this.logger), reactorProjects, project);
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentResolutionHandler eeResolutionHandler, List<ReactorProject> reactorProjects) {
        return this.createTargetPlatform(tpConfiguration, eeResolutionHandler, reactorProjects, null);
    }

    public P2TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentResolutionHandler eeResolutionHandler, List<ReactorProject> reactorProjects, ReactorProject project) {
        List<TargetDefinitionContent> targetFileContent = this.resolveTargetDefinitions(tpConfiguration, eeResolutionHandler.getResolutionHints());
        Set<MavenRepositoryLocation> completeRepositories = tpConfiguration.getP2Repositories();
        this.registerRepositoryIDs(completeRepositories);
        LinkedHashSet<URI> artifactRepositories = new LinkedHashSet<URI>();
        boolean includeLocalMavenRepo = !tpConfiguration.getIgnoreLocalArtifacts();
        LinkedHashSet<IInstallableUnit> externalUIs = this.gatherExternalInstallableUnits(completeRepositories, targetFileContent, includeLocalMavenRepo, artifactRepositories, tpConfiguration.getIncludeRefererenced() == ReferencedRepositoryMode.include);
        List<MavenArtifactKey> junitBundles = this.getMissingJunitBundles(project, externalUIs);
        MissingBundlesArtifactFileProvider extraMavenBundles = new MissingBundlesArtifactFileProvider();
        for (MavenArtifactKey mavenArtifactKey : junitBundles) {
            Optional<ResolvedArtifactKey> mavenBundle = this.mavenBundleResolver.resolveMavenBundle((MavenProject)project.adapt(MavenProject.class), (MavenSession)project.adapt(MavenSession.class), mavenArtifactKey);
            mavenBundle.flatMap(key -> {
                File bundleFile = key.getLocation();
                try {
                    MavenPropertiesAdvice advice = new MavenPropertiesAdvice(mavenArtifactKey.getGroupId(), mavenArtifactKey.getArtifactId(), key.getVersion());
                    Optional<IInstallableUnit> iu = BundlePublisher.getBundleIU(bundleFile, new IPublisherAdvice[]{advice});
                    IInstallableUnit unit = iu.orElse(null);
                    if (unit != null) {
                        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
                        unit.getProperties().forEach((k, v) -> description.setProperty(k, v));
                        description.setId(unit.getId());
                        description.setVersion(unit.getVersion());
                        description.addProvidedCapabilities(unit.getProvidedCapabilities());
                        if (!mavenArtifactKey.getId().equals(unit.getId())) {
                            IProvidedCapability cap = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)mavenArtifactKey.getId(), (Version)unit.getVersion());
                            description.addProvidedCapabilities(List.of(cap));
                        }
                        IArtifactKey[] artifactKeys = (IArtifactKey[])unit.getArtifacts().toArray(IArtifactKey[]::new);
                        description.setArtifacts(artifactKeys);
                        for (IArtifactKey mavenkey : artifactKeys) {
                            extraMavenBundles.add(mavenkey, bundleFile);
                        }
                        return Optional.of(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description));
                    }
                }
                catch (IOException iOException) {
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
                return Optional.empty();
            }).ifPresent(externalUIs::add);
        }
        for (ReactorProject reactorProject : Objects.requireNonNullElse(reactorProjects, List.of())) {
            this.gatherP2InfUnits(reactorProject, externalUIs);
        }
        Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectUIs = this.getPreliminaryReactorProjectUIs(reactorProjects);
        List<TargetPlatformFilter> iuFilters = tpConfiguration.getFilters();
        TargetPlatformFilterEvaluator filter = !iuFilters.isEmpty() ? new TargetPlatformFilterEvaluator(iuFilters, this.logger) : null;
        TargetPlatformFactoryImpl.applyConfiguredFilter(filter, reactorProjectUIs.keySet());
        HashSet<IInstallableUnit> shadowed = new HashSet<IInstallableUnit>();
        this.applyFilters(filter, externalUIs, reactorProjectUIs.keySet(), eeResolutionHandler.getResolutionHints(), shadowed);
        IRawArtifactFileProvider externalArtifactFileProvider = this.createExternalArtifactProvider(artifactRepositories, targetFileContent, extraMavenBundles);
        PreliminaryTargetPlatformImpl targetPlatform = new PreliminaryTargetPlatformImpl(reactorProjectUIs, externalUIs, eeResolutionHandler.getResolutionHints(), filter, this.localMetadataRepository, externalArtifactFileProvider, this.localArtifactRepository, includeLocalMavenRepo, this.logger, shadowed, this.remoteAgent);
        eeResolutionHandler.readFullSpecification(targetPlatform.getInstallableUnits());
        return targetPlatform;
    }

    private void gatherP2InfUnits(ReactorProject reactorProject, Set<IInstallableUnit> externalUIs) {
        MetadataFactory.InstallableUnitDescription[] descriptions;
        AdviceFileAdvice advice;
        if (reactorProject == null) {
            return;
        }
        if ("eclipse-plugin".equals(reactorProject.getPackaging())) {
            advice = new AdviceFileAdvice(reactorProject.getArtifactId(), this.getVersion(reactorProject), (IPath)new Path(reactorProject.getBasedir().getAbsolutePath()), AdviceFileAdvice.BUNDLE_ADVICE_FILE);
        } else if ("eclipse-feature".equals(reactorProject.getPackaging())) {
            advice = new AdviceFileAdvice(reactorProject.getArtifactId(), this.getVersion(reactorProject), (IPath)new Path(reactorProject.getBasedir().getAbsolutePath()), (IPath)new Path("p2.inf"));
        } else {
            return;
        }
        if (advice.containsAdvice() && (descriptions = advice.getAdditionalInstallableUnitDescriptions(null)) != null && descriptions.length > 0) {
            for (MetadataFactory.InstallableUnitDescription desc : descriptions) {
                externalUIs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc));
            }
        }
    }

    private Version getVersion(ReactorProject reactorProject) {
        if (this.projectManager == null) {
            return DEFAULT_P2_ADVICE_VERSION;
        }
        try {
            return this.projectManager.getArtifactKey(reactorProject).map(key -> Version.parseVersion((String)key.getVersion())).orElseGet(() -> DEFAULT_P2_ADVICE_VERSION);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_P2_ADVICE_VERSION;
        }
    }

    private List<MavenArtifactKey> getMissingJunitBundles(ReactorProject project, Set<IInstallableUnit> externalUIs) {
        ArrayList<MavenArtifactKey> missing = new ArrayList<MavenArtifactKey>();
        if (this.projectManager != null) {
            Optional<TychoProject> tychoProject = this.projectManager.getTychoProject(project);
            tychoProject.filter(OsgiBundleProject.class::isInstance).map(OsgiBundleProject.class::cast).map(obp -> obp.getEclipsePluginProject(project)).ifPresent(eclipseProject -> {
                Collection<ProjectClasspathEntry> entries = eclipseProject.getClasspathEntries();
                for (ProjectClasspathEntry entry : entries) {
                    if (!(entry instanceof JUnitClasspathContainerEntry)) continue;
                    JUnitClasspathContainerEntry junit = (JUnitClasspathContainerEntry)entry;
                    QueryableArray queriable = new QueryableArray(externalUIs, false);
                    Collection artifacts = junit.getArtifacts();
                    for (JUnitBundle bundle : artifacts) {
                        MavenArtifactKey maven = ClasspathReader.toMaven(bundle);
                        VersionRange range = new VersionRange(maven.getVersion());
                        IQuery<IInstallableUnit> query = ArtifactTypeHelper.createQueryFor(maven.getType(), maven.getId(), range);
                        IQueryResult result = queriable.query(QueryUtil.createLatestQuery(query), this.monitor);
                        if (!result.isEmpty()) continue;
                        missing.add(maven);
                    }
                }
            });
        }
        return missing;
    }

    private List<TargetDefinitionContent> resolveTargetDefinitions(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentResolutionHints eeResolutionHints) {
        ArrayList<TargetDefinitionContent> result = new ArrayList<TargetDefinitionContent>();
        for (TargetDefinition definition : tpConfiguration.getTargetDefinitions()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding target definition file \"" + definition.getOrigin() + "\"");
            }
            TargetDefinitionContent targetFileContent = this.targetDefinitionResolverService.getTargetDefinitionContent(definition, tpConfiguration.getEnvironments(), eeResolutionHints, tpConfiguration.getIncludeSourceMode(), tpConfiguration.getIncludeRefererenced(), this.remoteAgent);
            result.add(targetFileContent);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Target definition file contains " + targetFileContent.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet().size() + " units");
        }
        return result;
    }

    private void registerRepositoryIDs(Set<MavenRepositoryLocation> repositoriesWithIDs) {
        for (MavenRepositoryLocation location : repositoriesWithIDs) {
            this.remoteRepositoryIdManager.addMapping(location.getId(), location.getURL());
        }
    }

    private LinkedHashSet<IInstallableUnit> gatherExternalInstallableUnits(Set<MavenRepositoryLocation> completeRepositories, List<TargetDefinitionContent> targetDefinitionsContent, boolean includeLocalMavenRepo, Set<URI> artifactRepositories, boolean includeReferences) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (TargetDefinitionContent targetDefinitionContent : targetDefinitionsContent) {
            IQueryResult queryResult = targetDefinitionContent.query(QueryUtil.ALL_UNITS, this.monitor);
            result.addAll(queryResult.toUnmodifiableSet());
        }
        ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
        HashSet<URI> loaded = new HashSet<URI>();
        for (MavenRepositoryLocation location : completeRepositories) {
            artifactRepositories.add(location.getURL());
            try {
                this.loadMetadataRepository(location, metadataRepositories, loaded, artifactRepositories, includeReferences);
            }
            catch (ProvisionException e) {
                String idMessage = location.getId() == null ? "" : " with ID '" + location.getId() + "'";
                throw new RuntimeException("Failed to load p2 repository" + idMessage + " from location " + location.getURL(), e);
            }
        }
        if (includeLocalMavenRepo) {
            metadataRepositories.add((IMetadataRepository)this.localMetadataRepository);
        }
        for (IMetadataRepository repository : metadataRepositories) {
            IQueryResult matches = repository.query(QueryUtil.ALL_UNITS, this.monitor);
            result.addAll(matches.toUnmodifiableSet());
        }
        if (includeLocalMavenRepo && this.logger.isDebugEnabled()) {
            IQueryResult<IInstallableUnit> locallyInstalledIUs = this.localMetadataRepository.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, null);
            this.logger.debug("Added " + TargetPlatformFactoryImpl.countElements(locallyInstalledIUs.iterator()) + " locally built units to the target platform");
        }
        return result;
    }

    private void loadMetadataRepository(MavenRepositoryLocation location, List<IMetadataRepository> metadataRepositories, Set<URI> loaded, Set<URI> artifactRepositories, boolean includeReferences) throws ProvisionException {
        if (loaded.add(location.getURL().normalize())) {
            IMetadataRepository repository = this.remoteMetadataRepositoryManager.loadRepository(location.getURL(), this.monitor);
            metadataRepositories.add(repository);
            if (includeReferences) {
                for (IRepositoryReference reference : repository.getReferences()) {
                    if ((reference.getOptions() | 1) == 0) continue;
                    if (reference.getType() == 0) {
                        try {
                            this.loadMetadataRepository(new MavenRepositoryLocation(reference.getNickname(), reference.getLocation()), metadataRepositories, loaded, artifactRepositories, includeReferences);
                        }
                        catch (ProvisionException e) {
                            this.logger.warn("Loading referenced repository failed: " + e.getMessage(), this.logger.isDebugEnabled() ? e : null);
                        }
                        continue;
                    }
                    if (reference.getType() != 1) continue;
                    artifactRepositories.add(reference.getLocation());
                }
            }
        }
    }

    private IRawArtifactFileProvider createExternalArtifactProvider(Set<URI> completeRepositories, List<TargetDefinitionContent> targetDefinitionsContent, IRawArtifactFileProvider extraMavenBundles) {
        SortedRepositories repos = SortedRepositories.sort(targetDefinitionsContent.stream().map(TargetDefinitionContent::getArtifactRepository).toList());
        RepositoryArtifactProvider remoteArtifactProvider = this.createRemoteArtifactProvider(completeRepositories, repos.remoteRepositories);
        MirroringArtifactProvider remoteArtifactProviderWithCache = MirroringArtifactProvider.createInstance(this.localArtifactRepository, remoteArtifactProvider, this.mavenContext);
        return new CompositeArtifactProvider(new FileRepositoryArtifactProvider((List<? extends IFileArtifactRepository>)repos.localRepositories, ArtifactTransferPolicies.forLocalArtifacts()), remoteArtifactProviderWithCache, extraMavenBundles);
    }

    private RepositoryArtifactProvider createRemoteArtifactProvider(Set<URI> mavenRepositories, List<IArtifactRepository> repos) {
        ArrayList<LazyArtifactRepository> artifactRepositories = new ArrayList<LazyArtifactRepository>();
        for (URI location : mavenRepositories) {
            if (this.offline && !URIUtil.isFileURI((URI)location)) continue;
            artifactRepositories.add(new LazyArtifactRepository(this.remoteAgent, location, RepositoryArtifactProvider::loadRepository));
        }
        artifactRepositories.addAll(repos);
        return new RepositoryArtifactProvider(artifactRepositories, ArtifactTransferPolicies.forLocalArtifacts());
    }

    private Map<IInstallableUnit, ReactorProjectIdentities> getPreliminaryReactorProjectUIs(List<ReactorProject> reactorProjects) throws DuplicateReactorIUsException {
        if (reactorProjects == null) {
            return Collections.emptyMap();
        }
        HashMap<IInstallableUnit, ReactorProjectIdentities> reactorUIs = new HashMap<IInstallableUnit, ReactorProjectIdentities>();
        HashMap<IInstallableUnit, Set<File>> duplicateReactorUIs = new HashMap<IInstallableUnit, Set<File>>();
        for (ReactorProject project : reactorProjects) {
            Set projectIUs = project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.INITIAL);
            if (projectIUs == null) continue;
            for (IInstallableUnit iu : projectIUs) {
                ReactorProjectIdentities identities;
                ReactorProjectIdentities otherOrigin = reactorUIs.put(iu, identities = project.getIdentities());
                if (otherOrigin == null || otherOrigin.equals((Object)identities)) continue;
                LinkedHashSet<File> duplicateLocations = (LinkedHashSet<File>)duplicateReactorUIs.get(iu);
                if (duplicateLocations == null) {
                    duplicateLocations = new LinkedHashSet<File>();
                    duplicateReactorUIs.put(iu, duplicateLocations);
                }
                duplicateLocations.add(otherOrigin.getBasedir());
                duplicateLocations.add(project.getBasedir());
            }
        }
        if (!duplicateReactorUIs.isEmpty()) {
            throw new DuplicateReactorIUsException(duplicateReactorUIs);
        }
        return reactorUIs;
    }

    private void applyFilters(TargetPlatformFilterEvaluator filter, Collection<IInstallableUnit> collectionToModify, Set<IInstallableUnit> reactorProjectUIs, ExecutionEnvironmentResolutionHints eeResolutionHints, Set<IInstallableUnit> shadowedIus) {
        HashSet<String> reactorIUIDs = new HashSet<String>();
        for (IInstallableUnit unit : reactorProjectUIs) {
            reactorIUIDs.add(unit.getId());
        }
        Iterator<IInstallableUnit> iter = collectionToModify.iterator();
        while (iter.hasNext()) {
            IInstallableUnit unit;
            unit = iter.next();
            boolean shaddowed = reactorIUIDs.contains(unit.getId());
            if (!eeResolutionHints.isNonApplicableEEUnit(unit) && !TargetPlatformFactoryImpl.isPartialIU(unit) && !shaddowed) continue;
            iter.remove();
            if (!shaddowed) continue;
            shadowedIus.add(unit);
        }
        TargetPlatformFactoryImpl.applyConfiguredFilter(filter, collectionToModify);
    }

    private static void applyConfiguredFilter(TargetPlatformFilterEvaluator filter, Collection<IInstallableUnit> collectionToModify) {
        if (filter != null) {
            filter.filterUnits(collectionToModify);
        }
    }

    private static boolean isPartialIU(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.partial.iu"));
    }

    static int countElements(Iterator<?> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            ++result;
            iterator.next();
        }
        return result;
    }

    public P2TargetPlatform createTargetPlatformWithUpdatedReactorContent(TargetPlatform baseTargetPlatform, List<?> upstreamProjectResults, PomDependencyCollector pomDependencies) {
        PomDependencyCollectorImpl pomDependenciesContent;
        if (pomDependencies instanceof PomDependencyCollectorImpl) {
            PomDependencyCollectorImpl source;
            pomDependenciesContent = source = (PomDependencyCollectorImpl)pomDependencies;
        } else {
            this.logger.debug("Using empty PomDependencyCollector instead of given = " + pomDependencies);
            pomDependenciesContent = new PomDependencyCollectorImpl(this.mavenContext.getLogger().adapt(Logger.class), null, this.remoteAgent);
        }
        return this.createTargetPlatformWithUpdatedReactorUnits(baseTargetPlatform, TargetPlatformFactoryImpl.extractProjectResultIUs(upstreamProjectResults), TargetPlatformFactoryImpl.getProjectArtifactProviders(upstreamProjectResults), (PomDependencyCollector)pomDependenciesContent);
    }

    public P2TargetPlatform createTargetPlatformWithUpdatedReactorUnits(TargetPlatform baseTargetPlatform, Map<IInstallableUnit, ReactorProjectIdentities> reactorUnits, List<IRawArtifactFileProvider> reactorArtifacts, PomDependencyCollector pomDependencyCollector) {
        if (!(baseTargetPlatform instanceof PreliminaryTargetPlatformImpl)) {
            throw new IllegalArgumentException("Base target platform must be an instance of PreliminaryTargetPlatformImpl; was: " + baseTargetPlatform);
        }
        if (!(pomDependencyCollector instanceof PomDependencyCollectorImpl)) {
            throw new IllegalArgumentException("PomDependencyCollector must be an instance of PomDependencyCollectorImpl; was: " + pomDependencyCollector);
        }
        return this.createTargetPlatformWithUpdatedReactorUnits((PreliminaryTargetPlatformImpl)baseTargetPlatform, reactorUnits, reactorArtifacts, (PomDependencyCollectorImpl)pomDependencyCollector);
    }

    P2TargetPlatform createTargetPlatformWithUpdatedReactorUnits(PreliminaryTargetPlatformImpl preliminaryTP, Map<IInstallableUnit, ReactorProjectIdentities> reactorUnitsMap, List<IRawArtifactFileProvider> reactorArtifacts, PomDependencyCollectorImpl pomDependencyCollector) {
        LinkedHashSet<IInstallableUnit> allUnits = preliminaryTP.getExternalUnits();
        TargetPlatformFilterEvaluator configuredFilters = preliminaryTP.getFilter();
        if (reactorUnitsMap != null) {
            allUnits.addAll(this.filterUnits(configuredFilters, reactorUnitsMap.keySet()));
        } else {
            reactorUnitsMap = new LinkedHashMap<IInstallableUnit, ReactorProjectIdentities>();
        }
        IRawArtifactFileProvider pomDependencyArtifactRepo = pomDependencyCollector.getArtifactRepoOfPublishedBundles();
        CompositeArtifactProvider jointArtifacts = this.createJointArtifactProvider(reactorArtifacts, preliminaryTP.getExternalArtifacts(), pomDependencyArtifactRepo);
        RepositoryBlackboardKey blackboardKey = RepositoryBlackboardKey.forResolutionContextArtifacts(pomDependencyCollector.getProjectLocation());
        ProviderOnlyArtifactRepository targetPlatformArtifactRepository = new ProviderOnlyArtifactRepository(jointArtifacts, this.remoteAgent, blackboardKey.toURI());
        ArtifactRepositoryBlackboard.putRepository(blackboardKey, (IArtifactRepository)targetPlatformArtifactRepository);
        this.logger.debug("Registered artifact repository " + blackboardKey);
        allUnits.addAll(this.filterUnits(configuredFilters, pomDependencyCollector.gatherMavenInstallableUnits()));
        Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = pomDependencyCollector.getMavenInstallableUnits();
        for (Map.Entry<IInstallableUnit, IArtifactFacade> entry : mavenInstallableUnits.entrySet()) {
            IArtifactFacade value = entry.getValue();
            if (!(value instanceof ReactorProjectFacade)) continue;
            ReactorProjectFacade projectFacade = (ReactorProjectFacade)value;
            reactorUnitsMap.put(entry.getKey(), projectFacade.getReactorProject().getIdentities());
        }
        return new FinalTargetPlatformImpl(allUnits, preliminaryTP.getEEResolutionHints(), jointArtifacts, this.localArtifactRepository, mavenInstallableUnits, reactorUnitsMap, (IArtifactRepository)targetPlatformArtifactRepository, Set.copyOf(preliminaryTP.getShadowed()));
    }

    protected Collection<? extends IInstallableUnit> filterUnits(TargetPlatformFilterEvaluator configuredFilters, Collection<? extends IInstallableUnit> units) {
        if (units.isEmpty() || configuredFilters == null) {
            return units;
        }
        LinkedList<IInstallableUnit> filteredUnits = new LinkedList<IInstallableUnit>(units);
        configuredFilters.filterUnits(filteredUnits);
        return filteredUnits;
    }

    private CompositeArtifactProvider createJointArtifactProvider(List<IRawArtifactFileProvider> reactorArtifacts, IRawArtifactFileProvider externalArtifacts, IRawArtifactFileProvider pomDependencyArtifactRepo) {
        return new CompositeArtifactProvider(reactorArtifacts, Arrays.asList(externalArtifacts, pomDependencyArtifactRepo));
    }

    private static Map<IInstallableUnit, ReactorProjectIdentities> extractProjectResultIUs(List<PublishingRepository> projectResults) {
        LinkedHashMap<IInstallableUnit, ReactorProjectIdentities> reactorUnits = new LinkedHashMap<IInstallableUnit, ReactorProjectIdentities>();
        for (PublishingRepository projectResult : projectResults) {
            Set projectUnits = projectResult.getMetadataRepository().query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet();
            ReactorProjectIdentities project = projectResult.getProjectIdentities();
            for (IInstallableUnit projectUnit : projectUnits) {
                reactorUnits.put(projectUnit, project);
            }
        }
        return reactorUnits;
    }

    private static List<IRawArtifactFileProvider> getProjectArtifactProviders(List<PublishingRepository> upstreamProjectResults) {
        ArrayList<IRawArtifactFileProvider> artifactProviders = new ArrayList<IRawArtifactFileProvider>();
        for (PublishingRepository upstreamProject : upstreamProjectResults) {
            artifactProviders.add(upstreamProject.getArtifacts());
        }
        return artifactProviders;
    }

    private static final class SortedRepositories {
        public final List<IArtifactRepository> remoteRepositories;
        public final List<FileArtifactRepository> localRepositories;

        private SortedRepositories(List<FileArtifactRepository> local, List<IArtifactRepository> remote) {
            this.remoteRepositories = remote;
            this.localRepositories = local;
        }

        public static SortedRepositories sort(List<IArtifactRepository> repositories) {
            ArrayList<IArtifactRepository> remote = new ArrayList<IArtifactRepository>();
            ArrayList<FileArtifactRepository> local = new ArrayList<FileArtifactRepository>();
            for (IArtifactRepository repo : repositories) {
                if (repo instanceof ListCompositeArtifactRepository) {
                    ListCompositeArtifactRepository list = (ListCompositeArtifactRepository)repo;
                    SortedRepositories children = SortedRepositories.sort(list.artifactRepositories);
                    remote.addAll(children.remoteRepositories);
                    local.addAll(children.localRepositories);
                    continue;
                }
                if (repo instanceof FileArtifactRepository) {
                    FileArtifactRepository fileArtifactRepo = (FileArtifactRepository)repo;
                    local.add(fileArtifactRepo);
                    continue;
                }
                remote.add(repo);
            }
            return new SortedRepositories(local, remote);
        }
    }
}

