/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools;

import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2.tools.director.shared.AbstractDirectorApplicationCommand;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.p2tools.copiedfromp2.DirectorApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.ILog;

@Component(role=DirectorRuntime.class)
public final class DirectorApplicationWrapper
implements DirectorRuntime {
    static final Integer EXIT_OK = 0;
    @Requirement
    Logger logger;
    @Requirement
    IProvisioningAgentProvider agentProvider;
    @Requirement
    IProvisioningAgent agent;

    @Override
    public DirectorRuntime.Command newInstallCommand(String name) {
        return new DirectorApplicationWrapperCommand(name, this.agentProvider, this.agent, this.logger);
    }

    private static class DirectorApplicationWrapperCommand
    extends AbstractDirectorApplicationCommand
    implements ILog {
        private Logger logger;
        private String name;
        private IProvisioningAgentProvider agentProvider;
        private IProvisioningAgent agent;

        public DirectorApplicationWrapperCommand(String name, IProvisioningAgentProvider agentProvider, IProvisioningAgent agent, Logger logger) {
            this.name = name;
            this.agentProvider = agentProvider;
            this.agent = agent;
            this.logger = logger;
        }

        @Override
        public void execute() {
            List<String> arguments = this.getDirectorApplicationArguments();
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Calling director with arguments: " + arguments);
            }
            try {
                Object exitCode = new DirectorApplication(this, this.getPhaseSet(), this.agent, this.agentProvider).run(arguments.toArray(new String[arguments.size()]));
                if (!EXIT_OK.equals(exitCode)) {
                    throw new DirectorCommandException("Call to p2 director application failed with exit code " + exitCode + ". Program arguments were: " + arguments + ".");
                }
            }
            catch (CoreException e) {
                throw new DirectorCommandException("Call to p2 director application failed:" + StatusTool.collectProblems(e.getStatus()) + ". Program arguments were: " + arguments + ".", e);
            }
        }

        @Override
        public void log(IStatus status) {
            String message = this.getMsgLine(StatusTool.toLogMessage(status));
            if (status.getSeverity() == 4) {
                this.logger.error(message, status.getException());
            } else if (status.getSeverity() == 2) {
                this.logger.warn(message);
            } else if (status.getSeverity() == 1) {
                this.logger.info(message);
            } else {
                this.logger.debug(message);
            }
        }

        @Override
        public void printOut(String line) {
            this.logger.info(this.getMsgLine(line));
        }

        private String getMsgLine(String line) {
            return "[" + this.name + "] " + line;
        }

        @Override
        public void printErr(String line) {
            this.logger.error(this.getMsgLine(line));
        }
    }
}

