/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools;

import org.apache.maven.plugin.logging.Log;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2tools.copiedfromp2.ILog;

public class MavenDirectorLog
implements ILog {
    private String name;
    private Log logger;

    public MavenDirectorLog(String name, Log logger) {
        this.name = name;
        this.logger = logger;
    }

    @Override
    public void log(IStatus status) {
        String message = this.getMsgLine(StatusTool.toLogMessage(status));
        if (status.getSeverity() == 4) {
            this.logger.error((CharSequence)message, status.getException());
        } else if (status.getSeverity() == 2) {
            this.logger.warn((CharSequence)message);
        } else if (status.getSeverity() == 1) {
            this.logger.info((CharSequence)message);
        } else {
            this.logger.debug((CharSequence)message);
        }
    }

    @Override
    public void printOut(String line) {
        this.logger.info((CharSequence)this.getMsgLine(line));
    }

    private String getMsgLine(String line) {
        return "[" + this.name + "] " + line;
    }

    @Override
    public void printErr(String line) {
        this.logger.error((CharSequence)this.getMsgLine(line));
    }
}

