/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2.CommandLineArguments;
import org.eclipse.tycho.p2.resolver.BundlePublisher;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.p2tools.MavenDirectorLog;
import org.eclipse.tycho.p2tools.copiedfromp2.DirectorApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.ILog;
import org.eclipse.tycho.p2tools.copiedfromp2.PhaseSetFactory;

@Mojo(name="director", defaultPhase=LifecyclePhase.NONE, threadSafe=true, requiresProject=false)
public class DirectorMojo
extends AbstractMojo {
    @Component
    private IProvisioningAgent agent;
    @Component
    private IProvisioningAgentProvider agentProvider;
    @Component
    private LegacySupport legacySupport;
    @Component
    private MojoExecution execution;
    @Parameter(property="destination", required=true)
    private File destination;
    @Parameter(property="metadatarepositories", alias="metadatarepository")
    private String metadatarepositories;
    @Parameter(property="artifactrepositories", alias="artifactrepository")
    private String artifactrepositories;
    @Parameter(property="repositories", alias="repository")
    private String repositories;
    @Parameter(property="installIUs", alias="installIU")
    private String installIUs;
    @Parameter
    private List<IU> install;
    @Parameter(property="uninstallIUs", alias="uninstallIU")
    private String uninstallIUs;
    @Parameter
    private List<IU> uninstall;
    @Parameter(property="revert")
    private String revert;
    @Parameter(property="purgeHistory")
    private boolean purgeHistory;
    @Parameter(property="list")
    private boolean list;
    @Parameter(property="listTags")
    private boolean listTags;
    @Parameter(property="listInstalledRoots")
    private boolean listInstalledRoots;
    @Parameter(property="listFormat")
    private String listFormat;
    @Parameter(property="profile", defaultValue="DefaultProfile")
    private String profile;
    @Parameter(property="profileproperties")
    private String profileproperties;
    @Parameter(property="installFeatures", defaultValue="true")
    private boolean installFeatures;
    @Parameter(defaultValue="false")
    private boolean installSources;
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="iuProfileproperties")
    private File iuProfileproperties;
    @Parameter(property="flavor")
    private String flavor;
    @Parameter(property="bundlepool")
    private File bundlepool;
    @Parameter(property="p2.os")
    private String p2os;
    @Parameter(property="p2.ws")
    private String p2ws;
    @Parameter(property="p2.arch")
    private String p2arch;
    @Parameter(property="p2.nl")
    private String p2nl;
    @Parameter(property="roaming")
    private boolean roaming;
    @Parameter(property="shared")
    private String shared;
    @Parameter(property="tag")
    private String tag;
    @Parameter(property="verifyOnly")
    private boolean verifyOnly;
    @Parameter(property="downloadOnly")
    private boolean downloadOnly;
    @Parameter(property="followReferences")
    private boolean followReferences;
    @Parameter(property="verboseTrust")
    private boolean verboseTrust;
    @Parameter(property="trustSignedContentOnly")
    private boolean trustSignedContentOnly;
    @Parameter(property="trustedAuthorities")
    private String trustedAuthorities;
    @Parameter(property="trustedPGPKeys")
    private String trustedPGPKeys;
    @Parameter(property="trustedCertificates")
    private String trustedCertificates;
    @Parameter
    private boolean includeProjectRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkMutualP2Args();
        TargetEnvironment targetEnv = this.p2os == null ? TargetEnvironment.getRunningEnvironment() : new TargetEnvironment(this.p2os, this.p2ws, this.p2arch);
        File adjustedDestination = DirectorRuntime.getDestination((File)this.destination, (TargetEnvironment)targetEnv);
        CommandLineArguments args = new CommandLineArguments();
        args.addNonNull("-destination", adjustedDestination);
        args.addNonNull("-metadatarepository", this.metadatarepositories);
        args.addNonNull("-artifactrepository", this.artifactrepositories);
        args.addNonNull("-repository", this.getRepositories());
        args.addNotEmpty("-installIU", this.getUnitParameterList(this.installIUs, this.install), (CharSequence)",");
        args.addNotEmpty("-uninstallIU", this.getUnitParameterList(this.uninstallIUs, this.uninstall), (CharSequence)",");
        args.addNonNull("-revert", this.revert);
        args.addFlagIfTrue("-purgeHistory", this.purgeHistory);
        args.addFlagIfTrue("-list", this.list);
        args.addFlagIfTrue("-listTags", this.listTags);
        args.addFlagIfTrue("-listInstalledRoots", this.listInstalledRoots);
        args.addNonNull("-listFormat", this.listFormat);
        args.addNonNull("-profile", this.profile);
        args.addNotEmpty("-profileproperties", this.getPropertyMap(this.profileproperties, this.properties), (CharSequence)"=", (CharSequence)",");
        args.addNonNull("-iuProfileproperties", this.iuProfileproperties);
        args.addNonNull("-flavor", this.flavor);
        args.addNonNull("-bundlepool", this.bundlepool);
        args.addNonNull("-p2.os", this.p2os);
        args.addNonNull("-p2.ws", this.p2ws);
        args.addNonNull("-p2.arch", this.p2arch);
        args.addNonNull("-p2.nl", this.p2nl);
        args.addFlagIfTrue("-roaming", this.roaming);
        args.addNonNull("-trustedAuthorities", this.trustedAuthorities);
        if (this.shared != null) {
            if (this.shared.isEmpty()) {
                args.add("-shared");
            } else {
                args.addNonNull("-shared", new File(this.shared));
            }
        }
        args.addNonNull("-tag", this.tag);
        args.addFlagIfTrue("-verifyOnly", this.verifyOnly);
        args.addFlagIfTrue("-downloadOnly", this.downloadOnly);
        args.addFlagIfTrue("-followReferences", this.followReferences);
        args.addFlagIfTrue("-verboseTrust", this.verboseTrust);
        args.addFlagIfTrue("-trustSignedContentOnly", this.trustSignedContentOnly);
        args.addNonNull("-trustedAuthorities", this.trustedAuthorities);
        args.addNonNull("-trustedPGPKeys", this.trustedPGPKeys);
        args.addNonNull("-trustedCertificates", this.trustedCertificates);
        this.runDirector(args);
    }

    private void checkMutualP2Args() throws MojoExecutionException {
        LinkedHashMap<String, String> mutualP2Options = new LinkedHashMap<String, String>();
        mutualP2Options.put("p2os", this.p2os);
        mutualP2Options.put("p2ws", this.p2ws);
        mutualP2Options.put("p2arch", this.p2arch);
        if (mutualP2Options.values().stream().anyMatch(Objects::nonNull) && mutualP2Options.values().stream().anyMatch(Objects::isNull)) {
            String msg = "p2os / p2ws / p2arch must be mutually specified, " + mutualP2Options.entrySet().stream().map(e -> (String)e.getKey() + (String)(e.getValue() == null ? " missing" : "=" + (String)e.getValue() + " given")).collect(Collectors.joining(", "));
            throw new MojoExecutionException(msg);
        }
    }

    protected void runDirector(CommandLineArguments args) throws MojoFailureException {
        try {
            this.agent.getService(IMetadataRepositoryManager.class);
            MavenDirectorLog directorLog = new MavenDirectorLog(this.execution.getExecutionId(), this.getLog());
            Object exitCode = new DirectorApplication((ILog)directorLog, PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{"checkTrust"}), this.agent, this.agentProvider).run(args.toArray());
            if (!IApplication.EXIT_OK.equals(exitCode)) {
                throw new MojoFailureException("Call to p2 director application failed with exit code " + String.valueOf(exitCode) + ". Program arguments were: '" + String.valueOf(args) + "'.");
            }
        }
        catch (CoreException e) {
            throw new MojoFailureException("Call to p2 director application failed: " + StatusTool.collectProblems((IStatus)e.getStatus()) + ". Program arguments were: '" + String.valueOf(args) + "'.", (Throwable)e);
        }
    }

    private String getRepositories() {
        File projectRepository = this.getProjectRepository();
        if (projectRepository != null) {
            if (this.repositories == null) {
                return projectRepository.getAbsoluteFile().toURI().toASCIIString();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String repo : this.repositories.split(",")) {
                list.add(repo.trim());
            }
            list.add(projectRepository.getAbsoluteFile().toURI().toASCIIString());
            return list.stream().collect(Collectors.joining(","));
        }
        return this.repositories;
    }

    private File getProjectRepository() {
        File[] files;
        MavenProject currentProject;
        MavenSession session;
        if (this.includeProjectRepository && (session = this.legacySupport.getSession()) != null && (currentProject = session.getCurrentProject()) != null && (files = (File[])Stream.concat(Stream.of(currentProject.getArtifact()), Stream.concat(currentProject.getAttachedArtifacts().stream(), currentProject.getArtifacts().stream())).filter(Objects::nonNull).distinct().map(Artifact::getFile).filter(Objects::nonNull).filter(File::isFile).toArray(File[]::new)).length > 0) {
            try {
                File projectRepository = new File(currentProject.getBuild().getDirectory(), this.execution.getExecutionId() + "-repo");
                BundlePublisher.createBundleRepository((File)projectRepository, (String)this.execution.getExecutionId(), (File[])files, null);
                return projectRepository;
            }
            catch (ProvisionException e) {
                this.getLog().warn((CharSequence)"Can't create the project repository!", (Throwable)e);
            }
        }
        return null;
    }

    private Map<String, String> getPropertyMap(String csvPropertiesMap, Map<String, String> properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (csvPropertiesMap != null) {
            for (String keyValue : csvPropertiesMap.split(",")) {
                String[] split = keyValue.split("=");
                map.put(split[0].trim(), split[1].trim());
            }
        }
        if (properties != null) {
            map.putAll(properties);
        }
        if (this.installFeatures) {
            map.put("org.eclipse.update.install.features", "true");
        }
        if (this.installSources) {
            map.put("org.eclipse.update.install.sources", "true");
        }
        return map;
    }

    private List<String> getUnitParameterList(String csvlist, List<IU> units) {
        ArrayList<String> list = new ArrayList<String>();
        if (csvlist != null) {
            for (String iu : csvlist.split(",")) {
                list.add(iu.trim());
            }
        }
        if (units != null) {
            for (IU iu : units) {
                Object id = iu.id;
                if (iu.feature) {
                    id = (String)id + ".feature.group";
                }
                if (iu.version != null) {
                    id = (String)id + "/" + iu.version;
                }
                list.add((String)id);
            }
        }
        return list;
    }

    private void add(String key, String value, List<String> args) {
        if (this.metadatarepositories != null) {
            args.add("-metadatarepository");
            args.add(this.metadatarepositories);
        }
    }

    public static final class IU {
        String id;
        String version;
        boolean feature;
    }
}

