/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.osgi.framework.Version;

@Component(role=TimestampFinder.class)
public class TimestampFinder {
    @Requirement
    Logger logger;
    private final Map<SimpleDateFormat, Pattern> datePatternsByRegularExpressions = TimestampFinder.defaultPatterns();

    private static Map<SimpleDateFormat, Pattern> defaultPatterns() {
        LinkedHashMap<SimpleDateFormat, Pattern> result = new LinkedHashMap<SimpleDateFormat, Pattern>();
        result.put(TimestampFinder.utcFormat("yyyyMMddHHmm"), Pattern.compile("([0-9]{12})"));
        result.put(TimestampFinder.utcFormat("yyyyMMdd-HHmm"), Pattern.compile("([0-9]{8})-([0-9]{4})"));
        result.put(TimestampFinder.utcFormat("yyyyMMdd"), Pattern.compile("([0-9]{8})"));
        return result;
    }

    private static SimpleDateFormat utcFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public Date findByDescriptor(ArtifactDescriptor artifact, SimpleDateFormat format) {
        ReactorProject otherProject = artifact.getMavenProject();
        String otherVersion = otherProject != null ? otherProject.getExpandedVersion() : artifact.getKey().getVersion();
        Version v = Version.parseVersion((String)otherVersion);
        String otherQualifier = v.getQualifier();
        if (otherQualifier != null) {
            Date qualifier = this.parseQualifier(otherQualifier, format);
            if (qualifier != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Found '" + format.format(qualifier) + "' from qualifier '" + otherQualifier + "' for artifact " + String.valueOf(artifact));
            }
            return qualifier;
        }
        this.logger.debug("Could not parse qualifier timestamp " + otherQualifier);
        return null;
    }

    private Date parseQualifier(String qualifier, SimpleDateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date timestamp = format.parse(qualifier, pos);
        if (timestamp != null && pos.getIndex() == qualifier.length()) {
            return timestamp;
        }
        return this.discoverTimestamp(qualifier);
    }

    private Date discoverTimestamp(String qualifier) {
        return this.findInString(qualifier);
    }

    public Date findInString(String string) {
        for (Map.Entry<SimpleDateFormat, Pattern> e : this.datePatternsByRegularExpressions.entrySet()) {
            String group;
            Date timestamp;
            Matcher matcher = e.getValue().matcher(string);
            if (!matcher.find() || (timestamp = this.parseTimestamp(group = matcher.group(), e.getKey())) == null) continue;
            return timestamp;
        }
        return null;
    }

    private Date parseTimestamp(String timestampString, SimpleDateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date timestamp = format.parse(timestampString, pos);
        if (timestamp != null && pos.getIndex() == timestampString.length()) {
            return timestamp;
        }
        return null;
    }
}

