/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;

@Component(role=FeatureXmlTransformer.class)
public class FeatureXmlTransformer {
    private static final int KBYTE = 1024;
    @Requirement
    private Logger log;
    @Requirement
    private FileLockService fileLockService;

    public FeatureXmlTransformer() {
    }

    public FeatureXmlTransformer(Logger log, FileLockService fileLockService) {
        this.log = log;
        this.fileLockService = fileLockService;
    }

    public Feature expandReferences(Feature feature, TargetPlatform targetPlatform) throws MojoFailureException {
        Feature.ImportRef importRef;
        String version;
        Map<String, Feature.ImportRef> featureImports = feature.getRequires().stream().flatMap(req -> req.getImports().stream()).filter(imp -> Objects.nonNull(imp.getFeature()) && !imp.getFeature().isBlank()).collect(Collectors.toMap(Feature.ImportRef::getFeature, Function.identity(), FeatureXmlTransformer.checkDuplicates(Feature.ImportRef::getFeature, "feature")));
        Map<String, Feature.ImportRef> pluginImports = feature.getRequires().stream().flatMap(req -> req.getImports().stream()).filter(imp -> Objects.nonNull(imp.getPlugin()) && !imp.getPlugin().isBlank()).collect(Collectors.toMap(Feature.ImportRef::getPlugin, Function.identity(), FeatureXmlTransformer.checkDuplicates(Feature.ImportRef::getPlugin, "plugin")));
        for (PluginRef pluginRef : feature.getPlugins()) {
            version = pluginRef.getVersion();
            if (Version.emptyVersion.toString().equals(version) && this.isVersionedRef(importRef = pluginImports.get(pluginRef.getId()))) {
                version = String.format("%s|%s", importRef.getVersion(), importRef.getMatch());
            }
            ArtifactKey plugin = this.resolvePluginReference(targetPlatform, pluginRef, version);
            pluginRef.setVersion(plugin.getVersion());
            File location = targetPlatform.getArtifactLocation(plugin);
            if (location == null) {
                throw new MojoFailureException("location is missing for plugin " + String.valueOf(plugin));
            }
            this.setDownloadAndInstallSize(pluginRef, location);
        }
        for (FeatureRef featureRef : feature.getIncludedFeatures()) {
            version = featureRef.getVersion();
            if (Version.emptyVersion.toString().equals(version) && this.isVersionedRef(importRef = featureImports.get(featureRef.getId()))) {
                version = String.format("%s|%s", importRef.getVersion(), importRef.getMatch());
            }
            ArtifactKey includedFeature = this.resolveFeatureReference(targetPlatform, featureRef, version);
            featureRef.setVersion(includedFeature.getVersion());
        }
        return feature;
    }

    private static BinaryOperator<Feature.ImportRef> checkDuplicates(Function<Feature.ImportRef, String> id, String name) {
        return (a, b) -> {
            throw new RuntimeException("duplicate reference to " + name + " " + (String)id.apply((Feature.ImportRef)a) + " encountered: " + System.lineSeparator() + String.valueOf(a) + System.lineSeparator() + String.valueOf(b));
        };
    }

    private boolean isVersionedRef(Feature.ImportRef importRef) {
        if (importRef == null) {
            return false;
        }
        String version = importRef.getVersion();
        if (version == null || version.isEmpty()) {
            return false;
        }
        String match = importRef.getMatch();
        return match != null && !match.isEmpty();
    }

    private ArtifactKey resolvePluginReference(TargetPlatform targetPlatform, PluginRef pluginRef, String version) throws MojoFailureException {
        try {
            return targetPlatform.resolveArtifact("eclipse-plugin", pluginRef.getId(), version);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new MojoFailureException("Invalid plugin reference with id=" + FeatureXmlTransformer.quote(pluginRef.getId()) + " and version=" + FeatureXmlTransformer.quote(pluginRef.getVersion()) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private ArtifactKey resolveFeatureReference(TargetPlatform targetPlatform, FeatureRef featureRef, String version) throws MojoFailureException {
        try {
            return targetPlatform.resolveArtifact("eclipse-feature", featureRef.getId(), version);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new MojoFailureException("Invalid feature reference with id=" + FeatureXmlTransformer.quote(featureRef.getId()) + " and version " + FeatureXmlTransformer.quote(featureRef.getVersion()) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static String quote(String nullableString) {
        if (nullableString == null) {
            return null;
        }
        return "\"" + nullableString + "\"";
    }

    private void setDownloadAndInstallSize(PluginRef pluginRefToEdit, File artifact) {
        if (!pluginRefToEdit.hasInstallSize() && !pluginRefToEdit.hasDownloadSize()) {
            return;
        }
        long downloadSize = 0L;
        long installSize = 0L;
        if (artifact.isFile()) {
            installSize = this.getInstallSize(artifact);
            downloadSize = artifact.length();
        } else {
            this.log.info("Download/install size is not calculated for directory based bundle " + pluginRefToEdit.getId());
        }
        if (pluginRefToEdit.hasDownloadSize()) {
            pluginRefToEdit.setDownloadSize(downloadSize / 1024L);
        }
        if (pluginRefToEdit.hasInstallSize()) {
            pluginRefToEdit.setInstallSize(installSize / 1024L);
        }
    }

    protected long getInstallSize(File location) {
        long installSize = 0L;
        try (Closeable locked = this.fileLockService.lock(location);
             JarFile jar = new JarFile(location);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                long entrySize = entry.getSize();
                if (entrySize <= 0L) continue;
                installSize += entrySize;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not determine installation size of file " + String.valueOf(location), e);
        }
        return installSize;
    }
}

