/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.tycho.packaging.osgiresolve.OSGiResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@Mojo(name="verify-osgi-pom", threadSafe=true)
public class VerifyPomMojo
extends AbstractMojo {
    static final String NAME = "verify-osgi-pom";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="tycho.verify.pom")
    private boolean skip;
    @Parameter(property="tycho.verify.failOnError")
    private boolean failOnError;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ModelReader modelReader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution was skipped");
            return;
        }
        Log log = this.getLog();
        boolean isPlugin = "eclipse-plugin".equals(this.project.getPackaging());
        boolean isFeature = "eclipse-feature".equals(this.project.getPackaging());
        if (!isPlugin && !isFeature) {
            log.info((CharSequence)"Skipped project because of incompatible packaging type");
            return;
        }
        File pom = this.project.getFile();
        try {
            Model model = this.modelReader.read(pom, Map.of("org.apache.maven.model.io.isStrict", true, "org.apache.maven.model.io.inputSource", new InputSource()));
            ArtifactTypeRegistry typeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRepositories(this.project.getRemoteProjectRepositories());
            HashMap<String, InputLocation> locationMap = new HashMap<String, InputLocation>();
            for (Dependency dependency : model.getDependencies()) {
                collectRequest.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)typeRegistry));
                locationMap.put(this.getId(dependency), dependency.getLocation((Object)""));
            }
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.session.getRepositorySession(), dependencyRequest);
            HashSet<TrackedDependency> filesToResolve = new HashSet<TrackedDependency>();
            if (isPlugin) {
                org.apache.maven.artifact.Artifact artifact = this.project.getArtifact();
                InputLocation location = model.getLocation((Object)"artifactId");
                filesToResolve.add(new TrackedDependency(this.project.getId(), location, artifact.getFile()));
            }
            for (ArtifactResult resolved : dependencyResult.getArtifactResults()) {
                Artifact artifact = resolved.getArtifact();
                if (artifact != null) {
                    String id = this.getId(artifact);
                    InputLocation location = (InputLocation)locationMap.get(id);
                    File file = artifact.getFile();
                    TrackedDependency dependency = new TrackedDependency(id, location, file);
                    if (file != null) {
                        filesToResolve.add(dependency);
                        continue;
                    }
                    this.logError(dependency, "Failed to resolve artifact file", pom);
                    continue;
                }
                this.logError(new TrackedDependency(this.project.getId(), null, pom), "Failed to resolve dependencies: " + String.valueOf(resolved.getExceptions()), pom);
            }
            if (filesToResolve.isEmpty()) {
                return;
            }
            OSGiResolver resolver = new OSGiResolver(new File(this.project.getBuild().getDirectory(), UUID.randomUUID().toString()));
            HashMap<Bundle, TrackedDependency> bundleMap = new HashMap<Bundle, TrackedDependency>();
            log.info((CharSequence)("Using " + filesToResolve.size() + " artifacts to check OSGi consistency"));
            for (TrackedDependency tracked : filesToResolve) {
                try {
                    Bundle install = resolver.install(tracked.file);
                    if (install != null) {
                        log.debug((CharSequence)("Installed " + tracked.id + " as " + install.getSymbolicName()));
                        bundleMap.put(install, tracked);
                        continue;
                    }
                    log.debug((CharSequence)("Cannot install resolved dependency " + tracked.id + " (" + tracked.file.getAbsolutePath() + ") for verification inside OSGi, maven compilation might still work"));
                }
                catch (BundleException e) {
                    this.logError(tracked, e.getMessage(), pom);
                }
            }
            Map<Bundle, String> resolveErrors = resolver.resolve();
            if (resolveErrors.isEmpty()) {
                log.info((CharSequence)"No consistency errors found");
            } else {
                Iterator iterator = resolveErrors.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, Comparator.comparing(Bundle::getSymbolicName, String.CASE_INSENSITIVE_ORDER))).iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Bundle bundle = (Bundle)entry.getKey();
                    TrackedDependency trackedDependency = (TrackedDependency)bundleMap.get(bundle);
                    String message = (String)entry.getValue();
                    this.logError(trackedDependency, message, pom);
                }
            }
        }
        catch (ModelParseException e) {
            this.logError(new TrackedDependency(this.project.getId(), null, pom), "Failed to parse pom model: " + e.getMessage(), pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (DependencyResolutionException e) {
            this.logError(new TrackedDependency(this.project.getId(), null, pom), "Failed to resolve pom dependencies: " + e.getMessage(), pom);
        }
        catch (BundleException e) {
            throw new MojoFailureException("can't start the framework", (Throwable)e);
        }
    }

    private void logError(TrackedDependency trackedDependency, String message, File pom) throws MojoFailureException {
        if (trackedDependency != null) {
            String oneLineMsg = this.failOnError ? message : message.replaceAll("[\\r\\n]+", " ");
            InputLocation location = trackedDependency.location;
            String content = "[verify-osgi-pom] " + trackedDependency.id + ": " + oneLineMsg + " @ file: " + pom.getAbsolutePath();
            content = location != null ? content + ", line: " + location.getLineNumber() + ", column: " + location.getColumnNumber() : content + ", line: -1, column: -1";
            if (this.failOnError) {
                throw new MojoFailureException(content);
            }
            this.getLog().error((CharSequence)content);
        }
    }

    private String getId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier();
    }

    private String getId(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + Objects.requireNonNullElse(dependency.getClassifier(), "");
    }

    private static final class TrackedDependency {
        private final String id;
        private final InputLocation location;
        private final File file;

        public TrackedDependency(String id, InputLocation location, File file) {
            this.id = id;
            this.location = location;
            this.file = file;
        }

        public int hashCode() {
            return Objects.hash(this.file);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrackedDependency other = (TrackedDependency)obj;
            return Objects.equals(this.file, other.file);
        }
    }
}

