/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.DependencyResolutionException;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Component(role=ArtifactCoordinateResolver.class, hint="local")
public class RepositoryArtifactCoordinateResolver
implements ArtifactCoordinateResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private Logger log;

    @Override
    public Optional<Dependency> resolve(Dependency dep, MavenProject project, MavenSession session) {
        return ArtifactCoordinateResolver.getPath(dep).flatMap(path -> {
            try {
                Properties properties = RepositoryArtifactCoordinateResolver.getArtifactProperties(path);
                if (properties == null) {
                    return Optional.empty();
                }
                String artifactId = properties.getProperty("artifactId");
                String groupId = properties.getProperty("groupId");
                String version = properties.getProperty("version");
                if (artifactId != null && groupId != null && version != null) {
                    String type = FilenameUtils.getExtension((String)path.getFileName().toString());
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(groupId);
                    dependency.setArtifactId(artifactId);
                    dependency.setType(type);
                    dependency.setVersion(version);
                    Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
                    ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                    request.setArtifact(artifact);
                    request.setOffline(session.isOffline());
                    request.setLocalRepository(session.getLocalRepository());
                    this.repositorySystem.injectMirror(request.getRemoteRepositories(), session.getSettings().getMirrors());
                    this.repositorySystem.injectProxy(request.getRemoteRepositories(), session.getSettings().getProxies());
                    this.repositorySystem.injectAuthentication(request.getRemoteRepositories(), session.getSettings().getServers());
                    ArtifactResolutionResult resolveResult = this.repositorySystem.resolve(request);
                    if (resolveResult.hasExceptions()) {
                        DependencyResolutionException exception = new DependencyResolutionException("Resolving " + artifact + " failed", (Collection)resolveResult.getExceptions());
                        this.log.debug("Resolving " + artifact + " failed because of: " + exception, (Throwable)exception);
                        return Optional.empty();
                    }
                    return resolveResult.getArtifacts().stream().filter(a -> a.getFile() != null).filter(a -> {
                        try {
                            return FileUtils.contentEquals((File)a.getFile(), (File)path.toFile());
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }).map(a -> {
                        Dependency result = new Dependency();
                        result.setGroupId(a.getGroupId());
                        result.setArtifactId(a.getArtifactId());
                        result.setVersion(a.getVersion());
                        result.setType(a.getType());
                        return result;
                    }).findFirst();
                }
            }
            catch (Exception e) {
                this.log.debug("Cannot process " + path + " because of " + e, (Throwable)e);
            }
            return Optional.empty();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getArtifactProperties(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0]) || Files.size(path) <= 0L) return null;
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Properties properties;
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
                InputStream stream = jarFile.getInputStream(jarEntry);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(stream);
                    properties2.setProperty("file-type", FilenameUtils.getExtension((String)path.getFileName().toString()));
                    properties = properties2;
                    if (stream == null) return properties;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                stream.close();
                return properties;
            }
        }
    }
}

