/*
 * Decompiled with CFR 0.152.
 */
package gama.annotations.precompiler.doc.utils;

import java.util.HashMap;

public class TypeConverter {
    public static final HashMap<String, String> properNameTypeMap = new HashMap();
    HashMap<String, String> specialCasesProperNameTypeMap;
    HashMap<String, String> properCategoryNameMap;
    public static final HashMap<Integer, String> typeStringFromIType = new HashMap();
    HashMap<Integer, String> symbolKindStringFromISymbolKind;

    public TypeConverter() {
        properNameTypeMap.putAll(this.initProperNameTypeMap());
        this.specialCasesProperNameTypeMap = this.initSpecialCasesProperNameTypeMap();
        this.properCategoryNameMap = this.initProperNameCategoriesMap();
        typeStringFromIType.putAll(this.initNameTypeFromIType());
        this.symbolKindStringFromISymbolKind = this.initSymbolKindStringFromISymbolKind();
    }

    public static void registerType(String className, String type2, Integer id) {
        if (!properNameTypeMap.containsKey(className)) {
            properNameTypeMap.put(className, type2);
        }
        if (!typeStringFromIType.containsKey(id)) {
            typeStringFromIType.put(id, type2);
        }
    }

    private HashMap<Integer, String> initSymbolKindStringFromISymbolKind() {
        HashMap<Integer, String> hm = new HashMap<Integer, String>();
        hm.put(0, "Species");
        hm.put(1, "Model");
        hm.put(2, "Single statement");
        hm.put(3, "Behavior");
        hm.put(4, "Parameter");
        hm.put(5, "Output");
        hm.put(6, "Layer");
        hm.put(7, "Skill");
        hm.put(8, "Batch section");
        hm.put(9, "Batch method");
        hm.put(10, "Environment");
        hm.put(11, "Sequence of statements or action");
        hm.put(13, "Experiment");
        hm.put(14, "Abstract section");
        hm.put(101, "Variable (number)");
        hm.put(102, "Variable (container)");
        hm.put(103, "Variable (signal)");
        hm.put(104, "Variable (regular)");
        return hm;
    }

    private HashMap<String, String> initProperNameTypeMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("java.lang.Integer", "int");
        hm.put("java.lang.Double", "float");
        hm.put("java.lang.Long", "float");
        hm.put("double", "float");
        hm.put("java.lang.Number", "float");
        hm.put("boolean", "bool");
        hm.put("java.lang.Boolean", "bool");
        hm.put("gama.core.util.GamaPair", "pair");
        hm.put("java.lang.String", "string");
        hm.put("gama.core.util.matrix.IMatrix", "matrix");
        hm.put("gama.core.util.matrix.GamaMatrix", "matrix");
        hm.put("gama.core.util.matrix.GamaIntMatrix", "matrix<int>");
        hm.put("gama.core.util.matrix.GamaFloatMatrix", "matrix<float>");
        hm.put("gama.core.util.file.IGamaFile", "file");
        hm.put("gama.core.util.file.GamaFile", "file");
        hm.put("gama.core.jogl.files.Gama3DSFile", "file");
        hm.put("gama.core.jogl.files.GamaObjFile", "file");
        hm.put("gama.core.util.GamaColor", "rgb");
        hm.put("gama.gaml.operators.Colors.GamaPalette", "list<rgb>");
        hm.put("gama.gaml.operators.Colors.GamaGradient", "map<rgb,float>");
        hm.put("gama.gaml.operators.Colors.GamaScale", "map<float,rgb>");
        hm.put("gama.core.util.IList", "list");
        hm.put("gama.core.util.GamaList", "list");
        hm.put("gama.core.util.IList", "list");
        hm.put("java.util.List", "list");
        hm.put("gama.core.util.GamaDateInterval", "list");
        hm.put("java.lang.Object", "unknown");
        hm.put("T", "unknown");
        hm.put("?", "unknown");
        hm.put("gama.core.util.tree.GamaNode", "unknown");
        hm.put("? extends java.lang.Comparable", "unknown");
        hm.put("gama.gaml.types.IType", "any GAML type");
        hm.put("gama.gaml.expressions.IExpression", "any expression");
        hm.put("gama.core.metamodel.agent.IAgent", "agent");
        hm.put("gama.core.kernel.experiment.IExperimentAgent", "agent");
        hm.put("gama.core.metamodel.shape.IShape", "geometry");
        hm.put("gama.core.metamodel.shape.GamaShape", "geometry");
        hm.put("? extends gama.core.metamodel.shape.IShape", "geometry");
        hm.put("gama.core.metamodel.shape.GamaPoint", "point");
        hm.put("gama.core.metamodel.shape.GamaPoint", "point");
        hm.put("gama.core.util.graph.IGraph", "graph");
        hm.put("gama.core.util.graph.GamaGraph", "graph");
        hm.put("gama.core.metamodel.topology.ITopology", "topology");
        hm.put("gama.core.util.GamaMap", "map");
        hm.put("gama.core.util.IMap", "map");
        hm.put("gama.gaml.species.ISpecies", "species");
        hm.put("gama.core.util.IContainer", "container");
        hm.put("gama.core.util.IContainer<?,java.lang.Double>", "container<float>");
        hm.put("java.util.Map", "map");
        hm.put("gama.core.util.GamaFont", "font");
        hm.put("gama.core.util.GamaRegression", "regression");
        hm.put("gama.core.util.GamaDate", "date");
        hm.put("gama.core.util.GamaMaterial", "material");
        hm.put("gama.extension.bdi.Predicate", "predicate");
        hm.put("gama.extension.bdi.BDIPlan", "BDIPlan");
        hm.put("gama.extension.bdi.Emotion", "emotion");
        hm.put("gama.extension.bdi.MentalState", "mental_state");
        hm.put("gama.extension.bdi.SocialLink", "social_link");
        hm.put("gama.extension.fipa.Conversation", "conversation");
        hm.put("gama.extension.fipa.Message", "message");
        hm.put("gama.core.messaging.GamaMessage", "message");
        hm.put("gama.extension.fipa.FIPAMessage", "message");
        hm.put("gama.core.util.IPath", "path");
        hm.put("gama.core.util.path.IPath", "path");
        hm.put("gama.core.util.path.GamaSpatialPath", "path");
        hm.put("gama.core.util.IContainer.Addressable", "container");
        hm.put("gama.gaml.types.GamaKmlExport", "kml");
        hm.put("gama.core.kernel.experiment.IParameter", "unknown");
        hm.put("gama.core.util.matrix.GamaField", "field");
        hm.put("gama.core.util.matrix.IField", "field");
        hm.put("gama.gaml.descriptions.ActionDescription", "action");
        return hm;
    }

    private HashMap<String, String> initSpecialCasesProperNameTypeMap() {
        HashMap<String, String> sphm = new HashMap<String, String>();
        sphm.put("gama.core.util.IAddressableContainer<java.lang.Integer,gama.core.metamodel.agent.IAgent,java.lang.Integer,gama.core.metamodel.agent.IAgent>", "list<agent>");
        sphm.put("gama.core.util.IContainer<KeyType,ValueType>.Addressable<KeyType,ValueType>", "container<KeyType,ValueType>");
        return sphm;
    }

    private HashMap<Integer, String> initNameTypeFromIType() {
        HashMap<Integer, String> hm = new HashMap<Integer, String>();
        hm.put(0, "any type");
        hm.put(1, "int");
        hm.put(2, "float");
        hm.put(3, "boolean");
        hm.put(4, "string");
        hm.put(5, "list");
        hm.put(6, "rgb");
        hm.put(7, "point");
        hm.put(8, "matrix");
        hm.put(9, "pair");
        hm.put(10, "map");
        hm.put(11, "agent");
        hm.put(12, "file");
        hm.put(13, "geometry");
        hm.put(14, "species");
        hm.put(15, "graph");
        hm.put(16, "container");
        hm.put(17, "path");
        hm.put(18, "topology");
        hm.put(19, "font");
        hm.put(20, "image");
        hm.put(21, "regression");
        hm.put(23, "date");
        hm.put(24, "message");
        hm.put(25, "material");
        hm.put(29, "kml");
        hm.put(30, "directory");
        hm.put(31, "field");
        hm.put(50, "available_types");
        hm.put(99, "message");
        hm.put(100, "species_types");
        hm.put(-27, "agent");
        hm.put(-29, "agent");
        hm.put(-199, "agent");
        hm.put(-200, "a label");
        hm.put(-201, "an identifier");
        hm.put(-202, "a datatype identifier");
        hm.put(-203, "a new identifier");
        hm.put(-204, "a new identifier");
        return hm;
    }

    private HashMap<String, String> initProperNameCategoriesMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("Cast", "Casting operators");
        hm.put("Colors", "Color-related operators");
        hm.put("DrivingOperators", "Driving operators");
        hm.put("Comparison", "Comparison operators");
        hm.put("IContainer", "Containers-related operators");
        hm.put("Containers", "Containers-related operators");
        hm.put("GamaMap", "Containers-related operators");
        hm.put("IMap", "Containers-related operators");
        hm.put("Files", "Files-related operators");
        hm.put("GamaFileType", "Files-related operators");
        hm.put("MessageType", "FIPA-related operators");
        hm.put("ConversationType", "FIPA-related operators");
        hm.put("Graphs", "Graphs-related operators");
        hm.put("GraphsGraphstream", "Graphs-related operators");
        hm.put("Logic", "Logical operators");
        hm.put("Maths", "Arithmetic operators");
        hm.put("GamaFloatMatrix", "Matrix-related operators");
        hm.put("GamaIntMatrix", "Matrix-related operators");
        hm.put("GamaMatrix", "Matrix-related operators");
        hm.put("GamaObjectMatrix", "Matrix-related operators");
        hm.put("IMatrix", "Matrix-related operators");
        hm.put("SingleEquationStatement", "EDP-related operators");
        hm.put("Creation", "Spatial operators");
        hm.put("Operators", "Spatial operators");
        hm.put("Points", "Spatial operators");
        hm.put("Properties", "Spatial operators");
        hm.put("Punctal", "Spatial operators");
        hm.put("Queries", "Spatial operators");
        hm.put("ThreeD", "Spatial operators");
        hm.put("Statistics", "Spatial operators");
        hm.put("Transformations", "Spatial operators");
        hm.put("Relations", "Spatial operators");
        hm.put("Random", "Random operators");
        hm.put("Stats", "Statistical operators");
        hm.put("Strings", "Strings-related operators");
        hm.put("System", "System");
        hm.put("Types", "Types-related operators");
        hm.put("WaterLevel", "Water level operators");
        return hm;
    }

    public String getProperType(String rawName) {
        if (this.specialCasesProperNameTypeMap.containsKey(rawName)) {
            return this.specialCasesProperNameTypeMap.get(rawName);
        }
        String[] splitByLeftBracket = rawName.split("<", 2);
        if (splitByLeftBracket.length == 1) {
            if (properNameTypeMap.containsKey(splitByLeftBracket[0])) {
                return properNameTypeMap.get(splitByLeftBracket[0]);
            }
            return splitByLeftBracket[0];
        }
        if (splitByLeftBracket.length != 2) {
            throw new IllegalArgumentException("getProperType has a not appropriate input");
        }
        String leftElement = this.getProperType(splitByLeftBracket[0]);
        String lastString = splitByLeftBracket[1];
        splitByLeftBracket[1] = lastString.substring(0, lastString.length() - 1);
        int comaIndex = TypeConverter.findCentralComa(splitByLeftBracket[1]);
        if (comaIndex > 0) {
            return leftElement + "<" + this.getProperType(splitByLeftBracket[1].substring(0, comaIndex)) + "," + this.getProperType(splitByLeftBracket[1].substring(comaIndex + 1)) + ">";
        }
        return leftElement + "<" + this.getProperType(splitByLeftBracket[1]) + ">";
    }

    public static int findCentralComa(String s) {
        int foundIndex = 0;
        if (s.contains(",")) {
            foundIndex = s.indexOf(",", 0);
            do {
                String sLeft;
                if (((sLeft = s.substring(0, foundIndex)).lastIndexOf("<") != -1 || sLeft.lastIndexOf(">") != -1) && sLeft.lastIndexOf(">") <= sLeft.lastIndexOf("<")) continue;
                return foundIndex;
            } while ((foundIndex = s.indexOf(",", foundIndex + 1)) >= 0);
        }
        return -1;
    }

    public String getProperOperatorName(String opName) {
        return opName;
    }

    public String getProperCategory(String rawName) {
        if (this.properCategoryNameMap.containsKey(rawName)) {
            return this.properCategoryNameMap.get(rawName);
        }
        return rawName;
    }

    public String getTypeString(Integer i) {
        if (typeStringFromIType.containsKey(i)) {
            return typeStringFromIType.get(i);
        }
        return String.valueOf(i);
    }

    public String getTypeString(int[] types) {
        StringBuilder s = new StringBuilder(30);
        s.append(types.length < 2 ? "" : "any type in [");
        int i = 0;
        while (i < types.length) {
            s.append(this.getTypeString(types[i]));
            if (i != types.length - 1) {
                s.append(", ");
            }
            ++i;
        }
        if (types.length >= 2) {
            s.append("]");
        }
        return s.toString();
    }

    public String getSymbolKindStringFromISymbolKind(Integer i) {
        if (this.symbolKindStringFromISymbolKind.containsKey(i)) {
            return this.symbolKindStringFromISymbolKind.get(i);
        }
        return String.valueOf(i);
    }
}

