/*
 * Decompiled with CFR 0.152.
 */
package gama.dev;

import gama.dev.FLAGS;
import gama.dev.STRINGS;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DEBUG {
    public static boolean FORCE_ON;
    private static final MySecurityManager SECURITY_MANAGER;
    private static final ConcurrentHashMap<String, String> REGISTERED;
    private static final ConcurrentHashMap<String, Integer> COUNTERS;
    private static final ThreadLocal<PrintStream> LOG_WRITERS;
    static final StackWalker STACK_WALKER;

    static {
        SECURITY_MANAGER = new MySecurityManager();
        REGISTERED = new ConcurrentHashMap();
        COUNTERS = new ConcurrentHashMap();
        LOG_WRITERS = ThreadLocal.withInitial(() -> System.out);
        STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }

    static String findCallingClassName() {
        Optional caller = STACK_WALKER.walk(frames -> frames.map(StackWalker.StackFrame::getClassName).filter(s -> !s.contains("gama.dev")).findFirst());
        if (caller.isEmpty()) {
            return SECURITY_MANAGER.getCallerClassName(3);
        }
        return (String)caller.get();
    }

    public static void RESET() {
        String s = DEBUG.findCallingClassName();
        if (REGISTERED.containsKey(s) && COUNTERS.containsKey(s)) {
            COUNTERS.put(s, -1);
        }
    }

    @SafeVarargs
    public static void TIMER(String category, String begin, String end, Runnable runnable, Consumer<Long> ... followUpWithResult) {
        if (!FLAGS.ENABLE_LOGGING) {
            runnable.run();
            return;
        }
        long start = System.currentTimeMillis();
        runnable.run();
        long duration = System.currentTimeMillis() - start;
        DEBUG.BANNER(category, begin, end, duration + "ms");
        if (followUpWithResult != null && followUpWithResult.length > 0) {
            followUpWithResult[0].accept(duration);
        }
    }

    public static <T extends Throwable> void TIMER_WITH_EXCEPTIONS(String category, String begin, String end, RunnableWithException<T> runnable) throws T {
        if (!FLAGS.ENABLE_LOGGING) {
            runnable.run();
            return;
        }
        long start = System.currentTimeMillis();
        runnable.run();
        DEBUG.BANNER(category, begin, end, System.currentTimeMillis() - start + "ms");
    }

    public static <T> T TIMER(String category, String title, String end, Supplier<T> supplier) {
        if (!FLAGS.ENABLE_LOGGING) {
            return supplier.get();
        }
        long start = System.currentTimeMillis();
        T result = supplier.get();
        DEBUG.BANNER(category, title, end, System.currentTimeMillis() - start + "ms");
        return result;
    }

    public static final void ON() {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        String calling = DEBUG.findCallingClassName();
        REGISTERED.put(calling, calling);
    }

    public static final void OFF() {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        String name = DEBUG.findCallingClassName();
        REGISTERED.remove(name);
    }

    public static boolean IS_ON() {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return false;
        }
        return DEBUG.IS_ON(DEBUG.findCallingClassName());
    }

    public static final void ERR(Object s) {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        System.err.println(STRINGS.TO_STRING(s));
    }

    public static final void ERR(Object s, Throwable t) {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        System.err.println(STRINGS.TO_STRING(s));
        t.printStackTrace();
    }

    public static void LOG(Object string) {
        if (FLAGS.ENABLE_LOGGING) {
            DEBUG.LOG(string, true);
        }
    }

    public static void BANNER(String title, String state, String result) {
        DEBUG.BANNER("GAMA", title, state, result);
    }

    public static void BANNER(String category, String title, String state, String result) {
        String cat = STRINGS.PAD("> " + category, 8, ' ') + ": ";
        DEBUG.LOG(STRINGS.PAD(cat + title + " ", 55, ' ') + STRINGS.PAD(" " + state, 15, '_') + " " + result);
    }

    public static void LOG(Object object, boolean newLine) {
        if (FLAGS.ENABLE_LOGGING) {
            if (newLine) {
                LOG_WRITERS.get().println(STRINGS.TO_STRING(object));
            } else {
                LOG_WRITERS.get().print(STRINGS.TO_STRING(object));
            }
        }
    }

    public static void REGISTER_LOG_WRITER(OutputStream writer) {
        LOG_WRITERS.set(new PrintStream(writer, true));
    }

    public static void UNREGISTER_LOG_WRITER() {
        LOG_WRITERS.remove();
    }

    static boolean IS_ON(String className) {
        if (FORCE_ON) {
            return true;
        }
        for (String name : REGISTERED.keySet()) {
            if (!className.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    private DEBUG() {
    }

    public static final void OUT(Object s) {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        if (DEBUG.IS_ON(DEBUG.findCallingClassName())) {
            DEBUG.LOG(s, true);
        }
    }

    public static final void OUT(Object s, boolean newLine) {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING) {
            return;
        }
        if (DEBUG.IS_ON(DEBUG.findCallingClassName())) {
            DEBUG.LOG(s, newLine);
        }
    }

    public static final void OUT(String title, int pad, Object other) {
        if (!FLAGS.ENABLE_DEBUG || !FLAGS.ENABLE_LOGGING || title == null) {
            return;
        }
        if (DEBUG.IS_ON(DEBUG.findCallingClassName())) {
            DEBUG.LOG(STRINGS.PAD(title, pad) + STRINGS.TO_STRING(other));
        }
    }

    public static final void LINE() {
        DEBUG.LOG(STRINGS.PAD("", 80, '-'));
    }

    public static final void SECTION(String s) {
        if (s == null) {
            return;
        }
        DEBUG.LINE();
        DEBUG.TITLE(s);
        DEBUG.LINE();
    }

    public static final void TITLE(String s) {
        if (s == null) {
            return;
        }
        DEBUG.LOG(STRINGS.PAD("---------- " + s.toUpperCase() + " ", 80, '-'));
    }

    public static void STACK() {
        if (!FLAGS.ENABLE_LOGGING || !DEBUG.IS_ON(DEBUG.findCallingClassName())) {
            return;
        }
        DEBUG.LOG(STRINGS.PAD("--- Stack trace ", 80, '-'));
        STACK_WALKER.walk(stream1 -> {
            stream1.skip(2L).forEach(s -> DEBUG.LOG("> " + String.valueOf(s)));
            return null;
        });
        DEBUG.LINE();
    }

    public static void FORCE_ON() {
        FORCE_ON = true;
    }

    private static class MySecurityManager
    extends SecurityManager {
        private MySecurityManager() {
        }

        public String getCallerClassName(int callStackDepth) {
            return this.getClassContext()[callStackDepth].getName();
        }
    }

    public static interface RunnableWithException<T extends Throwable> {
        public void run() throws T;
    }
}

