/*
 * Decompiled with CFR 0.152.
 */
package gama.annotations.precompiler;

import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GamlProperties {
    Map<String, LinkedHashSet<String>> map = new LinkedHashMap<String, LinkedHashSet<String>>();
    public static final String SKILLS = "skills";
    public static final String ACTIONS = "actions";
    public static final String ATTRIBUTES = "attributes";
    public static final String STATEMENTS = "statements";
    public static final String OPERATORS = "operators";
    public static final String GAML = "gaml.properties";
    public static final String SPECIES = "species";
    public static final String CONSTANTS = "constants";
    public static final String ARCHITECTURES = "architectures";
    public static final String TYPES = "types";
    public static final String PLUGINS = "plugins";
    public static final String SEPARATOR = "~";
    static final String NULL = "";

    public GamlProperties() {
    }

    public GamlProperties(Reader r) {
        this();
        this.load(r);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public LinkedHashSet<String> get(String key) {
        return this.map.get(key);
    }

    public String getFirst(String key) {
        LinkedHashSet<String> result = this.get(key);
        if (result == null) {
            return null;
        }
        Iterator it = result.iterator();
        if (it.hasNext()) {
            return (String)it.next();
        }
        return null;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void put(String key, String value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new LinkedHashSet());
        }
        if (value != null) {
            this.map.get(key).add(value);
        }
    }

    public void put(String key, Iterable<String> values) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new LinkedHashSet());
        }
        for (String s : values) {
            this.map.get(key).add(s);
        }
    }

    public void putAll(GamlProperties m) {
        for (Map.Entry<String, LinkedHashSet<String>> entry : m.map.entrySet()) {
            this.put(entry.getKey(), (LinkedHashSet)entry.getValue().clone());
        }
    }

    public void store(Writer writer) {
        Properties prop = new Properties();
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.map.entrySet()) {
            prop.setProperty(entry.getKey(), GamlProperties.toString((Set<String>)entry.getValue()));
        }
        try {
            prop.store(writer, NULL);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static String toString(Set<String> strings) {
        if (!strings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String value : strings) {
                sb.append(value).append(SEPARATOR);
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return NULL;
    }

    public Map<String, String> filterFirst(String c) {
        LinkedHashMap<String, String> gp = new LinkedHashMap<String, String>();
        for (String original : this.map.keySet()) {
            if (c.charAt(0) != original.charAt(0)) continue;
            String key = original.substring(1);
            gp.put(key, this.getFirst(original));
        }
        return gp;
    }

    public Map<String, Set<String>> filterAll(String c) {
        LinkedHashMap<String, Set<String>> gp = new LinkedHashMap<String, Set<String>>();
        for (String original : this.map.keySet()) {
            if (c.charAt(0) != original.charAt(0)) continue;
            String key = original.substring(1);
            gp.put(key, this.get(original));
        }
        return gp;
    }

    public GamlProperties load(Reader reader) {
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        for (String s : prop.stringPropertyNames()) {
            String[] array = prop.getProperty(s, NULL).split(SEPARATOR);
            LinkedHashSet<String> values = new LinkedHashSet<String>(Arrays.asList(array));
            this.put(s, values);
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public void clear() {
        this.map.clear();
    }
}

