/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.IIntersectable;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.util.PoolUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.gaml.operators.Comparison;
import gama.gaml.types.GamaGeometryType;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;

public class Envelope3D
extends Envelope
implements IDisposable,
IIntersectable {
    private static final PoolUtils.ObjectPool<Envelope3D> POOL = PoolUtils.create("Envelope 3D", true, Envelope3D::new, (envelope3D, envelope3D2) -> {
        Envelope3D envelope3D3 = envelope3D2.set((Envelope3D)envelope3D);
    }, null);
    public static final Envelope3D EMPTY = Envelope3D.create();
    private static final long serialVersionUID = -3188702602373537163L;
    private double minz;
    private double maxz;

    public static Envelope3D create() {
        return POOL.get();
    }

    public static Envelope3D of(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            return Envelope3D.of((GeometryCollection)geometry);
        }
        ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(geometry);
        return iCoordinates.getEnvelope();
    }

    public static Envelope3D of(GeometryCollection geometryCollection) {
        int n = geometryCollection.getNumGeometries();
        if (n == 0) {
            return EMPTY;
        }
        Envelope3D envelope3D = Envelope3D.of(geometryCollection.getGeometryN(0));
        int n2 = 1;
        while (n2 < n) {
            envelope3D.expandToInclude(Envelope3D.of(geometryCollection.getGeometryN(n2)));
            ++n2;
        }
        return envelope3D;
    }

    public static Envelope3D of(List<IShape> list) {
        int n = list.size();
        if (n == 0) {
            return EMPTY;
        }
        Envelope3D envelope3D = Envelope3D.of(list.get(0));
        int n2 = 1;
        while (n2 < n) {
            envelope3D.expandToInclude(Envelope3D.of(list.get(n2)));
            ++n2;
        }
        return envelope3D;
    }

    public static Envelope3D of(IShape iShape) {
        return Envelope3D.of(iShape.getInnerGeometry());
    }

    public static Envelope3D of(GamaPoint gamaPoint) {
        return Envelope3D.of((Coordinate)gamaPoint);
    }

    public static Envelope3D of(Envelope envelope) {
        Envelope3D envelope3D = Envelope3D.create();
        envelope3D.init(envelope);
        return envelope3D;
    }

    public static Envelope3D withYNegated(Envelope envelope) {
        Envelope3D envelope3D = Envelope3D.create();
        envelope3D.init(envelope);
        envelope3D.init(envelope3D.getMinX(), envelope3D.getMaxX(), -envelope3D.getMinY(), -envelope3D.getMaxY(), envelope3D.minz, envelope3D.maxz);
        return envelope3D;
    }

    public static Envelope3D of(Coordinate coordinate) {
        Envelope3D envelope3D = Envelope3D.create();
        envelope3D.init(coordinate);
        return envelope3D;
    }

    public static Envelope3D of(double d, double d2, double d3, double d4, double d5, double d6) {
        Envelope3D envelope3D = Envelope3D.create();
        envelope3D.init(d, d2, d3, d4, d5, d6);
        return envelope3D;
    }

    @Override
    public void dispose() {
        this.setToNull();
        POOL.release((Envelope3D[])new Envelope3D[]{this});
    }

    public void init(double d, double d2, double d3, double d4, double d5, double d6) {
        this.init(d, d2, d3, d4);
        if (d5 < d6) {
            this.minz = d5;
            this.maxz = d6;
        } else {
            this.minz = d6;
            this.maxz = d5;
        }
    }

    public void init(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y, coordinate.z, coordinate2.z);
    }

    public void init(Coordinate coordinate) {
        this.init(coordinate.x, coordinate.x, coordinate.y, coordinate.y, coordinate.z, coordinate.z);
    }

    public void init(Envelope envelope) {
        super.init(envelope);
        if (envelope instanceof Envelope3D) {
            this.minz = ((Envelope3D)envelope).getMinZ();
            this.maxz = ((Envelope3D)envelope).getMaxZ();
        }
    }

    public void init(Envelope3D envelope3D) {
        super.init((Envelope)envelope3D);
        this.minz = envelope3D.minz;
        this.maxz = envelope3D.maxz;
    }

    private Envelope3D set(Envelope3D envelope3D) {
        this.init(envelope3D);
        return this;
    }

    public double getLargestDimension() {
        double d = Math.max(this.getWidth(), this.getHeight());
        return Math.max(d, this.getDepth());
    }

    public void setToNull() {
        super.setToNull();
        this.minz = 0.0;
        this.maxz = -1.0;
    }

    public double getDepth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxz - this.minz;
    }

    public double getMinZ() {
        return this.minz;
    }

    public double getMaxZ() {
        return this.maxz;
    }

    public double getVolume() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    public double minExtent() {
        if (this.isNull()) {
            return 0.0;
        }
        return Math.min(this.getWidth(), Math.min(this.getHeight(), this.getDepth()));
    }

    public double maxExtent() {
        if (this.isNull()) {
            return 0.0;
        }
        return Math.max(this.getWidth(), Math.max(this.getHeight(), this.getDepth()));
    }

    public void expandToInclude(Coordinate coordinate) {
        this.expandToInclude(coordinate.x, coordinate.y, coordinate.z);
    }

    public void expandBy(double d) {
        this.expandBy(d, d, d);
    }

    public void expandBy(double d, double d2, double d3) {
        if (this.isNull()) {
            return;
        }
        this.minz -= d3;
        this.maxz += d3;
        this.expandBy(d, d2);
        if (this.minz > this.maxz) {
            this.setToNull();
        }
    }

    public void expandToInclude(double d, double d2, double d3) {
        if (this.isNull()) {
            this.expandToInclude(d, d2);
            this.minz = d3;
            this.maxz = d3;
        } else {
            this.expandToInclude(d, d2);
            if (d3 < this.minz) {
                this.minz = d3;
            }
            if (d3 > this.maxz) {
                this.maxz = d3;
            }
        }
    }

    public Envelope3D translate(double d, double d2, double d3) {
        if (this.isNull()) {
            return this;
        }
        this.init(this.getMinX() + d, this.getMaxX() + d, this.getMinY() + d2, this.getMaxY() + d2, this.getMinZ() + d3, this.getMaxZ() + d3);
        return this;
    }

    public GamaPoint centre() {
        if (this.isNull()) {
            return null;
        }
        return new GamaPoint((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0, (this.getMinZ() + this.getMaxZ()) / 2.0);
    }

    @Override
    public boolean intersects(Envelope envelope) {
        if (!super.intersects(envelope)) {
            return false;
        }
        return this.getMinZOf(envelope) <= this.maxz && this.getMaxZOf(envelope) >= this.minz;
    }

    @Override
    public boolean intersects(Coordinate coordinate) {
        return this.intersects(coordinate.x, coordinate.y, coordinate.z);
    }

    protected boolean intersects(double d, double d2, double d3) {
        if (this.isNull()) {
            return false;
        }
        return this.intersects(d, d2) && d3 >= this.minz && d3 <= this.maxz;
    }

    protected boolean covers(double d, double d2, double d3) {
        if (this.isNull()) {
            return false;
        }
        return this.covers(d, d2) && d3 >= this.minz && d3 <= this.maxz;
    }

    public boolean covers(Coordinate coordinate) {
        return this.covers(coordinate.x, coordinate.y, coordinate.z);
    }

    public boolean covers(Envelope envelope) {
        if (this.isNull() || envelope.isNull() || !super.covers(envelope)) {
            return false;
        }
        return this.getMinZOf(envelope) >= this.minz && this.getMaxZOf(envelope) <= this.maxz;
    }

    public double distance(Envelope envelope) {
        if (this.intersects(envelope)) {
            return 0.0;
        }
        double d = 0.0;
        if (this.getMaxX() < envelope.getMinX()) {
            d = envelope.getMinX() - this.getMaxX();
        } else if (this.getMinX() > envelope.getMaxX()) {
            d = this.getMinX() - envelope.getMaxX();
        }
        double d2 = 0.0;
        if (this.getMaxY() < envelope.getMinY()) {
            d2 = envelope.getMinY() - this.getMaxY();
        } else if (this.getMinY() > envelope.getMaxY()) {
            d2 = this.getMinY() - envelope.getMaxY();
        }
        double d3 = 0.0;
        double d4 = this.getMinZOf(envelope);
        double d5 = this.getMaxZOf(envelope);
        if (this.maxz < d4) {
            d3 = d4 - this.maxz;
        } else if (this.minz > d5) {
            d3 = this.minz - d5;
        }
        if (d == 0.0 && d3 == 0.0) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d3;
        }
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    private Envelope3D() {
    }

    public Envelope3D intersection(Envelope envelope) {
        if (this.isNull() || envelope.isNull() || !this.intersects(envelope)) {
            return EMPTY;
        }
        Envelope envelope2 = super.intersection(envelope);
        double d = this.getMinZOf(envelope);
        double d2 = this.minz > d ? this.minz : d;
        double d3 = this.getMaxZOf(envelope);
        double d4 = this.maxz < d3 ? this.maxz : d3;
        return Envelope3D.of(envelope2.getMinX(), envelope2.getMaxX(), envelope2.getMinY(), envelope2.getMaxY(), d2, d4);
    }

    public void expandToInclude(Envelope envelope) {
        if (envelope.isNull()) {
            return;
        }
        double d = this.getMinZOf(envelope);
        double d2 = this.getMaxZOf(envelope);
        if (this.isNull()) {
            super.expandToInclude(envelope);
            this.minz = d;
            this.maxz = d2;
        } else {
            super.expandToInclude(envelope);
            if (d < this.minz) {
                this.minz = d;
            }
            if (d2 > this.maxz) {
                this.maxz = d2;
            }
        }
    }

    private double getMaxZOf(Envelope envelope) {
        if (envelope instanceof Envelope3D) {
            return ((Envelope3D)envelope).maxz;
        }
        return 0.0;
    }

    private double getMinZOf(Envelope envelope) {
        if (envelope instanceof Envelope3D) {
            return ((Envelope3D)envelope).minz;
        }
        return 0.0;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + Coordinate.hashCode((double)this.minz);
        n = 37 * n + Coordinate.hashCode((double)this.maxz);
        return n ^ 0xAB296275;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Envelope3D)) {
            return false;
        }
        Envelope3D envelope3D = (Envelope3D)object;
        if (this.isNull()) {
            return envelope3D.isNull();
        }
        return super.equals(object) && Comparison.equal((Double)this.minz, (Double)envelope3D.getMinZ()) != false && Comparison.equal((Double)this.maxz, (Double)envelope3D.getMaxZ()) != false;
    }

    public boolean isFlat() {
        return this.minz == this.maxz;
    }

    public boolean isHorizontal() {
        return this.minz == this.maxz;
    }

    public Polygon toGeometry() {
        if (this.isFlat()) {
            return (Polygon)GamaGeometryType.buildRectangle(this.getWidth(), this.getHeight(), this.centre()).getInnerGeometry();
        }
        return (Polygon)GamaGeometryType.buildBox(this.getWidth(), this.getHeight(), this.getDepth(), this.centre()).getInnerGeometry();
    }

    public String toString() {
        return "Env[" + this.getMinX() + " : " + this.getMaxX() + ", " + this.getMinY() + " : " + this.getMaxY() + ",  " + this.minz + " : " + this.maxz + "]";
    }

    public Envelope3D yNegated() {
        return Envelope3D.of(this.getMinX(), this.getMaxX(), -this.getMaxY(), -this.getMinY(), this.minz, this.maxz);
    }

    public Envelope3D rotate(AxisAngle axisAngle) {
        if (this.isNull()) {
            return this;
        }
        GamaShape gamaShape = GamaShapeFactory.createFrom(this);
        gamaShape = GamaShapeFactory.createFrom(gamaShape).withRotation(axisAngle).withLocation(gamaShape.getLocation());
        this.init(gamaShape.getEnvelope());
        return this;
    }
}

