/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.core.kernel.batch.optimization.AOptimizationAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.gaml.operators.Cast;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Particle {
    private final ParametersSet position;
    private ParametersSet velocity;
    private ParametersSet bestPosition;
    private double bestEval;
    protected HashMap<ParametersSet, Double> testedSolutions;
    BatchAgent currentExperiment;
    final Map<String, GamaPoint> parameters;
    AOptimizationAlgorithm algo;
    double currentVal;

    Particle(IScope iScope, BatchAgent batchAgent, AOptimizationAlgorithm aOptimizationAlgorithm, HashMap<ParametersSet, Double> hashMap) {
        this.currentExperiment = batchAgent;
        this.algo = aOptimizationAlgorithm;
        this.testedSolutions = hashMap;
        this.bestEval = this.algo.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        List<IParameter.Batch> list = batchAgent.getParametersToExplore();
        this.parameters = new HashMap<String, GamaPoint>();
        for (IParameter object : list) {
            GamaPoint gamaPoint = new GamaPoint(object.getMinValue(iScope) != null ? Cast.asFloat(iScope, object.getMinValue(iScope)) : Double.NEGATIVE_INFINITY, object.getMaxValue(iScope) != null ? Cast.asFloat(iScope, object.getMaxValue(iScope)) : Double.POSITIVE_INFINITY);
            this.parameters.put(object.getName(), gamaPoint);
        }
        this.position = new ParametersSet(iScope, list, true);
        this.velocity = new ParametersSet(iScope, list, true);
        for (String string : this.velocity.keySet()) {
            this.velocity.put(string, (Object)(Cast.asFloat(iScope, this.velocity.get(string)) - Cast.asFloat(iScope, this.position.get(string))));
        }
        this.bestPosition = new ParametersSet(this.position);
    }

    public double eval() {
        Double d = this.testedSolutions.get(this.position);
        if (d == null) {
            d = this.algo.getFirstFitness(this.currentExperiment.launchSimulationsWithSingleParametersSet(this.position));
            this.testedSolutions.put(this.position, d);
        }
        return d;
    }

    void updatePersonalBest() {
        if (this.algo.isMaximize() && this.currentVal > this.bestEval || !this.algo.isMaximize() && this.currentVal < this.bestEval) {
            this.bestEval = this.currentVal;
            this.bestPosition = new ParametersSet(this.position);
        }
    }

    ParametersSet getPosition() {
        return this.position;
    }

    ParametersSet getVelocity() {
        return this.velocity;
    }

    ParametersSet getBestPosition() {
        return this.bestPosition;
    }

    double getBestEval() {
        return this.bestEval;
    }

    void updatePosition(IScope iScope) {
        for (String string : this.position.keySet()) {
            GamaPoint gamaPoint = this.parameters.get(string);
            double d = Cast.asFloat(iScope, this.position.get(string)) + Cast.asFloat(iScope, this.velocity.get(string));
            d = Math.min(Math.max(d, Cast.asFloat(iScope, gamaPoint.x)), gamaPoint.y);
            this.position.put(string, (Object)d);
        }
    }

    void setVelocity(ParametersSet parametersSet) {
        this.velocity = parametersSet;
    }
}

