/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.projection;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.Projection;
import gama.core.metamodel.topology.projection.WorldProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.commons.io.FilenameUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CartesianCS;
import tech.units.indriya.unit.Units;

public class ProjectionFactory {
    private static final String EPSGPrefix = "EPSG:";
    private static final String defaultTargetCRS = String.valueOf(GamaPreferences.External.LIB_TARGET_CRS.getInitialValue(null));
    private static final String defaultSaveCRS = String.valueOf(GamaPreferences.External.LIB_OUTPUT_CRS.getInitialValue(null));
    private static Map<String, CoordinateReferenceSystem> CRSCache = GamaMapFactory.createUnordered();
    private IProjection world;
    private UnitConverter unitConverter = null;
    public CoordinateReferenceSystem targetCRS;
    public static CoordinateReferenceSystem EPSG3857 = null;

    static {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        try {
            coordinateReferenceSystem = CRS.decode((String)"EPSG:3857");
        }
        catch (FactoryException factoryException) {}
        EPSG3857 = coordinateReferenceSystem;
    }

    public static CoordinateReferenceSystem manageGoogleCRS(URL uRL) {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        try {
            byte[] byArray;
            String string;
            String string2 = new File(uRL.toURI()).getAbsolutePath().replace(".shp", ".prj");
            if (Files.exists(Paths.get(string2, new String[0]), new LinkOption[0]) && ((string = new String(byArray = Files.readAllBytes(Paths.get(string2, new String[0])), StandardCharsets.UTF_8)).contains("WGS 84 / Pseudo-Mercator") || string.contains("WGS_1984_Web_Mercator_Auxiliary_Sphere"))) {
                coordinateReferenceSystem = EPSG3857;
            }
        }
        catch (IOException | URISyntaxException exception) {}
        return coordinateReferenceSystem;
    }

    public void setWorldProjectionEnv(IScope iScope, Envelope3D envelope3D) {
        if (this.world != null) {
            return;
        }
        this.world = new WorldProjection(iScope, null, envelope3D, this);
    }

    void computeTargetCRS(IScope iScope, CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2) {
        if (this.targetCRS != null) {
            return;
        }
        try {
            if (!GamaPreferences.External.LIB_TARGETED.getValue().booleanValue()) {
                this.targetCRS = this.computeDefaultCRS(iScope, GamaPreferences.External.LIB_TARGET_CRS.getValue(), true);
            } else if (coordinateReferenceSystem instanceof DefaultProjectedCRS) {
                CartesianCS cartesianCS = ((DefaultProjectedCRS)coordinateReferenceSystem).getCoordinateSystem();
                Unit unit = cartesianCS.getAxis(0).getUnit();
                if (unit != null && !unit.equals(Units.METRE)) {
                    this.unitConverter = unit.getConverterTo(Units.METRE);
                }
                this.targetCRS = coordinateReferenceSystem;
            } else {
                int n = (int)(0.5 + (d + 186.0) / 6.0);
                boolean bl = d2 > 0.0;
                String string = EPSGPrefix + (32600 + n + (bl ? 0 : 100));
                this.targetCRS = this.getCRS(iScope, string);
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("The cause could be that you try to re-project already projected data (see Gama > Preferences... > External for turning the option to true)");
            throw gamaRuntimeException;
        }
    }

    public static CoordinateReferenceSystem getTargetCRSOrDefault(IScope iScope) {
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        return iProjection == null ? EPSG3857 : iProjection.getTargetCRS(iScope);
    }

    public static boolean saveTargetCRSAsPRJFile(IScope iScope, String string) {
        block12: {
            CoordinateReferenceSystem coordinateReferenceSystem = ProjectionFactory.getTargetCRSOrDefault(iScope);
            Throwable throwable = null;
            Object var4_5 = null;
            FileWriter fileWriter = new FileWriter(FilenameUtils.removeExtension((String)string) + ".prj");
            try {
                fileWriter.write(coordinateReferenceSystem.toString());
                if (fileWriter == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            fileWriter.close();
        }
        return true;
    }

    public CoordinateReferenceSystem getTargetCRS(IScope iScope) {
        if (this.targetCRS == null) {
            try {
                return this.computeDefaultCRS(iScope, GamaPreferences.External.LIB_TARGET_CRS.getValue(), true);
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.addContext("The cause could be that you try to re-project already projected data (see Gama > Preferences... > External for turning the option to true)");
                throw gamaRuntimeException;
            }
        }
        return this.targetCRS;
    }

    public CoordinateReferenceSystem getSaveCRS(IScope iScope) {
        if (GamaPreferences.External.LIB_USE_DEFAULT.getValue().booleanValue()) {
            return this.getWorld().getInitialCRS(iScope);
        }
        return this.computeDefaultCRS(iScope, GamaPreferences.External.LIB_OUTPUT_CRS.getValue(), false);
    }

    public CoordinateReferenceSystem getCRS(IScope iScope, int n) {
        return this.getCRS(iScope, n, true);
    }

    public CoordinateReferenceSystem getCRS(IScope iScope, int n, boolean bl) {
        if (n == 0) {
            return this.getTargetCRS(iScope);
        }
        return this.getCRS(iScope, EPSGPrefix + n, bl);
    }

    public CoordinateReferenceSystem getCRS(IScope iScope, String string) {
        return this.getCRS(iScope, string, true);
    }

    public CoordinateReferenceSystem getCRS(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        try {
            CoordinateReferenceSystem coordinateReferenceSystem = CRSCache.get(string);
            if (coordinateReferenceSystem == null) {
                if (string.startsWith(EPSGPrefix) || string.startsWith("CRS:")) {
                    coordinateReferenceSystem = CRS.decode((String)string, (boolean)bl);
                } else if (string.startsWith("PROJCS") || string.startsWith("GEOGCS") || string.startsWith("COMPD_CS")) {
                    coordinateReferenceSystem = CRS.parseWKT((String)string);
                } else if (Character.isDigit(string.charAt(0))) {
                    coordinateReferenceSystem = CRS.decode((String)(EPSGPrefix + string), (boolean)bl);
                }
                CRSCache.put(string, coordinateReferenceSystem);
            }
            return coordinateReferenceSystem;
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            noSuchAuthorityCodeException.printStackTrace();
            throw GamaRuntimeException.error("The EPSG code " + string + " cannot be found. GAMA may be unable to load or save any GIS data", iScope);
        }
        catch (FactoryException factoryException) {
            factoryException.printStackTrace();
            throw GamaRuntimeException.error("An exception occured in trying to decode GIS data:" + factoryException.getMessage(), iScope);
        }
    }

    public IProjection getWorld() {
        return this.world;
    }

    public CoordinateReferenceSystem computeDefaultCRS(IScope iScope, int n, boolean bl) {
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCRS(iScope, n);
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = this.getCRS(iScope, EPSGPrefix + (bl ? defaultTargetCRS : defaultSaveCRS));
        }
        return coordinateReferenceSystem;
    }

    public IProjection fromParams(IScope iScope, Map<String, Object> map, Envelope3D envelope3D) {
        Boolean bl = map.containsKey("longitudeFirst") ? (Boolean)map.get("longitudeFirst") : true;
        Object object = map.get("crs");
        if (object instanceof String) {
            return this.fromCRS(iScope, this.getCRS(iScope, (String)object, (boolean)bl), envelope3D);
        }
        Object object2 = map.get("srid");
        if (object2 instanceof String) {
            return this.fromCRS(iScope, this.getCRS(iScope, (String)object2, (boolean)bl), envelope3D);
        }
        return this.fromCRS(iScope, this.getDefaultInitialCRS(iScope), envelope3D);
    }

    public IProjection fromCRS(IScope iScope, CoordinateReferenceSystem coordinateReferenceSystem, Envelope3D envelope3D) {
        if (envelope3D != null) {
            this.testConsistency(iScope, coordinateReferenceSystem, envelope3D);
        }
        if (this.world != null) {
            return new Projection(iScope, this.world, coordinateReferenceSystem, envelope3D, this);
        }
        if (envelope3D != null) {
            this.computeTargetCRS(iScope, coordinateReferenceSystem, envelope3D.centre().x, envelope3D.centre().y);
        }
        this.world = new WorldProjection(iScope, coordinateReferenceSystem, envelope3D, this);
        return this.world;
    }

    public IProjection forSavingWith(IScope iScope, Integer n) throws FactoryException {
        return this.forSavingWith(iScope, n, true);
    }

    public IProjection forSavingWith(IScope iScope, Integer n, boolean bl) throws FactoryException {
        return this.forSavingWith(iScope, EPSGPrefix + String.valueOf(n), bl);
    }

    public IProjection forSavingWith(IScope iScope, String string) throws FactoryException {
        return this.forSavingWith(iScope, string, true);
    }

    public IProjection forSavingWith(IScope iScope, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        Projection projection = new Projection(this.world, this);
        projection.initialCRS = coordinateReferenceSystem;
        projection.createTransformation(projection.computeProjection(iScope));
        return projection;
    }

    public IProjection forSavingWith(IScope iScope, String string, boolean bl) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        try {
            coordinateReferenceSystem = this.getCRS(iScope, string, bl);
        }
        catch (Exception exception) {
            coordinateReferenceSystem = null;
        }
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = this.getSaveCRS(iScope);
        }
        Projection projection = new Projection(this.world, this);
        projection.initialCRS = coordinateReferenceSystem;
        projection.createTransformation(projection.computeProjection(iScope));
        return projection;
    }

    public CoordinateReferenceSystem getDefaultInitialCRS(IScope iScope) {
        if (GamaPreferences.External.LIB_PROJECTED.getValue().booleanValue()) {
            return this.getTargetCRS(iScope);
        }
        try {
            return this.getCRS(iScope, GamaPreferences.External.LIB_INITIAL_CRS.getValue());
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw GamaRuntimeException.error("The code " + String.valueOf(GamaPreferences.External.LIB_INITIAL_CRS.getValue()) + " does not correspond to a known EPSG code. Try to change it in Gama > Preferences... > External", iScope);
        }
    }

    public void testConsistency(IScope iScope, CoordinateReferenceSystem coordinateReferenceSystem, Envelope envelope) {
        if (!(coordinateReferenceSystem instanceof DefaultProjectedCRS) && (envelope.getHeight() > 180.0 || envelope.getWidth() > 180.0)) {
            throw GamaRuntimeException.error("Inconsistency between the data and the CRS: The CRS " + String.valueOf(coordinateReferenceSystem) + " corresponds to a not projected one, whereas the data seem to be already projected.", iScope);
        }
    }

    public UnitConverter getUnitConverter() {
        return this.unitConverter;
    }
}

