/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.core.outputs.AbstractOutput;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;

public abstract class AbstractValuedDisplayOutput
extends AbstractOutput {
    protected String expressionText = "";
    protected IExpression value;
    protected Object lastValue = "";

    public AbstractValuedDisplayOutput(IDescription iDescription) {
        super(iDescription);
        this.setValue(this.getFacet("value"));
        this.expressionText = this.getValue() == null ? "" : this.getValue().serializeToGaml(false);
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    public IExpression getValue() {
        return this.value;
    }

    public String getExpressionText() {
        return this.expressionText == null ? "" : this.expressionText;
    }

    public boolean setNewExpressionText(String string) {
        IExpression iExpression;
        this.expressionText = string;
        try {
            iExpression = GAML.compileExpression(string, this.getScope().getSimulation(), true);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            iExpression = GAML.compileExpression(string, this.getScope().getExperiment(), true);
        }
        this.setValue(iExpression);
        return this.getScope().step(this).passed();
    }

    public void setNewExpression(IExpression iExpression) throws GamaRuntimeException {
        this.expressionText = iExpression == null ? "" : iExpression.serializeToGaml(false);
        this.setValue(iExpression);
        this.getScope().step(this);
    }

    protected void setValue(IExpression iExpression) {
        this.value = iExpression;
    }
}

