/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IOverlayProvider;
import gama.core.common.interfaces.IUpdaterMessage;
import gama.core.common.interfaces.IUpdaterTarget;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.GraphicLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="rounded", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not the rectangular shape of the overlay should be rounded. True by default")}), @GamlAnnotations.facet(name="border", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Color to apply to the border of the rectangular shape of the overlay. Nil by default")}), @GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the view from its position. Coordinates in [0,1[ are treated as percentages of the total surface of the view, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Unlike  'position', no elevation can be provided with the z coordinate ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency rate of the overlay (between 0 -- opaque and 1 -- fully transparent) when it is displayed inside the view. The bottom overlay will remain at 0.75")}), @GamlAnnotations.facet(name="left", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that will be evaluated and displayed in the left section of the bottom overlay")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="right", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that will be evaluated and displayed in the right section of the bottom overlay")}), @GamlAnnotations.facet(name="center", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that will be evaluated and displayed in the center section of the bottom overlay")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the background color of the overlay displayed inside the view (the bottom overlay remains black)")}), @GamlAnnotations.facet(name="color", type={5, 6}, of=6, optional=true, doc={@GamlAnnotations.doc(value="the color(s) used to display the expressions given in the 'left', 'center' and 'right' facets")})})
@GamlAnnotations.doc(value="`overlay` allows the modeler to display a line to the already existing bottom overlay, where the results of 'left', 'center' and 'right' facets, when they are defined, are displayed with the corresponding color if defined.", usages={@GamlAnnotations.usage(value="To display information in the bottom overlay, the syntax is:", examples={@GamlAnnotations.example(value="overlay \"Cycle: \" + (cycle) center: \"Duration: \" + total_duration + \"ms\" right: \"Model time: \" + as_date(time,\"\") color: [#yellow, #orange, #yellow];", isExecutable=false)})}, see={"display", "agents", "chart", "event", "graphics", "display_grid", "image", "species_layer"})
public class OverlayStatement
extends GraphicLayerStatement
implements IOverlayProvider<OverlayInfo> {
    final IExpression left = this.getFacet("left");
    final IExpression right = this.getFacet("right");
    final IExpression center = this.getFacet("center");
    final IExpression color = this.getFacet("color");
    String leftValue;
    String rightValue;
    String centerValue;
    List<int[]> constantColors;
    IUpdaterTarget<OverlayInfo> overlay;

    public OverlayStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        if (this.color != null && this.color.isConst()) {
            this.constantColors = this.computeColors(null);
        }
    }

    private List<int[]> computeColors(IScope iScope) {
        if (this.constantColors != null) {
            return this.constantColors;
        }
        if (this.color == null) {
            return null;
        }
        if (this.color.getGamlType().id() != 5) {
            int[] nArray = OverlayStatement.computeColor(iScope, this.color.value(iScope));
            return Arrays.asList(nArray, nArray, nArray);
        }
        IList iList = Cast.asList(iScope, this.color.value(iScope));
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = 0;
        for (Object e : iList) {
            int[] nArray = OverlayStatement.computeColor(iScope, e);
            arrayList.add(nArray);
            if (++n > 2) break;
        }
        return arrayList;
    }

    private static int[] computeColor(IScope iScope, Object object) {
        GamaColor gamaColor = Cast.asColor(iScope, object);
        return new int[]{gamaColor.red(), gamaColor.green(), gamaColor.blue()};
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.OVERLAY;
    }

    @Override
    protected boolean _step(IScope iScope) {
        if (this.overlay == null) {
            return true;
        }
        this.leftValue = this.left == null ? null : Cast.asString(iScope, this.left.value(iScope));
        this.rightValue = this.right == null ? null : Cast.asString(iScope, this.right.value(iScope));
        this.centerValue = this.center == null ? null : Cast.asString(iScope, this.center.value(iScope));
        this.overlay.updateWith(new OverlayInfo(this.getValues(), this.computeColors(iScope)));
        return true;
    }

    private String[] getValues() {
        return new String[]{this.leftValue, this.centerValue, this.rightValue};
    }

    @Override
    public void setTarget(IUpdaterTarget<OverlayInfo> iUpdaterTarget, IDisplaySurface iDisplaySurface) {
        this.overlay = iUpdaterTarget;
        this._step(iDisplaySurface.getScope());
    }

    @Override
    public boolean isToCreate() {
        return !this.aspect.isEmpty();
    }

    public boolean hasInfo() {
        return this.left != null || this.right != null || this.center != null;
    }

    public static class OverlayInfo
    implements IUpdaterMessage {
        public String[] infos;
        public List<int[]> colors;

        OverlayInfo(String[] stringArray, List<int[]> list) {
            this.infos = stringArray;
            this.colors = list;
        }
    }
}

