/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFile;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@GamlAnnotations.file(name="xml", extensions={"xml"}, buffer_type=10, concept={"file", "xml"}, doc={@GamlAnnotations.doc(value="Represents XML files. The internal representation is a list of strings")})
public class GamaXMLFile
extends GamaFile<IMap<String, String>, String> {
    @GamlAnnotations.doc(value="This file constructor allows to read a xml file", examples={@GamlAnnotations.example(value="file f <-xml_file(\"file.xml\");", isExecutable=false)})
    public GamaXMLFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    public String getRootTag(IScope iScope) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(this.getPath(iScope)));
            return document.getFirstChild().getNodeName();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.FILE.of(Types.INT, Types.NO_TYPE);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create(Types.STRING);
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFile(iScope)));){
                IMap iMap = GamaMapFactory.create(Types.STRING, Types.STRING);
                String string = bufferedReader.readLine();
                while (string != null) {
                    iMap.put(string, string + "\n");
                    string = bufferedReader.readLine();
                }
                this.setBuffer(iMap);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }
}

