/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.weighted_tasks;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.reflex.ReflexArchitecture;
import gama.gaml.architecture.weighted_tasks.WeightedTaskStatement;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.skill(name="weighted_tasks", concept={"architecture", "behavior", "task_based"})
@GamlAnnotations.doc(value="The class WeightedTasksArchitecture. A simple architecture of competing tasks, where one can be active at a time. Weights of the tasks are computed every step and the chosen task is simply the one with the maximal weight")
public class WeightedTasksArchitecture
extends ReflexArchitecture {
    public static final String WT = "weighted_tasks";
    List<WeightedTaskStatement> tasks = new ArrayList<WeightedTaskStatement>();

    @Override
    protected void clearBehaviors() {
        super.clearBehaviors();
        this.tasks.clear();
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        super.executeOn(iScope);
        WeightedTaskStatement weightedTaskStatement = this.chooseTask(iScope);
        if (weightedTaskStatement != null) {
            return iScope.execute(weightedTaskStatement).getValue();
        }
        return null;
    }

    protected WeightedTaskStatement chooseTask(IScope iScope) throws GamaRuntimeException {
        Double d = Double.MIN_VALUE;
        WeightedTaskStatement weightedTaskStatement = null;
        for (WeightedTaskStatement weightedTaskStatement2 : this.tasks) {
            Double d2 = weightedTaskStatement2.computeWeight(iScope);
            if (!(d2 > d)) continue;
            weightedTaskStatement = weightedTaskStatement2;
            d = d2;
        }
        return weightedTaskStatement;
    }

    @Override
    public void addBehavior(IStatement iStatement) {
        if (iStatement instanceof WeightedTaskStatement) {
            this.tasks.add((WeightedTaskStatement)iStatement);
        } else {
            super.addBehavior(iStatement);
        }
    }
}

