/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.variables;

import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.types.IType;

public abstract class VariableExpression
extends AbstractExpression
implements IVarExpression {
    protected final String name;
    protected final boolean isNotModifiable;
    private final IDescription enclosingDescription;

    protected VariableExpression(String string, IType<?> iType, boolean bl, IDescription iDescription) {
        this.name = string;
        this.setType(iType);
        this.isNotModifiable = bl;
        this.enclosingDescription = iDescription;
    }

    @Override
    public IExpression getOwner() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VariableExpression getVar() {
        return this;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isNotModifiable() {
        return this.isNotModifiable;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    public IDescription getDefinitionDescription() {
        return this.enclosingDescription;
    }

    protected void setType(IType<?> iType) {
        this.type = iType;
    }

    @Override
    public String getTitle() {
        return this.isNotModifiable ? "constant" : "variable " + this.getName() + " of type " + String.valueOf(this.getGamlType()) + (String)(this.enclosingDescription != null ? " defined in " + this.getDefinitionDescription().getTitle() : "");
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }

    @Override
    public boolean isContextIndependant() {
        return false;
    }
}

