/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(symbols={"action"}, kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that is returned")})}, omissible="value")
@GamlAnnotations.doc(value="Allows to immediately stop and tell which value to return from the evaluation of the surrounding action or top-level statement (reflex, init, etc.). Usually used within the declaration of an action. For more details about actions, see the following [Section161 section].", usages={@GamlAnnotations.usage(value="Example:", examples={@GamlAnnotations.example(value="string foo {", isExecutable=false), @GamlAnnotations.example(value="     return \"foo\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="reflex {", isExecutable=false), @GamlAnnotations.example(value="    string foo_result <- foo(); \t// foos_result is now equals to \"foo\"", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="In the specific case one wants an agent to ask another agent to execute a statement with a return, it can be done similarly to:", examples={@GamlAnnotations.example(value="// In Species A:", isExecutable=false), @GamlAnnotations.example(value="string foo_different {", isExecutable=false), @GamlAnnotations.example(value="     return \"foo_not_same\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="/// ....", isExecutable=false), @GamlAnnotations.example(value="// In Species B:", isExecutable=false), @GamlAnnotations.example(value="reflex writing {", isExecutable=false), @GamlAnnotations.example(value="    string temp <- some_agent_A.foo_different []; \t// temp is now equals to \"foo_not_same\" ", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class ReturnStatement
extends AbstractStatement {
    final IExpression value = this.getFacet("value");

    public ReturnStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = this.value == null ? null : this.value.value(iScope);
        iScope.setReturnStatus();
        return object;
    }
}

