/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import gama.core.common.geometry.GeometryUtils;
import gama.core.common.interfaces.ITyped;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.SimpleScalingProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.BiConsumerWithPruning;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.SaveStatement;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.geotools.feature.SchemaException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;

public abstract class AbstractShapeSaver
extends AbstractSaver {
    private static final String DOES_NOT_CORRESPOND_TO_A_KNOWN_EPSG_CODE = " does not correspond to a known EPSG code. GAMA is unable to save ";
    private static final String THE_CODE = "The code ";
    private static final String EPSG_LABEL = "EPSG:";

    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws GamaRuntimeException {
        this.save(iScope, iExpression, file2, saveOptions.code, saveOptions.attributesToSave);
    }

    public void save(IScope iScope, IExpression iExpression, OutputStream outputStream, String string, Object object) throws GamaRuntimeException {
        this.save(iScope, iExpression, (Object)outputStream, string, object);
    }

    private void save(IScope iScope, IExpression iExpression, Object object, String string, Object object2) throws GamaRuntimeException {
        IList<IShape> iList;
        Object object3 = iExpression.value(iScope);
        if (object3 instanceof ISpecies) {
            ISpecies iSpecies = (ISpecies)object3;
            iList = iScope.getAgent().getPopulationFor(iSpecies);
        } else if (object3 instanceof IShape) {
            IShape iShape = (IShape)object3;
            iList = GamaListFactory.wrap((IType)Types.GEOMETRY, iShape);
        } else if (object3 instanceof IList) {
            iList = (IList)object3;
        } else {
            throw GamaRuntimeException.error(iExpression.serializeToGaml(true) + " is not a list of agents or geometries", iScope);
        }
        StringBuilder stringBuilder = new StringBuilder(iList.size() * 20);
        String string2 = GeometryUtils.getGeometryStringType(iList);
        stringBuilder.append("geometry:" + string2);
        try {
            Object object4;
            Map.Entry<String, IExpression> entry2;
            SpeciesDescription speciesDescription;
            if (iList instanceof IPopulation) {
                IList<IShape> iList2 = iList;
                speciesDescription = iList2.getSpecies().getDescription();
            } else {
                speciesDescription = iList.getGamlType().getContentType().getSpecies();
            }
            SpeciesDescription speciesDescription2 = speciesDescription;
            Map<String, IExpression> map = this.computeInits(iScope, speciesDescription2, object2);
            for (Map.Entry<String, IExpression> entry2 : map.entrySet()) {
                object4 = (String)entry2.getKey();
                if (object4 == null) continue;
                IExpression iExpression2 = (IExpression)entry2.getValue();
                String string3 = ((String)object4).replace("\"", "").replace("'", "").replace(":", "_");
                String string4 = AbstractShapeSaver.type(iExpression2);
                stringBuilder.append(',').append(string3).append(':').append(string4);
            }
            entry2 = this.defineProjection(iScope, string);
            if (object instanceof File) {
                File file2 = (File)object;
                this.internalSave(iScope, file2, iList, stringBuilder.toString(), string2, map, (IProjection)((Object)entry2), string);
            } else if (object instanceof OutputStream) {
                object4 = (OutputStream)object;
                this.internalSave(iScope, (OutputStream)object4, iList, stringBuilder.toString(), string2, map, (IProjection)((Object)entry2), string);
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create(exception, iScope);
        }
    }

    public static String type(ITyped iTyped) {
        return switch (iTyped.getGamlType().id()) {
            case 3 -> "Boolean";
            case 1 -> "Integer";
            case 2 -> "Double";
            default -> "String";
        };
    }

    public void internalSave(IScope iScope, File file2, List<? extends IShape> list, String string, String string2, Map<String, IExpression> map, IProjection iProjection, String string3) throws GamaRuntimeException, IOException, SchemaException {
        Throwable throwable = null;
        Object var10_11 = null;
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(file2.toPath(), new OpenOption[0]));){
            this.internalSave(iScope, bufferedOutputStream, list, string, string2, map, iProjection, string3);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected abstract void internalSave(IScope var1, OutputStream var2, List<? extends IShape> var3, String var4, String var5, Map<String, IExpression> var6, IProjection var7, String var8) throws IOException, SchemaException, GamaRuntimeException;

    /*
     * Unable to fully structure code
     */
    protected final Map<String, IExpression> computeInits(IScope var1_1, SpeciesDescription var2_2, Object var3_3) throws GamaRuntimeException {
        if (var3_3 == null) {
            return Collections.EMPTY_MAP;
        }
        var4_4 = GamaMapFactory.create();
        if (!(var3_3 instanceof Arguments)) ** GOTO lbl-1000
        var5_5 = (Arguments)var3_3;
        if (var2_2 != null) {
            if (var5_5.isEmpty()) {
                for (String var6_9 : var2_2.getAttributeNames()) {
                    if (SaveStatement.NON_SAVEABLE_ATTRIBUTE_NAMES.contains(var6_9)) continue;
                    var4_4.put(var6_9, var2_2.getVarExpr(var6_9, false));
                }
            } else {
                var5_5.forEachFacet((BiConsumerWithPruning<String, IExpressionDescription>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$0(java.util.Map gama.gaml.descriptions.SpeciesDescription java.lang.String gama.gaml.descriptions.IExpressionDescription ), (Ljava/lang/String;Lgama/gaml/descriptions/IExpressionDescription;)Z)((Map)var4_4, (SpeciesDescription)var2_2));
            }
        } else if (var3_3 instanceof MapExpression) {
            var6_10 = (MapExpression)var3_3;
            var7_7 = var6_10.getElements();
            var7_7.forEach((BiConsumer<IExpression, IExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$1(gama.core.runtime.IScope java.util.Map gama.gaml.expressions.IExpression gama.gaml.expressions.IExpression ), (Lgama/gaml/expressions/IExpression;Lgama/gaml/expressions/IExpression;)V)((IScope)var1_1, (Map)var4_4));
        } else if (var3_3 instanceof IExpression) {
            var7_8 = (IExpression)var3_3;
            var8_11 = GamaListFactory.create(var1_1, (IType)Types.STRING, Cast.asList(var1_1, var7_8.value(var1_1)));
            if (var2_2 != null) {
                var8_11.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$2(java.util.Map gama.gaml.descriptions.SpeciesDescription java.lang.String ), (Ljava/lang/String;)V)((Map)var4_4, (SpeciesDescription)var2_2));
            } else {
                var8_11.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$3(java.util.Map java.lang.String ), (Ljava/lang/String;)V)((Map)var4_4));
            }
        }
        return var4_4;
    }

    protected IProjection defineProjection(IScope iScope, String string) {
        IProjection iProjection;
        Object object = string;
        if (object == null) {
            boolean bl = GamaPreferences.External.LIB_USE_DEFAULT.getValue();
            if (!bl) {
                object = EPSG_LABEL + String.valueOf(GamaPreferences.External.LIB_OUTPUT_CRS.getValue());
                try {
                    iProjection = iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, (String)object);
                }
                catch (FactoryException factoryException) {
                    throw GamaRuntimeException.error(THE_CODE + (String)object + DOES_NOT_CORRESPOND_TO_A_KNOWN_EPSG_CODE, iScope);
                }
            } else {
                iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
                if (iProjection == null || iProjection.getInitialCRS(iScope) == null) {
                    boolean bl2 = GamaPreferences.External.LIB_PROJECTED.getValue();
                    object = bl2 ? EPSG_LABEL + String.valueOf(GamaPreferences.External.LIB_TARGET_CRS.getValue()) : EPSG_LABEL + String.valueOf(GamaPreferences.External.LIB_INITIAL_CRS.getValue());
                    try {
                        iProjection = iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, (String)object);
                    }
                    catch (FactoryException factoryException) {
                        throw GamaRuntimeException.error(THE_CODE + (String)object + DOES_NOT_CORRESPOND_TO_A_KNOWN_EPSG_CODE, iScope);
                    }
                }
            }
        } else {
            if (((String)object).startsWith("GAMA")) {
                if ("GAMA".equals(object)) {
                    return null;
                }
                String[] stringArray = ((String)object).split("::");
                if (stringArray.length == 2) {
                    Double d = Double.parseDouble(stringArray[1]);
                    return new SimpleScalingProjection(d);
                }
                return null;
            }
            try {
                iProjection = iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, (String)object);
            }
            catch (FactoryException factoryException) {
                throw GamaRuntimeException.error(THE_CODE + (String)object + DOES_NOT_CORRESPOND_TO_A_KNOWN_EPSG_CODE, iScope);
            }
        }
        return iProjection;
    }

    protected Geometry geometryCollectionToSimpleManagement(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = geometryCollection.getNumGeometries();
            ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
            ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
            ArrayList<Point> arrayList3 = new ArrayList<Point>();
            int n2 = 0;
            while (n2 < n) {
                Geometry geometry2 = geometryCollection.getGeometryN(n2);
                if (geometry2 instanceof Polygon) {
                    Polygon polygon = (Polygon)geometry2;
                    arrayList.add(polygon);
                } else if (geometry2 instanceof LineString) {
                    LineString lineString = (LineString)geometry2;
                    arrayList2.add(lineString);
                } else if (geometry2 instanceof Point) {
                    Point point = (Point)geometry2;
                    arrayList3.add(point);
                }
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                if (arrayList.size() == 1) {
                    return (Geometry)arrayList.get(0);
                }
                Polygon[] polygonArray = new Polygon[arrayList.size()];
                int n3 = 0;
                while (n3 < polygonArray.length) {
                    polygonArray[n3] = (Polygon)arrayList.get(n3);
                    ++n3;
                }
                return GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
            }
            if (!arrayList2.isEmpty()) {
                if (arrayList2.size() == 1) {
                    return (Geometry)arrayList2.get(0);
                }
                LineString[] lineStringArray = new LineString[arrayList2.size()];
                int n4 = 0;
                while (n4 < lineStringArray.length) {
                    lineStringArray[n4] = (LineString)arrayList2.get(n4);
                    ++n4;
                }
                return GeometryUtils.GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
            }
            if (!arrayList3.isEmpty()) {
                if (arrayList3.size() == 1) {
                    return (Geometry)arrayList3.get(0);
                }
                Point[] pointArray = new Point[arrayList3.size()];
                int n5 = 0;
                while (n5 < pointArray.length) {
                    pointArray[n5] = (Point)arrayList3.get(n5);
                    ++n5;
                }
                return GeometryUtils.GEOMETRY_FACTORY.createMultiPoint(pointArray);
            }
        }
        return geometry;
    }

    public static boolean buildFeature(IScope iScope, SimpleFeature simpleFeature, IShape iShape, IProjection iProjection, Collection<IExpression> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return false;
        }
        if (iProjection != null) {
            geometry = iProjection.inverseTransform(geometry);
        }
        geometry = GeometryUtils.cleanGeometryCollection(GeometryUtils.fixesPolygonCWS(geometry));
        arrayList.add(geometry);
        if (iShape instanceof IAgent) {
            IAgent iAgent = (IAgent)iShape;
            for (IExpression iExpression : collection) {
                Object object = iAgent.getScope().evaluate(iExpression, iAgent).getValue();
                if (iExpression.getGamlType().equals(Types.STRING)) {
                    object = object == null ? "" : StringUtils.toJavaString(object.toString());
                }
                arrayList.add(object);
            }
        } else {
            for (IExpression iExpression : collection) {
                Object object = iExpression.value(iScope);
                if (object instanceof String) {
                    String string = (String)object;
                    arrayList.add(iShape.getAttribute(string));
                    continue;
                }
                arrayList.add("");
            }
        }
        simpleFeature.setAttributes(arrayList);
        return true;
    }

    private static /* synthetic */ boolean lambda$0(Map map, SpeciesDescription speciesDescription, String string, IExpressionDescription iExpressionDescription) {
        map.put(iExpressionDescription.getExpression().literalValue(), speciesDescription.getVarExpr(string, false));
        return true;
    }

    private static /* synthetic */ void lambda$1(IScope iScope, Map map, IExpression iExpression, IExpression iExpression2) {
        String string = Cast.asString(iScope, iExpression.value(iScope));
        map.put(string, iExpression2);
    }

    private static /* synthetic */ void lambda$2(Map map, SpeciesDescription speciesDescription, String string) {
        ConstantExpression constantExpression = map.put(string, speciesDescription.hasAttribute(string) ? speciesDescription.getVarExpr(string, false) : IExpressionFactory.NIL_EXPR);
    }

    private static /* synthetic */ void lambda$3(Map map, String string) {
        ConstantExpression constantExpression = map.put(string, new ConstantExpression(string));
    }
}

