/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.file.json.ParseException;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="map", id=10, wraps={IMap.class}, kind=102, concept={"type", "container", "map"}, doc={@GamlAnnotations.doc(value="Represents lists of pairs key::value, where each key is unique in the map. Maps are ordered by the insertion order of elements")})
public class GamaMapType
extends GamaContainerType<IMap> {
    @Override
    @GamlAnnotations.doc(value="Casts the operand into a map. In case of an agent, returns its attributes. In case of a string, tries to parse JSON contents and returns a corresponding map.")
    public IMap cast(IScope iScope, Object object, Object object2, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        return GamaMapType.staticCast(iScope, object, iType, iType2, bl);
    }

    public static IMap staticCast(IScope iScope, Object object, IType iType, IType iType2, boolean bl) {
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            return iAgent.getOrCreateAttributes();
        }
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            return iContainer.mapValue(iScope, iType, iType2, bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                JsonValue jsonValue = Json.getNew().parse(string);
                if (jsonValue instanceof IMap) {
                    IMap iMap = (IMap)((Object)jsonValue);
                    return iMap;
                }
                IMap iMap = GamaMapFactory.create();
                iMap.put("contents", jsonValue);
                return iMap;
            }
            catch (ParseException parseException) {
                throw GamaRuntimeException.create(parseException, iScope);
            }
        }
        IMap iMap = GamaMapFactory.create(iType, iType2);
        if (object != null) {
            iMap.setValueAtIndex(iScope, object, object);
        }
        return iMap;
    }

    @Override
    public int getNumberOfParameters() {
        return 2;
    }

    @Override
    public IType keyTypeIfCasting(IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        if (iType.isAgentType()) {
            return Types.STRING;
        }
        switch (iType.id()) {
            case 4: {
                return Types.STRING;
            }
            case 9: 
            case 10: {
                return iType.getKeyType();
            }
            case 8: {
                return iType.getContentType();
            }
            case 15: {
                return Types.PAIR;
            }
            case 5: {
                if (iType.getContentType().id() == 9) {
                    return iType.getContentType().getKeyType();
                }
                return iType.getContentType();
            }
        }
        return iType;
    }

    @Override
    public IType contentsTypeIfCasting(IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        if (iType.isAgentType()) {
            return Types.NO_TYPE;
        }
        switch (iType.id()) {
            case 4: {
                return Types.NO_TYPE;
            }
            case 5: {
                if (iType.getContentType().id() == 9) {
                    return iType.getContentType().getContentType();
                }
                return iType.getContentType();
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                return iType.getContentType();
            }
        }
        return iType;
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }
}

