/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.GamaCoordinateSequenceFactory;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.metamodel.shape.GamaPoint;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;

public class GamaGeometryFactory
extends GeometryFactory {
    public static final GamaCoordinateSequenceFactory COORDINATES_FACTORY = new GamaCoordinateSequenceFactory();
    public static final CoordinateSequenceFactory JTS_COORDINATES_FACTORY = CoordinateArraySequenceFactory.instance();

    public GamaGeometryFactory() {
        super((CoordinateSequenceFactory)COORDINATES_FACTORY);
    }

    public GeometryCollection createCollection(Geometry ... geometryArray) {
        return new GeometryCollection(geometryArray, (GeometryFactory)this);
    }

    public static boolean isRing(Coordinate[] coordinateArray) {
        return coordinateArray.length >= 4 && coordinateArray[0].equals((Object)coordinateArray[coordinateArray.length - 1]);
    }

    public static boolean isRing(List<GamaPoint> list) {
        int n = list.size();
        return n >= 4 && list.get(0).equals(list.get(n - 1));
    }

    public LinearRing createLinearRing(Coordinate[] coordinateArray) {
        Object[] objectArray = coordinateArray;
        if (!GamaGeometryFactory.isRing((Coordinate[])objectArray)) {
            objectArray = (Coordinate[])ArrayUtils.add((Object[])objectArray, (Object)objectArray[0]);
        }
        return this.createLinearRing(JTS_COORDINATES_FACTORY.create((Coordinate[])objectArray));
    }

    public Polygon createRectangle(Coordinate ... coordinateArray) {
        GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory = COORDINATES_FACTORY;
        CoordinateSequence coordinateSequence = gamaCoordinateSequenceFactory.create(coordinateArray);
        LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateSequence);
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, null);
    }

    public Polygon createPolygon(LinearRing linearRing, LinearRing[] linearRingArray) {
        LinearRing linearRing2 = this.turnClockwise(linearRing);
        if (linearRingArray != null) {
            int n = 0;
            while (n < linearRingArray.length) {
                linearRingArray[n] = this.turnClockwise(linearRingArray[n]);
                ++n;
            }
        }
        return super.createPolygon(linearRing2, linearRingArray);
    }

    private LinearRing turnClockwise(LinearRing linearRing) {
        if (linearRing == null || linearRing.isEmpty()) {
            return linearRing;
        }
        return this.createLinearRing(COORDINATES_FACTORY.create(linearRing.getCoordinateSequence()));
    }

    public GamaCoordinateSequenceFactory getCoordinateSequenceFactory() {
        return COORDINATES_FACTORY;
    }

    public LineString createLineString(GamaPoint[] gamaPointArray, boolean bl) {
        return this.createLineString(COORDINATES_FACTORY.create(gamaPointArray, bl));
    }

    public Geometry createFatLine(Geometry geometry, double d) {
        ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(geometry);
        Polygon[] polygonArray = new Polygon[iCoordinates.size() - 1];
        int[] nArray = new int[1];
        iCoordinates.visit((gamaPoint, gamaPoint2) -> {
            double d2 = gamaPoint2.x;
            double d3 = gamaPoint.x;
            double d4 = gamaPoint2.y;
            double d5 = gamaPoint.y;
            double d6 = d2 - d3;
            double d7 = d4 - d5;
            double d8 = gamaPoint2.distance(gamaPoint);
            double d9 = 0.5 * d * -(d7 /= d8);
            double d10 = 0.5 * d * (d6 /= d8);
            polygonArray[nArray[0]] = this.createRectangle(new GamaPoint(d3 + d9, d5 + d10), new GamaPoint(d2 + d9, d4 + d10), new GamaPoint(d2 - d9, d4 - d10), new GamaPoint(d3 - d9, d5 - d10), new GamaPoint(d3 + d9, d5 + d10));
            nArray[0] = nArray[0] + 1;
        });
        GeometryCollection geometryCollection = this.createGeometryCollection((Geometry[])polygonArray);
        return geometryCollection.union();
    }
}

