/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.interfaces.IEnvelopeComputer;
import gama.core.common.interfaces.IEnvelopeProvider;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;
import gama.dev.DEBUG;
import gama.gaml.operators.Files;
import gama.gaml.operators.Graphs;
import gama.gaml.operators.Random;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialThreeD;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.ConstraintEnforcementException;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;
import org.locationtech.jts.triangulate.quadedge.LocateFailureException;
import org.locationtech.jts.util.AssertionFailedException;

public class GeometryUtils {
    private static List<IEnvelopeComputer> envelopeComputers;
    public static final GamaGeometryFactory GEOMETRY_FACTORY;
    public static final PreparedGeometryFactory PREPARED_GEOMETRY_FACTORY;
    public static final PointLocator POINT_LOCATOR;

    static {
        DEBUG.OFF();
        envelopeComputers = new ArrayList<IEnvelopeComputer>();
        GEOMETRY_FACTORY = new GamaGeometryFactory();
        PREPARED_GEOMETRY_FACTORY = new PreparedGeometryFactory();
        POINT_LOCATOR = new PointLocator();
    }

    public static void addEnvelopeComputer(IEnvelopeComputer iEnvelopeComputer) {
        envelopeComputers.add(iEnvelopeComputer);
    }

    public static Double distanceOnPolyline(IShape iShape, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        GamaPoint gamaPoint3;
        GamaPoint gamaPoint4;
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        IList<GamaPoint> iList = iShape.getPoints();
        int n5 = iList.size();
        if (n5 == 2) {
            return gamaPoint.euclidianDistanceTo(gamaPoint2);
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        int n6 = 0;
        while (n6 < n5 - 1) {
            double d3 = Distance.pointToSegment((Coordinate)gamaPoint, (Coordinate)((Coordinate)iList.get(n6)), (Coordinate)((Coordinate)iList.get(n6 + 1)));
            double d4 = Distance.pointToSegment((Coordinate)gamaPoint2, (Coordinate)((Coordinate)iList.get(n6)), (Coordinate)((Coordinate)iList.get(n6 + 1)));
            if (d3 < d) {
                d = d3;
                n3 = n6;
            }
            if (d4 < d2) {
                d2 = d4;
                n4 = n6;
            }
            ++n6;
        }
        if (n3 == n4) {
            return gamaPoint.euclidianDistanceTo(gamaPoint2);
        }
        d = 0.0;
        if (n4 > n3) {
            n2 = n3 + 1;
            n = n4;
            gamaPoint4 = gamaPoint;
            gamaPoint3 = gamaPoint2;
        } else {
            n2 = n4 + 1;
            n = n3;
            gamaPoint4 = gamaPoint2;
            gamaPoint3 = gamaPoint;
        }
        d = gamaPoint4.euclidianDistanceTo((GamaPoint)iList.get(n2));
        int n7 = n2;
        while (n7 < n - 1) {
            GamaPoint gamaPoint5 = (GamaPoint)iList.get(n7);
            d += gamaPoint4.euclidianDistanceTo(gamaPoint5);
            gamaPoint4 = gamaPoint5;
            ++n7;
        }
        return d += gamaPoint4.euclidianDistanceTo(gamaPoint3);
    }

    public static GamaPoint pointInGeom(IScope iScope, Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Coordinate[] coordinateArray = geometry.getCoordinates();
        if (coordinateArray.length < 1 || coordinateArray[0] == null) {
            return null;
        }
        if (geometry instanceof Point || coordinateArray.length < 2) {
            return new GamaPoint(geometry.getCoordinate());
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return GeometryUtils.pointInLineString(iScope, lineString);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return GeometryUtils.pointInPolygon(iScope, polygon);
        }
        if (geometry instanceof GeometryCollection) {
            if (geometry instanceof MultiLineString) {
                IList iList = GamaListFactory.create(Types.FLOAT);
                int n = 0;
                while (n < geometry.getNumGeometries()) {
                    iList.add(GeometryUtils.getContourCoordinates(geometry.getGeometryN(n)).getLength());
                    ++n;
                }
                n = Random.opRndChoice(iScope, iList);
                return GeometryUtils.pointInLineString(iScope, (LineString)geometry.getGeometryN(n));
            }
            if (geometry instanceof MultiPolygon) {
                IList iList = GamaListFactory.create(Types.FLOAT);
                int n = 0;
                while (n < geometry.getNumGeometries()) {
                    iList.add(geometry.getGeometryN(n).getArea());
                    ++n;
                }
                n = Random.opRndChoice(iScope, iList);
                return GeometryUtils.pointInPolygon(iScope, (Polygon)geometry.getGeometryN(n));
            }
            return GeometryUtils.pointInGeom(iScope, geometry.getGeometryN(iScope.getRandom().between(0, geometry.getNumGeometries() - 1)));
        }
        return null;
    }

    private static GamaPoint pointInPolygon(IScope iScope, Polygon polygon) {
        RandomUtils randomUtils = iScope.getRandom();
        Envelope envelope = polygon.getEnvelopeInternal();
        double d = envelope.getMinX();
        double d2 = envelope.getMaxX();
        double d3 = envelope.getMinY();
        double d4 = envelope.getMaxY();
        double d5 = randomUtils.between(d, d2);
        if (polygon.getArea() > 0.0) {
            double d6 = randomUtils.between(d3, d4);
            if (polygon.getNumInteriorRing() == 0) {
                GamaPoint gamaPoint = new GamaPoint(d5, d6, 0.0);
                Coordinate[] coordinateArray = polygon.getCoordinates();
                while (!PointLocation.isInRing((Coordinate)gamaPoint, (Coordinate[])coordinateArray)) {
                    gamaPoint.setLocation(randomUtils.between(d, d2), randomUtils.between(d3, d4), 0.0);
                }
                return gamaPoint;
            }
            ICoordinates iCoordinates = ICoordinates.ofLength(1);
            iCoordinates.setTo(d5, d6, 0.0);
            Point point = GEOMETRY_FACTORY.createPoint(iCoordinates);
            while (!polygon.intersects((Geometry)point)) {
                iCoordinates.setTo(randomUtils.between(d, d2), randomUtils.between(d3, d4), 0.0);
                point.geometryChanged();
            }
            return iCoordinates.at(0);
        }
        DEBUG.OUT((Object)"Point in Polygon with Area = 0");
        Coordinate coordinate = new Coordinate(d5, d3);
        Coordinate coordinate2 = new Coordinate(d5, d4);
        Coordinate[] coordinateArray = new Coordinate[]{coordinate, coordinate2};
        LineString lineString = GEOMETRY_FACTORY.createLineString(coordinateArray);
        try {
            lineString = (LineString)lineString.intersection((Geometry)polygon);
        }
        catch (Exception exception) {
            PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
            lineString = (LineString)GeometryPrecisionReducer.reducePointwise((Geometry)lineString, (PrecisionModel)precisionModel).intersection(GeometryPrecisionReducer.reducePointwise((Geometry)polygon, (PrecisionModel)precisionModel));
        }
        return GeometryUtils.pointInLineString(iScope, lineString);
    }

    private static GamaPoint pointInLineString(IScope iScope, LineString lineString) {
        DEBUG.OUT((Object)"Point in LineString");
        double d = GeometryUtils.getContourCoordinates(lineString).getLength();
        double d2 = d * iScope.getRandom().between(0.0, 1.0);
        double d3 = 0.0;
        Coordinate coordinate = lineString.getCoordinateN(0);
        int n = 1;
        while (n < lineString.getNumPoints()) {
            Coordinate coordinate2 = lineString.getCoordinateN(n);
            double d4 = coordinate.distance3D(coordinate2);
            if (d4 + d3 >= d2) {
                double d5 = (d2 - d3) / d4;
                double d6 = coordinate.x + d5 * (coordinate2.x - coordinate.x);
                double d7 = coordinate.y + d5 * (coordinate2.y - coordinate.y);
                double d8 = coordinate.z + d5 * (coordinate2.z - coordinate.z);
                return new GamaPoint(d6, d7, d8);
            }
            coordinate = coordinate2;
            d3 += d4;
            ++n;
        }
        return null;
    }

    public static GamaPoint pointInGeom(IScope iScope, IShape iShape) {
        if (iShape == null) {
            return null;
        }
        return GeometryUtils.pointInGeom(iScope, iShape.getInnerGeometry());
    }

    private static Coordinate[] minimiseLength(Coordinate[] coordinateArray) {
        double d = GEOMETRY_FACTORY.createLineString(coordinateArray).getLength();
        Coordinate[] coordinateArray2 = new Coordinate[]{coordinateArray[0], coordinateArray[2], coordinateArray[1]};
        double d2 = GEOMETRY_FACTORY.createLineString(coordinateArray2).getLength();
        Coordinate[] coordinateArray3 = new Coordinate[]{coordinateArray[1], coordinateArray[0], coordinateArray[2]};
        double d3 = GEOMETRY_FACTORY.createLineString(coordinateArray3).getLength();
        if (d <= d2 && d <= d3) {
            return coordinateArray;
        }
        if (d2 <= d && d2 <= d3) {
            return coordinateArray2;
        }
        if (d3 <= d && d3 <= d2) {
            return coordinateArray3;
        }
        return coordinateArray;
    }

    public static int nbCommonPoints(Geometry geometry, Geometry geometry2) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Collector.AsSet asSet = Collector.getSet();){
            List<Coordinate> list = Arrays.asList(geometry.getCoordinates());
            Coordinate[] coordinateArray = geometry2.getCoordinates();
            int n = coordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate coordinate = coordinateArray[n2];
                if (list.contains(coordinate)) {
                    asSet.add(coordinate);
                }
                ++n2;
            }
            return asSet.size();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Coordinate[] extractPoints(IShape iShape, Set<IShape> set) {
        Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
        int n = set.size();
        Coordinate[] coordinateArray2 = new Coordinate[]{coordinateArray[0], coordinateArray[1]};
        Coordinate[] coordinateArray3 = new Coordinate[]{coordinateArray[1], coordinateArray[2]};
        Coordinate[] coordinateArray4 = new Coordinate[]{coordinateArray[2], coordinateArray[3]};
        LineString lineString = GEOMETRY_FACTORY.createLineString(coordinateArray2);
        LineString lineString2 = GEOMETRY_FACTORY.createLineString(coordinateArray3);
        LineString lineString3 = GEOMETRY_FACTORY.createLineString(coordinateArray4);
        Coordinate[] coordinateArray5 = new Coordinate[n];
        if (n == 3) {
            coordinateArray5[0] = lineString.getCentroid().getCoordinate();
            coordinateArray5[1] = lineString2.getCentroid().getCoordinate();
            coordinateArray5[2] = lineString3.getCentroid().getCoordinate();
            return GeometryUtils.minimiseLength(coordinateArray5);
        }
        if (n != 2) {
            return null;
        }
        int n2 = 0;
        for (IShape iShape2 : set) {
            if (GeometryUtils.nbCommonPoints((Geometry)lineString, iShape2.getInnerGeometry()) == 2) {
                coordinateArray5[n2] = lineString.getCentroid().getCoordinate();
                ++n2;
                continue;
            }
            if (GeometryUtils.nbCommonPoints((Geometry)lineString2, iShape2.getInnerGeometry()) == 2) {
                coordinateArray5[n2] = lineString2.getCentroid().getCoordinate();
                ++n2;
                continue;
            }
            if (GeometryUtils.nbCommonPoints((Geometry)lineString3, iShape2.getInnerGeometry()) != 2) continue;
            coordinateArray5[n2] = lineString3.getCentroid().getCoordinate();
            ++n2;
        }
        return coordinateArray5;
    }

    public static Coordinate[] extractPoints(IShape iShape, IShape iShape2) {
        Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
        Coordinate[] coordinateArray2 = new Coordinate[]{coordinateArray[0], coordinateArray[1]};
        Coordinate[] coordinateArray3 = new Coordinate[]{coordinateArray[1], coordinateArray[2]};
        Coordinate[] coordinateArray4 = new Coordinate[]{coordinateArray[2], coordinateArray[3]};
        LineString lineString = GEOMETRY_FACTORY.createLineString(coordinateArray2);
        LineString lineString2 = GEOMETRY_FACTORY.createLineString(coordinateArray3);
        LineString lineString3 = GEOMETRY_FACTORY.createLineString(coordinateArray4);
        Coordinate[] coordinateArray5 = new Coordinate[3];
        if (GeometryUtils.nbCommonPoints((Geometry)lineString, iShape2.getInnerGeometry()) == 2) {
            coordinateArray5[1] = lineString.getCentroid().getCoordinate();
        } else if (GeometryUtils.nbCommonPoints((Geometry)lineString2, iShape2.getInnerGeometry()) == 2) {
            coordinateArray5[1] = lineString2.getCentroid().getCoordinate();
        } else if (GeometryUtils.nbCommonPoints((Geometry)lineString3, iShape2.getInnerGeometry()) == 2) {
            coordinateArray5[1] = lineString3.getCentroid().getCoordinate();
        }
        coordinateArray5[0] = iShape.getCentroid();
        coordinateArray5[2] = iShape2.getCentroid();
        return coordinateArray5;
    }

    public static IList<IShape> hexagonalGridFromGeom(IShape iShape, int n, int n2) {
        GamaShape gamaShape;
        int n3;
        Envelope3D envelope3D = iShape.getEnvelope();
        double d = envelope3D.getWidth();
        double d2 = envelope3D.getHeight();
        double d3 = envelope3D.getMinX();
        double d4 = envelope3D.getMinY();
        double d5 = d / ((double)n2 * 0.75 + 0.25);
        double d6 = d2 / (double)n;
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        d3 += d5 / 2.0;
        d4 += d6 / 2.0;
        int n4 = 0;
        while (n4 < n) {
            n3 = 0;
            while (n3 < n2) {
                gamaShape = (GamaShape)GamaGeometryType.buildHexagon(d5, d6, new GamaPoint(d3 + (double)n3 * d5 * 0.75, d4 + (double)n4 * d6, 0.0));
                if (iShape.covers(gamaShape)) {
                    iList.add(gamaShape);
                }
                n3 += 2;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            n3 = 1;
            while (n3 < n2) {
                gamaShape = (GamaShape)GamaGeometryType.buildHexagon(d5, d6, new GamaPoint(d3 + (double)n3 * d5 * 0.75, d4 + ((double)n4 + 0.5) * d6, 0.0));
                if (iShape.covers(gamaShape)) {
                    iList.add(gamaShape);
                }
                n3 += 2;
            }
            ++n4;
        }
        return iList;
    }

    public static IList<IShape> squareDiscretization(Geometry geometry, int n, boolean bl, double d) {
        ArrayList<IShape> arrayList;
        double d2 = Math.sqrt(geometry.getArea() / (double)n);
        IList<IShape> iList = GeometryUtils.discretization(geometry, d2, d2, bl, arrayList = new ArrayList<IShape>());
        if (iList.size() < n) {
            while (iList.size() < n) {
                arrayList = new ArrayList();
                iList = GeometryUtils.discretization(geometry, d2 *= d, d2, bl, arrayList);
            }
        } else if (iList.size() > n) {
            while (iList.size() > n) {
                IList<IShape> iList2;
                ArrayList<IShape> arrayList2 = new ArrayList<IShape>();
                if ((iList2 = GeometryUtils.discretization(geometry, d2 /= d, d2, bl, arrayList2)).size() >= n) {
                    iList = iList2;
                    arrayList = arrayList2;
                    continue;
                }
                break;
            }
        }
        int n2 = iList.size();
        if (n2 > n) {
            if (n2 - n > arrayList.size()) {
                iList.removeAll(arrayList);
            } else {
                int n3 = 0;
                while (n3 < n2 - n) {
                    iList.remove(arrayList.get(n3));
                    ++n3;
                }
            }
        }
        return iList;
    }

    public static IList<IShape> discretization(Geometry geometry, double d, double d2, boolean bl) {
        return GeometryUtils.discretization(geometry, d, d2, bl, null);
    }

    public static IList<IShape> discretization(Geometry geometry, double d, double d2, boolean bl, List<IShape> list) {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                iList.addAll(GeometryUtils.discretization(geometryCollection.getGeometryN(n), d, d2, bl, list));
                ++n;
            }
        } else {
            Envelope envelope = geometry.getEnvelopeInternal();
            double d3 = envelope.getMaxX();
            double d4 = envelope.getMaxY();
            double d5 = envelope.getMinX();
            boolean bl2 = true;
            while (d5 < d3) {
                double d6 = envelope.getMinY();
                bl2 = true;
                while (d6 < d4) {
                    GamaShape gamaShape;
                    Coordinate coordinate = new Coordinate(d5, d6);
                    Coordinate coordinate2 = new Coordinate(d5 + d, d6);
                    Coordinate coordinate3 = new Coordinate(d5 + d, d6 + d2);
                    Coordinate coordinate4 = new Coordinate(d5, d6 + d2);
                    Coordinate[] coordinateArray = new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4, coordinate};
                    Polygon polygon = GEOMETRY_FACTORY.createPolygon(GEOMETRY_FACTORY.createLinearRing(coordinateArray), null);
                    d6 += d2;
                    if (!bl) {
                        if (!polygon.coveredBy(geometry)) continue;
                        gamaShape = GamaShapeFactory.createFrom((Geometry)polygon);
                        iList.add(gamaShape);
                        if (bl2 && list != null) {
                            list.add(gamaShape);
                        }
                        bl2 = false;
                        continue;
                    }
                    if (!polygon.intersects(geometry)) continue;
                    gamaShape = GamaShapeFactory.createFrom((Geometry)polygon);
                    iList.add(gamaShape);
                    if (bl2 && list != null) {
                        list.add(gamaShape);
                    }
                    bl2 = false;
                }
                d5 += d;
            }
        }
        return iList;
    }

    public static IList<IShape> geometryDecomposition(IShape iShape, double d, double d2) {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        double d3 = iShape.getLocation().getZ();
        IList<IShape> iList2 = GeometryUtils.discretization(iShape.getInnerGeometry(), d, d2, true);
        for (IShape iShape2 : iList2) {
            IShape iShape3 = SpatialOperators.inter(null, iShape2, iShape);
            if (iShape3 == null || iShape3.getInnerGeometry().isEmpty()) continue;
            GamaShape gamaShape = GamaShapeFactory.createFrom(iShape3);
            GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(gamaShape);
            int n = 0;
            while (n < gamaPointArray.length) {
                GamaPoint gamaPoint = gamaPointArray[n];
                if (d3 != gamaPoint.getZ()) {
                    SpatialThreeD.set_z(null, gamaShape, n, d3);
                }
                ++n;
            }
            iList.add(gamaShape);
        }
        return iList;
    }

    public static IList<IShape> voronoi(IScope iScope, IList<GamaPoint> iList) {
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        VoronoiDiagramBuilder voronoiDiagramBuilder = new VoronoiDiagramBuilder();
        voronoiDiagramBuilder.setClipEnvelope((Envelope)iScope.getSimulation().getEnvelope());
        voronoiDiagramBuilder.setSites(iList);
        GeometryCollection geometryCollection = (GeometryCollection)voronoiDiagramBuilder.getDiagram((GeometryFactory)GEOMETRY_FACTORY);
        int n = geometryCollection.getNumGeometries();
        int n2 = 0;
        while (n2 < n) {
            Geometry geometry = geometryCollection.getGeometryN(n2);
            iList2.add(GamaShapeFactory.createFrom(geometry.intersection(iScope.getSimulation().getInnerGeometry())));
            ++n2;
        }
        return iList2;
    }

    public static IList<IShape> voronoi(IScope iScope, IList<GamaPoint> iList, IShape iShape) {
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        VoronoiDiagramBuilder voronoiDiagramBuilder = new VoronoiDiagramBuilder();
        voronoiDiagramBuilder.setClipEnvelope((Envelope)iShape.getEnvelope());
        voronoiDiagramBuilder.setSites(iList);
        GeometryCollection geometryCollection = (GeometryCollection)voronoiDiagramBuilder.getDiagram((GeometryFactory)GEOMETRY_FACTORY);
        int n = geometryCollection.getNumGeometries();
        int n2 = 0;
        while (n2 < n) {
            Geometry geometry = geometryCollection.getGeometryN(n2);
            iList2.add(GamaShapeFactory.createFrom(geometry));
            ++n2;
        }
        return iList2;
    }

    public static IList<IShape> triangulation(IScope iScope, IList<IShape> iList, double d) {
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        conformingDelaunayTriangulationBuilder.setTolerance(d);
        Geometry geometry = GamaGeometryType.geometriesToGeometry(iScope, iList).getInnerGeometry();
        conformingDelaunayTriangulationBuilder.setSites(geometry);
        conformingDelaunayTriangulationBuilder.setConstraints(geometry);
        GeometryCollection geometryCollection = (GeometryCollection)conformingDelaunayTriangulationBuilder.getTriangles((GeometryFactory)GEOMETRY_FACTORY);
        int n = geometryCollection.getNumGeometries();
        int n2 = 0;
        while (n2 < n) {
            Geometry geometry2 = geometryCollection.getGeometryN(n2);
            iList2.add(GamaShapeFactory.createFrom(geometry2));
            ++n2;
        }
        return iList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IList<IShape> triangulation(IScope iScope, Geometry geometry, double d, double d2, boolean bl) {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            if (!(geometry instanceof MultiLineString)) {
                int n = 0;
                while (n < geometryCollection.getNumGeometries()) {
                    iList.addAll(GeometryUtils.triangulation(iScope, geometryCollection.getGeometryN(n), d, d2, bl));
                    ++n;
                }
                return iList;
            }
        }
        boolean bl2 = !(geometry instanceof LineString) && !(geometry instanceof MultiLineString) && !(geometry instanceof MultiPoint) && !(geometry instanceof Point);
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        conformingDelaunayTriangulationBuilder.setTolerance(d);
        GeometryCollection geometryCollection = null;
        try {
            conformingDelaunayTriangulationBuilder.setSites(geometry);
            conformingDelaunayTriangulationBuilder.setConstraints(geometry);
            geometryCollection = (GeometryCollection)conformingDelaunayTriangulationBuilder.getTriangles((GeometryFactory)GEOMETRY_FACTORY);
        }
        catch (ConstraintEnforcementException | LocateFailureException throwable) {
            conformingDelaunayTriangulationBuilder.setTolerance(d + 0.1);
            conformingDelaunayTriangulationBuilder.setSites(geometry);
            conformingDelaunayTriangulationBuilder.setConstraints(geometry);
            geometryCollection = (GeometryCollection)conformingDelaunayTriangulationBuilder.getTriangles((GeometryFactory)GEOMETRY_FACTORY);
        }
        if (geometryCollection == null) return iList;
        iList.addAll(GeometryUtils.filterGeoms(geometryCollection, geometry, bl2, d2, bl));
        return iList;
    }

    private static IList<IShape> filterGeoms(GeometryCollection geometryCollection, Geometry geometry, boolean bl, double d, boolean bl2) {
        if (geometryCollection == null) {
            return null;
        }
        double d2 = GeometryUtils.getContourCoordinates(geometry).averageZ();
        boolean bl3 = d2 != 0.0;
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        Geometry geometry2 = d != 0.0 ? geometry.buffer(d, 5, 0) : geometry;
        PreparedGeometry preparedGeometry = PREPARED_GEOMETRY_FACTORY.create(geometry2);
        Envelope3D envelope3D = Envelope3D.of(preparedGeometry.getGeometry());
        try {
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                Geometry geometry3 = geometryCollection.getGeometryN(n);
                if (!bl || geometry.covers((Geometry)geometry3.getCentroid())) {
                    Coordinate[] coordinateArray = geometry3.getCoordinates();
                    boolean bl4 = envelope3D.covers(geometry3.getCentroid().getCoordinate());
                    boolean bl5 = bl4 && (!bl || (bl2 ? preparedGeometry.covers((Geometry)geometry3.getCentroid()) && preparedGeometry.covers((Geometry)GEOMETRY_FACTORY.createPoint(coordinateArray[0])) && preparedGeometry.covers((Geometry)GEOMETRY_FACTORY.createPoint(coordinateArray[1])) && preparedGeometry.covers((Geometry)GEOMETRY_FACTORY.createPoint(coordinateArray[2])) : geometry2.covers(geometry3))) ? true : (bl4 = false);
                    if (bl4) {
                        if (bl3) {
                            ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(geometry3);
                            iCoordinates.setAllZ(d2);
                            geometry3.geometryChanged();
                        }
                        iList.add(GamaShapeFactory.createFrom(geometry3));
                    }
                }
                ++n;
            }
        }
        finally {
            envelope3D.dispose();
        }
        return iList;
    }

    public static void iterateOverTriangles(Polygon polygon, Consumer<Geometry> consumer) {
        double d = GeometryUtils.getContourCoordinates(polygon).averageZ();
        double d2 = Math.sqrt(polygon.getArea()) / 100.0;
        DelaunayTriangulationBuilder delaunayTriangulationBuilder = new DelaunayTriangulationBuilder();
        PreparedGeometry preparedGeometry = PREPARED_GEOMETRY_FACTORY.create(polygon.buffer(d2, 5, 0));
        Envelope3D envelope3D = Envelope3D.of(preparedGeometry.getGeometry());
        try {
            try {
                delaunayTriangulationBuilder.setSites((Geometry)polygon);
                delaunayTriangulationBuilder.setTolerance(d2);
                GeometryUtils.applyToInnerGeometries(delaunayTriangulationBuilder.getTriangles((GeometryFactory)GEOMETRY_FACTORY), geometry -> {
                    ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(geometry);
                    if (iCoordinates.isCoveredBy(envelope3D) && preparedGeometry.covers(geometry)) {
                        iCoordinates.setAllZ(d);
                        geometry.geometryChanged();
                        consumer.accept(geometry);
                    }
                });
            }
            catch (ConstraintEnforcementException | LocateFailureException throwable) {
                IScope iScope = GAMA.getRuntimeScope();
                GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("Impossible to triangulate: " + new WKTWriter().write((Geometry)polygon), iScope), false);
                GeometryUtils.iterateOverTriangles((Polygon)DouglasPeuckerSimplifier.simplify((Geometry)polygon, (double)0.1), consumer);
                envelope3D.dispose();
                return;
            }
        }
        finally {
            envelope3D.dispose();
        }
    }

    public static List<LineString> squeletisation(IScope iScope, Geometry geometry, double d, double d2, boolean bl) {
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        IList<IShape> iList = GeometryUtils.triangulation(iScope, geometry, d, d2, bl);
        IGraph iGraph = Graphs.spatialLineIntersectionTriangle(iScope, iList);
        IList<IList> iList2 = Graphs.connectedComponentOf(iScope, iGraph);
        for (IList iList3 : iList2) {
            Object object2;
            if (iList3.size() > 2) {
                for (Object object2 : iList3) {
                    GamaShape gamaShape = (GamaShape)object2;
                    Coordinate[] coordinateArray = GeometryUtils.extractPoints((IShape)gamaShape, new LinkedHashSet<IShape>(Graphs.neighborsOf(iScope, iGraph, gamaShape)));
                    if (coordinateArray == null) continue;
                    arrayList.add(GEOMETRY_FACTORY.createLineString(coordinateArray));
                }
                continue;
            }
            if (iList3.size() != 2) continue;
            object2 = GeometryUtils.extractPoints((IShape)((GamaShape)iList3.get(0)), (GamaShape)iList3.get(1));
            arrayList.add(GEOMETRY_FACTORY.createLineString((Coordinate[])object2));
        }
        return arrayList;
    }

    public static Geometry buildGeometryJTS(List<List<List<GamaPoint>>> list) {
        IShape.Type type2 = GeometryUtils.geometryType(list);
        switch (type2) {
            case NULL: {
                return null;
            }
            case POINT: {
                return GeometryUtils.buildPoint(list.get(0));
            }
            case LINESTRING: {
                return GeometryUtils.buildLine(list.get(0));
            }
            case POLYGON: {
                return GeometryUtils.buildPolygon(list.get(0));
            }
            case MULTIPOINT: {
                int n = list.size();
                Point[] pointArray = new Point[n];
                int n2 = 0;
                while (n2 < n) {
                    pointArray[n2] = (Point)GeometryUtils.buildPoint(list.get(n2));
                    ++n2;
                }
                return GEOMETRY_FACTORY.createMultiPoint(pointArray);
            }
            case MULTILINESTRING: {
                int n = list.size();
                LineString[] lineStringArray = new LineString[n];
                int n3 = 0;
                while (n3 < n) {
                    lineStringArray[n3] = (LineString)GeometryUtils.buildLine(list.get(n3));
                    ++n3;
                }
                return GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
            }
            case MULTIPOLYGON: {
                int n = list.size();
                Polygon[] polygonArray = new Polygon[n];
                int n4 = 0;
                while (n4 < n) {
                    polygonArray[n4] = (Polygon)GeometryUtils.buildPolygon(list.get(n4));
                    ++n4;
                }
                return GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
            }
        }
        return null;
    }

    private static Geometry buildPoint(List<List<GamaPoint>> list) {
        return GEOMETRY_FACTORY.createPoint(list.get(0).get(0));
    }

    public static Geometry buildGeometryCollection(List<IShape> list) {
        int n = list.size();
        Geometry[] geometryArray = new Geometry[n];
        int n2 = 0;
        while (n2 < n) {
            geometryArray[n2] = list.get(n2).getInnerGeometry();
            ++n2;
        }
        return GEOMETRY_FACTORY.createGeometryCollection(geometryArray);
    }

    private static Geometry buildLine(List<List<GamaPoint>> list) {
        List<GamaPoint> list2 = list.get(0);
        int n = list2.size();
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        while (n2 < n) {
            coordinateArray[n2] = list2.get(n2);
            ++n2;
        }
        return GEOMETRY_FACTORY.createLineString(coordinateArray);
    }

    private static Geometry buildPolygon(List<List<GamaPoint>> list) {
        List<GamaPoint> list2 = list.get(0);
        int n = list2.size();
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        while (n2 < n) {
            coordinateArray[n2] = list2.get(n2);
            ++n2;
        }
        n2 = list.size() - 1;
        LinearRing[] linearRingArray = null;
        if (n2 > 0) {
            linearRingArray = new LinearRing[n2];
            int n3 = 0;
            while (n3 < n2) {
                List<GamaPoint> list3 = list.get(n3 + 1);
                int n4 = list3.size();
                Coordinate[] coordinateArray2 = new Coordinate[n4];
                int n5 = 0;
                while (n5 < n4) {
                    coordinateArray2[n5] = list3.get(n5);
                    ++n5;
                }
                linearRingArray[n3] = GEOMETRY_FACTORY.createLinearRing(coordinateArray2);
                ++n3;
            }
        }
        return GEOMETRY_FACTORY.createPolygon(GEOMETRY_FACTORY.createLinearRing(coordinateArray), linearRingArray);
    }

    private static IShape.Type geometryType(List<List<List<GamaPoint>>> list) {
        int n = list.size();
        if (n == 0) {
            return IShape.Type.NULL;
        }
        if (n == 1) {
            return GeometryUtils.geometryTypeSimp(list.get(0));
        }
        IShape.Type type2 = GeometryUtils.geometryTypeSimp(list.get(0));
        return switch (type2) {
            case IShape.Type.POINT -> IShape.Type.MULTIPOINT;
            case IShape.Type.LINESTRING -> IShape.Type.MULTILINESTRING;
            case IShape.Type.POLYGON -> IShape.Type.POLYGON;
            default -> IShape.Type.NULL;
        };
    }

    private static IShape.Type geometryTypeSimp(List<List<GamaPoint>> list) {
        if (list.isEmpty() || list.get(0).isEmpty()) {
            return IShape.Type.NULL;
        }
        List<GamaPoint> list2 = list.get(0);
        int n = list2.size();
        if (n == 1 || n == 2 && list2.get(0).equals(list2.get(list.size() - 1))) {
            return IShape.Type.POINT;
        }
        if (!list2.get(0).equals(list2.get(list.size() - 1)) || n < 3) {
            return IShape.Type.LINESTRING;
        }
        return IShape.Type.POLYGON;
    }

    public static IList<GamaPoint> locsOnGeometry(Geometry geometry, Double d) {
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        if (geometry instanceof Point) {
            iList.add(new GamaPoint(geometry.getCoordinate()));
        } else if (geometry instanceof LineString) {
            double d2 = 0.0;
            Coordinate[] coordinateArray = geometry.getCoordinates();
            if (coordinateArray.length > 0) {
                iList.add(new GamaPoint(coordinateArray[0]));
            }
            int n = coordinateArray.length;
            int n2 = 0;
            while (n2 < n - 1) {
                Coordinate coordinate = coordinateArray[n2];
                Coordinate coordinate2 = coordinateArray[n2 + 1];
                while (true) {
                    double d3 = coordinate.distance3D(coordinate2);
                    if (d - d2 >= d3) {
                        if (d - d2 > d3) {
                            d2 += d3;
                            break;
                        }
                        d2 = 0.0;
                        iList.add(new GamaPoint(coordinate2));
                        break;
                    }
                    double d4 = d - d2;
                    double d5 = d4 / d3;
                    double d6 = coordinate.x + d5 * (coordinate2.x - coordinate.x);
                    double d7 = coordinate.y + d5 * (coordinate2.y - coordinate.y);
                    double d8 = coordinate.z + d5 * (coordinate2.z - coordinate.z);
                    coordinate = new Coordinate(d6, d7, d8);
                    iList.add(new GamaPoint(coordinate));
                    d2 = 0.0;
                }
                ++n2;
            }
            if (iList.size() > 1 && ((GamaPoint)iList.get(0)).distance3D((Coordinate)iList.get(iList.size() - 1)) < 0.1 * d) {
                iList.remove(iList.size() - 1);
            }
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            iList.addAll(GeometryUtils.locsOnGeometry((Geometry)polygon.getExteriorRing(), d));
            int n = 0;
            while (n < polygon.getNumInteriorRing()) {
                iList.addAll(GeometryUtils.locsOnGeometry((Geometry)polygon.getInteriorRingN(n), d));
                ++n;
            }
        }
        return iList;
    }

    public static IList<GamaPoint> locsAlongGeometry(Geometry geometry, List<Double> list) {
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        if (list == null || list.isEmpty()) {
            return iList;
        }
        if (geometry instanceof Point) {
            int n = 0;
            while (n < list.size()) {
                iList.add(new GamaPoint(geometry.getCoordinate()));
                ++n;
            }
        } else if (geometry instanceof LineString) {
            block1: for (Double d : list) {
                Coordinate[] coordinateArray = geometry.getCoordinates();
                int n = coordinateArray.length;
                if (n <= 0) {
                    return iList;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d == 0.0) {
                    iList.add(new GamaPoint(coordinateArray[0]));
                    continue;
                }
                if (d == 1.0) {
                    iList.add(new GamaPoint(coordinateArray[n - 1]));
                    continue;
                }
                double d2 = 0.0;
                double d3 = d * geometry.getLength();
                int n2 = 0;
                while (n2 < n - 1) {
                    Coordinate coordinate = coordinateArray[n2];
                    Coordinate coordinate2 = coordinateArray[n2 + 1];
                    double d4 = coordinate.distance3D(coordinate2);
                    if (d3 - d2 < d4) {
                        double d5 = d3 - d2;
                        double d6 = d5 / d4;
                        double d7 = coordinate.x + d6 * (coordinate2.x - coordinate.x);
                        double d8 = coordinate.y + d6 * (coordinate2.y - coordinate.y);
                        double d9 = coordinate.z + d6 * (coordinate2.z - coordinate.z);
                        coordinate = new Coordinate(d7, d8, d9);
                        iList.add(new GamaPoint(coordinate));
                        continue block1;
                    }
                    if (d3 - d2 <= d4) {
                        iList.add(new GamaPoint(coordinate2));
                        continue block1;
                    }
                    d2 += d4;
                    ++n2;
                }
            }
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            iList.addAll(GeometryUtils.locsAlongGeometry((Geometry)polygon.getExteriorRing(), list));
        }
        return iList;
    }

    public static Envelope3D computeEnvelopeFrom(IScope iScope, Object object) {
        Envelope3D envelope3D = null;
        if (object instanceof IEnvelopeProvider) {
            IEnvelopeProvider iEnvelopeProvider = (IEnvelopeProvider)object;
            return iEnvelopeProvider.computeEnvelope(iScope);
        }
        if (object instanceof ISpecies) {
            return GeometryUtils.computeEnvelopeFrom(iScope, ((ISpecies)object).getPopulation(iScope));
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            envelope3D = Envelope3D.of(0.0, d, 0.0, d, 0.0, d);
        } else if (object instanceof GamaPoint) {
            GamaPoint gamaPoint = (GamaPoint)object;
            envelope3D = Envelope3D.of(0.0, gamaPoint.getX(), 0.0, gamaPoint.getY(), 0.0, gamaPoint.getZ());
        } else if (object instanceof Envelope) {
            envelope3D = Envelope3D.of((Envelope)object);
        } else if (object instanceof String) {
            envelope3D = GeometryUtils.computeEnvelopeFrom(iScope, Files.from(iScope, (String)object));
        } else if (object instanceof IList) {
            for (Object e : (IList)object) {
                Envelope3D envelope3D2 = GeometryUtils.computeEnvelopeFrom(iScope, e);
                if (envelope3D == null) {
                    envelope3D = Envelope3D.of(envelope3D2);
                    continue;
                }
                envelope3D.expandToInclude(envelope3D2);
            }
        } else {
            for (IEnvelopeComputer iEnvelopeComputer : envelopeComputers) {
                envelope3D = iEnvelopeComputer.computeEnvelopeFrom(iScope, object);
                if (envelope3D == null) continue;
                return envelope3D;
            }
        }
        return envelope3D;
    }

    private static IList<IShape> split_at(Geometry geometry, GamaPoint gamaPoint) {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (geometry instanceof LineString) {
            GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(geometry);
            int n = -1;
            double d = Double.MAX_VALUE;
            int n2 = 0;
            while (n2 < gamaPointArray.length - 1) {
                double d2 = Distance.pointToSegment((Coordinate)gamaPoint, (Coordinate)gamaPointArray[n2], (Coordinate)gamaPointArray[n2 + 1]);
                if (d2 < d) {
                    d = d2;
                    n = n2;
                }
                ++n2;
            }
            GamaPoint[] gamaPointArray2 = new GamaPoint[n + 2];
            int n3 = 0;
            while (n3 <= n) {
                gamaPointArray2[n3] = gamaPointArray[n3];
                ++n3;
            }
            gamaPointArray2[n + 1] = gamaPoint;
            iList.add(GamaShapeFactory.createFrom((Geometry)GEOMETRY_FACTORY.createLineString(gamaPointArray2, false)));
            GamaPoint[] gamaPointArray3 = new GamaPoint[gamaPointArray.length - n];
            gamaPointArray3[0] = gamaPoint;
            int n4 = n + 1;
            int n5 = 1;
            while (n4 < gamaPointArray.length) {
                gamaPointArray3[n5] = gamaPointArray[n4];
                ++n4;
                ++n5;
            }
            iList.add(GamaShapeFactory.createFrom((Geometry)GEOMETRY_FACTORY.createLineString(gamaPointArray3, false)));
        } else if (geometry instanceof MultiLineString) {
            Point point = GEOMETRY_FACTORY.createPoint(gamaPoint);
            LineString lineString = null;
            double d = Double.MAX_VALUE;
            MultiLineString multiLineString = (MultiLineString)geometry;
            int n = 0;
            while (n < multiLineString.getNumGeometries()) {
                double d3 = multiLineString.getGeometryN(n).distance((Geometry)point);
                if (d3 <= d) {
                    lineString = (LineString)multiLineString.getGeometryN(n);
                    d = d3;
                }
                ++n;
            }
            return GeometryUtils.split_at(lineString, gamaPoint);
        }
        return iList;
    }

    public static IList<IShape> split_at(IShape iShape, GamaPoint gamaPoint) {
        return GeometryUtils.split_at(iShape.getInnerGeometry(), gamaPoint);
    }

    public static IShape.Type getTypeOf(Geometry geometry) {
        if (geometry == null) {
            return IShape.Type.NULL;
        }
        return IShape.JTS_TYPES.get(geometry.getGeometryType());
    }

    public static String getGeometryStringType(List<? extends IShape> list) {
        String string = "";
        boolean bl = false;
        for (IShape iShape : list) {
            Geometry geometry;
            IShape iShape2 = iShape.getGeometry();
            if (iShape2 == null || (geometry = GeometryUtils.cleanAndSimplifyGeometryCollection(iShape2.getInnerGeometry())) == null) continue;
            if (geometry.getNumGeometries() > 1) {
                if (!bl && geometry.getGeometryN(0).getClass() == Point.class) {
                    string = Point.class.getSimpleName();
                    continue;
                }
                if (geometry.getGeometryN(0).getClass() == LineString.class) {
                    string = LineString.class.getSimpleName();
                    continue;
                }
                if (geometry.getGeometryN(0).getClass() != Polygon.class) continue;
                return Polygon.class.getSimpleName();
            }
            String string2 = geometry.getClass().getSimpleName();
            if (iShape2.getInnerGeometry() instanceof Polygon) {
                return string2;
            }
            if (bl) continue;
            if (geometry instanceof LineString) {
                bl = true;
            }
            string = string2;
        }
        if ("DynamicLineString".equals(string)) {
            string = LineString.class.getSimpleName();
        }
        return string;
    }

    public static String getGeometryStringType(IShape iShape) {
        Geometry geometry;
        String string = "";
        boolean bl = false;
        IShape iShape2 = iShape.getGeometry();
        if (iShape2 != null && (geometry = GeometryUtils.cleanAndSimplifyGeometryCollection(iShape2.getInnerGeometry())) != null) {
            if (geometry.getNumGeometries() > 1) {
                if (!bl && geometry.getGeometryN(0).getClass() == Point.class) {
                    string = Point.class.getSimpleName();
                } else if (geometry.getGeometryN(0).getClass() == LineString.class) {
                    string = LineString.class.getSimpleName();
                } else if (geometry.getGeometryN(0).getClass() == Polygon.class) {
                    return Polygon.class.getSimpleName();
                }
            } else {
                String string2 = geometry.getClass().getSimpleName();
                if (iShape2.getInnerGeometry() instanceof Polygon) {
                    return string2;
                }
                if (!bl) {
                    if (geometry instanceof LineString) {
                        bl = true;
                    }
                    string = string2;
                }
            }
        }
        if ("DynamicLineString".equals(string)) {
            string = LineString.class.getSimpleName();
        }
        return string;
    }

    public static IShape smooth(Geometry geometry, double d) {
        return GamaShapeFactory.createFrom(JTS.smooth((Geometry)geometry, (double)d, (GeometryFactory)GEOMETRY_FACTORY));
    }

    public static ICoordinates getContourCoordinates(Polygon polygon) {
        if (polygon.isEmpty()) {
            return ICoordinates.EMPTY;
        }
        if (polygon.getExteriorRing().getCoordinateSequence() instanceof CoordinateArraySequence) {
            return GEOMETRY_FACTORY.getCoordinateSequenceFactory().create(polygon.getExteriorRing().getCoordinates());
        }
        return (ICoordinates)polygon.getExteriorRing().getCoordinateSequence();
    }

    public static ICoordinates getContourCoordinates(LineString lineString) {
        if (lineString.isEmpty()) {
            return ICoordinates.EMPTY;
        }
        return (ICoordinates)lineString.getCoordinateSequence();
    }

    public static ICoordinates getContourCoordinates(Point point) {
        if (point.isEmpty()) {
            return ICoordinates.EMPTY;
        }
        return (ICoordinates)point.getCoordinateSequence();
    }

    public static ICoordinates getContourCoordinates(Geometry geometry) {
        if (geometry instanceof Polygon) {
            return GeometryUtils.getContourCoordinates((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return GeometryUtils.getContourCoordinates((LineString)geometry);
        }
        if (geometry instanceof Point) {
            return GeometryUtils.getContourCoordinates((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return GeometryUtils.getContourCoordinates(geometry.convexHull());
        }
        return ICoordinates.EMPTY;
    }

    public static GamaPoint[] getPointsOf(IShape iShape) {
        Geometry geometry = iShape.getInnerGeometry();
        return GeometryUtils.getContourCoordinates(geometry).toCoordinateArray();
    }

    public static GamaPoint[] getPointsOf(Geometry geometry) {
        return GeometryUtils.getContourCoordinates(geometry).toCoordinateArray();
    }

    public static GamaPoint getFirstPointOf(IShape iShape) {
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry.isEmpty()) {
            return null;
        }
        return (GamaPoint)geometry.getCoordinates()[0];
    }

    public static GamaPoint getLastPointOf(IShape iShape) {
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry.isEmpty()) {
            return null;
        }
        Coordinate[] coordinateArray = geometry.getCoordinates();
        return (GamaPoint)coordinateArray[coordinateArray.length - 1];
    }

    public static void applyToInnerGeometries(Geometry geometry, GeometryFilter geometryFilter) {
        if (geometry instanceof Polygon) {
            GeometryUtils.applyToInnerGeometries((Polygon)geometry, geometryFilter);
        } else if (geometry instanceof GeometryCollection) {
            GeometryUtils.applyToInnerGeometries((GeometryCollection)geometry, geometryFilter);
        }
    }

    public static void applyToInnerGeometries(Polygon polygon, GeometryFilter geometryFilter) {
        int n = polygon.getNumInteriorRing();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            polygon.getInteriorRingN(n2).apply(geometryFilter);
            ++n2;
        }
    }

    public static void applyToInnerGeometries(GeometryCollection geometryCollection, GeometryFilter geometryFilter) {
        int n = geometryCollection.getNumGeometries();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Geometry geometry = geometryCollection.getGeometryN(n2);
            geometry.apply(geometryFilter);
            ++n2;
        }
    }

    public static void translate(Geometry geometry, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        double d = gamaPoint2.x - gamaPoint.x;
        double d2 = gamaPoint2.y - gamaPoint.y;
        double d3 = gamaPoint2.z - gamaPoint.z;
        GeometryUtils.translate(geometry, d, d2, d3);
    }

    public static void translate(Geometry geometry, double d, double d2, double d3) {
        geometry.apply(coordinate -> {
            coordinate.x += d;
            coordinate.y += d2;
            coordinate.z += d3;
        });
        geometry.geometryChanged();
    }

    public static void rotate(Geometry geometry, GamaPoint gamaPoint, AxisAngle axisAngle) {
        if (axisAngle == null) {
            return;
        }
        Rotation3D.CenteredOn centeredOn = new Rotation3D.CenteredOn(axisAngle, gamaPoint);
        geometry.apply((CoordinateFilter)centeredOn);
        geometry.geometryChanged();
    }

    public static ICoordinates getYNegatedCoordinates(Geometry geometry) {
        return GeometryUtils.getContourCoordinates(geometry).yNegated();
    }

    public static int getHolesNumber(Geometry geometry) {
        return geometry instanceof Polygon ? ((Polygon)geometry).getNumInteriorRing() : 0;
    }

    public static Geometry geometryCollectionManagement(Geometry geometry) {
        int n;
        GeometryCollection geometryCollection;
        block15: {
            block14: {
                if (!(geometry instanceof GeometryCollection)) break block14;
                geometryCollection = (GeometryCollection)geometry;
                if (!(geometry instanceof MultiPoint) && !(geometry instanceof MultiLineString) && !(geometry instanceof MultiPolygon)) break block15;
            }
            return geometry;
        }
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        while (n3 < geometryCollection.getNumGeometries()) {
            Geometry geometry2 = geometryCollection.getGeometryN(n3);
            int n4 = geometry2 instanceof Point ? 0 : (n = geometry2 instanceof LineString ? 1 : 2);
            if (n2 != -1 && n2 != n) {
                bl = true;
            }
            n2 = Math.max(n2, n);
            ++n3;
        }
        if (!bl) {
            return geometryCollection;
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n5 = 0;
        while (n5 < geometryCollection.getNumGeometries()) {
            Geometry geometry3 = geometryCollection.getGeometryN(n5);
            if (geometry3.getDimension() == n2) {
                arrayList.add(geometry3);
            }
            ++n5;
        }
        if (arrayList.size() == 1) {
            return (Geometry)arrayList.get(0);
        }
        if (n2 == 0) {
            Point[] pointArray = new Point[arrayList.size()];
            n = 0;
            while (n < pointArray.length) {
                pointArray[n] = (Point)arrayList.get(n);
                ++n;
            }
            return GEOMETRY_FACTORY.createMultiPoint(pointArray);
        }
        if (n2 == 1) {
            LineString[] lineStringArray = new LineString[arrayList.size()];
            n = 0;
            while (n < lineStringArray.length) {
                lineStringArray[n] = (LineString)arrayList.get(n);
                ++n;
            }
            return GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
        }
        Polygon[] polygonArray = new Polygon[arrayList.size()];
        n = 0;
        while (n < polygonArray.length) {
            polygonArray[n] = (Polygon)arrayList.get(n);
            ++n;
        }
        return GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
    }

    public static Geometry cleanGeometryCollection(Geometry geometry) {
        GeometryCollection geometryCollection;
        GeometryCollection geometryCollection2 = geometryCollection = geometry instanceof GeometryCollection ? (GeometryCollection)geometry : null;
        if (geometryCollection == null) {
            return geometry;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = geometryCollection.getNumGeometries();
        int n2 = 0;
        while (n2 < n) {
            Geometry geometry2 = geometryCollection.getGeometryN(n2);
            if (!(geometry2 instanceof Polygon)) {
                bl = false;
            }
            if (!(geometry2 instanceof LineString)) {
                bl3 = false;
            }
            if (!(geometry2 instanceof Point)) {
                bl2 = false;
            }
            ++n2;
        }
        if (bl) {
            Polygon[] polygonArray = new Polygon[n];
            int n3 = 0;
            while (n3 < n) {
                polygonArray[n3] = (Polygon)geometryCollection.getGeometryN(n3);
                ++n3;
            }
            return GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
        }
        if (bl3) {
            LineString[] lineStringArray = new LineString[n];
            int n4 = 0;
            while (n4 < n) {
                lineStringArray[n4] = (LineString)geometryCollection.getGeometryN(n4);
                ++n4;
            }
            return GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
        }
        if (bl2) {
            Point[] pointArray = new Point[n];
            int n5 = 0;
            while (n5 < n) {
                pointArray[n5] = (Point)geometryCollection.getGeometryN(n5);
                ++n5;
            }
            return GEOMETRY_FACTORY.createMultiPoint(pointArray);
        }
        return geometry;
    }

    public static Geometry cleanAndSimplifyGeometryCollection(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = geometryCollection.getNumGeometries();
            ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
            ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
            ArrayList<Point> arrayList3 = new ArrayList<Point>();
            int n2 = 0;
            while (n2 < n) {
                Geometry geometry2 = geometryCollection.getGeometryN(n2);
                if (geometry2 instanceof Polygon) {
                    Polygon polygon = (Polygon)geometry2;
                    arrayList.add(polygon);
                } else if (geometry2 instanceof LineString) {
                    LineString lineString = (LineString)geometry2;
                    arrayList2.add(lineString);
                } else if (geometry2 instanceof Point) {
                    Point point = (Point)geometry2;
                    arrayList3.add(point);
                }
                ++n2;
            }
            n2 = arrayList.size();
            if (n2 > 0) {
                if (n2 == 1) {
                    return (Geometry)arrayList.get(0);
                }
                return GEOMETRY_FACTORY.createMultiPolygon(arrayList.toArray(new Polygon[arrayList.size()]));
            }
            n2 = arrayList2.size();
            if (n2 > 0) {
                if (n2 == 1) {
                    return (Geometry)arrayList2.get(0);
                }
                return GEOMETRY_FACTORY.createMultiLineString(arrayList2.toArray(new LineString[arrayList2.size()]));
            }
            n2 = arrayList3.size();
            if (n2 > 0) {
                if (n2 == 1) {
                    return (Geometry)arrayList3.get(0);
                }
                return GEOMETRY_FACTORY.createMultiPoint(arrayList3.toArray(new Point[arrayList3.size()]));
            }
        }
        return geometry;
    }

    public static Geometry fixesPolygonCWS(Geometry geometry) {
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            boolean bl = Orientation.isCCW((Coordinate[])polygon.getExteriorRing().getCoordinates());
            if (polygon.getNumInteriorRing() == 0) {
                return geometry;
            }
            boolean bl2 = false;
            LinearRing[] linearRingArray = new LinearRing[polygon.getNumInteriorRing()];
            GeometryFactory geometryFactory = new GeometryFactory();
            int n = 0;
            while (n < polygon.getNumInteriorRing()) {
                LinearRing linearRing = polygon.getInteriorRingN(n);
                if (!bl && !Orientation.isCCW((Coordinate[])linearRing.getCoordinates()) || bl && Orientation.isCCW((Coordinate[])linearRing.getCoordinates())) {
                    bl2 = true;
                    Object[] objectArray = linearRing.getCoordinates();
                    ArrayUtils.reverse((Object[])objectArray);
                    CoordinateSequence coordinateSequence = CoordinateArraySequenceFactory.instance().create((Coordinate[])objectArray);
                    linearRingArray[n] = new LinearRing(coordinateSequence, geometryFactory);
                } else {
                    linearRingArray[n] = linearRing;
                }
                ++n;
            }
            if (bl2) {
                return geometryFactory.createPolygon(polygon.getExteriorRing(), linearRingArray);
            }
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            boolean bl = false;
            GeometryFactory geometryFactory = new GeometryFactory();
            Geometry[] geometryArray = new Geometry[geometryCollection.getNumGeometries()];
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                Geometry geometry2 = geometryCollection.getGeometryN(n);
                if (geometry2 instanceof Polygon) {
                    geometryArray[n] = GeometryUtils.fixesPolygonCWS(geometry2);
                    bl = true;
                } else {
                    geometryArray[n] = geometry2;
                }
                ++n;
            }
            if (bl) {
                return geometryFactory.createGeometryCollection(geometryArray);
            }
        }
        return geometry;
    }

    public static Geometry cleanGeometry(Geometry geometry) {
        if (geometry == null || geometry.isEmpty()) {
            return geometry;
        }
        Geometry geometry2 = geometry.buffer(0.0, 8, 2);
        if (geometry2.isEmpty()) {
            if (!(geometry instanceof Polygon)) {
                return GEOMETRY_FACTORY.createGeometry(geometry);
            }
            Polygon polygon = (Polygon)geometry;
            Polygon polygon2 = GEOMETRY_FACTORY.createPolygon(polygon.getExteriorRing().getCoordinates());
            int n = 0;
            while (n < polygon.getNumInteriorRing()) {
                Polygon polygon3 = GEOMETRY_FACTORY.createPolygon(polygon.getInteriorRingN(n).getCoordinates());
                polygon2 = polygon2.difference((Geometry)polygon3);
                ++n;
            }
            return polygon2;
        }
        return geometry2;
    }

    public static boolean robustTouches(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        Geometry geometry = iShape.getInnerGeometry();
        Geometry geometry2 = iShape2.getInnerGeometry();
        if (geometry == null || geometry2 == null) {
            return false;
        }
        try {
            return geometry.touches(geometry2);
        }
        catch (TopologyException topologyException) {
            try {
                return geometry.buffer(0.0).touches(geometry2.buffer(0.0));
            }
            catch (TopologyException topologyException2) {
                return false;
            }
        }
        catch (AssertionFailedException assertionFailedException) {
            try {
                return geometry.buffer(0.0).touches(geometry2.buffer(0.0));
            }
            catch (AssertionFailedException assertionFailedException2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean robustPartiallyOverlaps(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        Geometry geometry = iShape.getInnerGeometry();
        Geometry geometry2 = iShape2.getInnerGeometry();
        if (geometry == null || geometry2 == null) {
            return false;
        }
        try {
            return geometry.overlaps(geometry2);
        }
        catch (TopologyException topologyException) {
            try {
                return geometry.buffer(0.0).overlaps(geometry2.buffer(0.0));
            }
            catch (TopologyException topologyException2) {
                return false;
            }
        }
        catch (AssertionFailedException assertionFailedException) {
            try {
                return geometry.buffer(0.0).overlaps(geometry2.buffer(0.0));
            }
            catch (AssertionFailedException assertionFailedException2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean robustCrosses(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return false;
        }
        if (iShape2.isPoint()) {
            return POINT_LOCATOR.intersects((Coordinate)iShape2.getLocation(), geometry);
        }
        Geometry geometry2 = iShape2.getInnerGeometry();
        if (geometry2 == null) {
            return false;
        }
        try {
            return geometry.crosses(geometry2);
        }
        catch (TopologyException topologyException) {
            try {
                return geometry.buffer(0.0).crosses(geometry2.buffer(0.0));
            }
            catch (TopologyException topologyException2) {
                return false;
            }
        }
        catch (AssertionFailedException assertionFailedException) {
            try {
                return geometry.buffer(0.0).crosses(geometry2.buffer(0.0));
            }
            catch (AssertionFailedException assertionFailedException2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean robustIntersects(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return false;
        }
        if (iShape2.isPoint()) {
            return POINT_LOCATOR.intersects((Coordinate)iShape2.getLocation(), geometry);
        }
        Geometry geometry2 = iShape2.getInnerGeometry();
        if (geometry2 == null) {
            return false;
        }
        try {
            return geometry.intersects(geometry2);
        }
        catch (TopologyException topologyException) {
            try {
                return geometry.buffer(0.0).intersects(geometry2.buffer(0.0));
            }
            catch (TopologyException topologyException2) {
                return false;
            }
        }
        catch (AssertionFailedException assertionFailedException) {
            try {
                return geometry.buffer(0.0).intersects(geometry2.buffer(0.0));
            }
            catch (AssertionFailedException assertionFailedException2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean robustCovers(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        Geometry geometry = iShape.getInnerGeometry();
        if (geometry == null) {
            return false;
        }
        if (iShape2.isPoint()) {
            return POINT_LOCATOR.intersects((Coordinate)iShape2.getLocation(), geometry);
        }
        Geometry geometry2 = iShape2.getInnerGeometry();
        if (geometry2 == null) {
            return false;
        }
        try {
            return geometry.covers(geometry2);
        }
        catch (TopologyException topologyException) {
            try {
                return geometry.buffer(0.0).covers(geometry2.buffer(0.0));
            }
            catch (TopologyException topologyException2) {
                return false;
            }
        }
        catch (AssertionFailedException assertionFailedException) {
            try {
                return geometry.buffer(0.0).covers(geometry2.buffer(0.0));
            }
            catch (AssertionFailedException assertionFailedException2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }
}

