/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.Transformation3D;
import gama.core.metamodel.shape.GamaPoint;
import org.locationtech.jts.geom.Coordinate;

public abstract class Scaling3D
implements Transformation3D {
    public static final Scaling3D IDENTITY = new Uniform(1.0);

    public static Scaling3D of(double d, double d2, double d3) {
        if (d == d2 && d2 == d3) {
            return Scaling3D.of(d);
        }
        return new Heterogeneous(d, d2, d3);
    }

    public static Scaling3D of(GamaPoint gamaPoint) {
        if (gamaPoint == null) {
            return null;
        }
        return Scaling3D.of(gamaPoint.x, gamaPoint.y, gamaPoint.z);
    }

    public static Scaling3D of(double d) {
        if (d == 1.0) {
            return IDENTITY;
        }
        return new Uniform(d);
    }

    public abstract Scaling3D asBoundingBoxIn(Envelope3D var1);

    public abstract double getZ();

    public abstract double getY();

    public abstract double getX();

    public abstract Scaling3D dividedBy(double var1);

    public GamaPoint toGamaPoint() {
        return new GamaPoint(this.getX(), this.getY(), this.getZ());
    }

    public static class Heterogeneous
    extends Scaling3D {
        public double x;
        public double y;
        public double z;

        public Heterogeneous(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public Scaling3D setTo(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
            return this;
        }

        public Scaling3D setTo(double d) {
            this.y = this.z = d;
            this.x = this.z;
            return this;
        }

        public void filter(Coordinate coordinate) {
            coordinate.x *= this.x;
            coordinate.y *= this.y;
            coordinate.z *= this.z;
        }

        @Override
        public Scaling3D asBoundingBoxIn(Envelope3D envelope3D) {
            this.x /= envelope3D.getWidth();
            this.y /= envelope3D.getHeight();
            this.z = !envelope3D.isFlat() ? (this.z /= envelope3D.getDepth()) : 1.0;
            return this;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public Scaling3D dividedBy(double d) {
            return Scaling3D.of(this.x / d, this.y / d, this.z / d);
        }
    }

    public static class Uniform
    extends Scaling3D {
        final double factor;

        public Uniform(double d) {
            this.factor = d;
        }

        public void filter(Coordinate coordinate) {
            ((GamaPoint)coordinate).multiplyBy(this.factor);
        }

        @Override
        public Scaling3D asBoundingBoxIn(Envelope3D envelope3D) {
            return Uniform.of(this.factor / envelope3D.getWidth(), this.factor / envelope3D.getHeight(), envelope3D.isFlat() ? 1.0 : this.factor / envelope3D.getDepth());
        }

        @Override
        public double getZ() {
            return this.factor;
        }

        @Override
        public double getY() {
            return this.factor;
        }

        @Override
        public double getX() {
            return this.factor;
        }

        @Override
        public Scaling3D dividedBy(double d) {
            return Scaling3D.of(this.factor / d);
        }
    }
}

