/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.betadistribution;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.batch.exploration.betadistribution.Betadistribution;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.FileNameUtils;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="sampling", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="The sampling method to build parameters sets that must be factorial based to some extends - available are: latinhypercube, orthogonal, factorial, uniform, saltelli, morris")}), @GamlAnnotations.facet(name="outputs", type={5}, of=4, optional=false, doc={@GamlAnnotations.doc(value="The list of output variables to analyse")}), @GamlAnnotations.facet(name="sample", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of sample required.")}), @GamlAnnotations.facet(name="bootstrap", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of time each parameter value is boostraped (or resampled in another context)")}), @GamlAnnotations.facet(name="results", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the file where the automatic batch report will be written")}), @GamlAnnotations.facet(name="report", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The path to the file where the Betad report will be written")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm runs an exploration with a given sampling to compute BetadKu - see doi: 10.1007/s10588-021-09358-5", usages={@GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method sobol sample_size:100 outputs:['my_var'] report:'../path/to/report/file.txt'; ", isExecutable=false)})})
public class BetaExploration
extends AExplorationAlgorithm {
    private int bootstrap = 4;
    public static final String BOOTSTRAP = "bootstrap";
    private List<IParameter.Batch> parameters;
    private IList<String> outputs;
    protected IMap<ParametersSet, Map<String, List<Object>>> res_outputs;

    public BetaExploration(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void explore(IScope iScope) {
        Object object4;
        Object object2;
        String string;
        List<IParameter.Batch> list = this.parameters = this.parameters == null ? this.getParams(this.currentExperiment) : this.parameters;
        if (this.hasFacet("sample")) {
            this.sample_size = Cast.asInt(iScope, this.getFacet("sample").value(iScope));
        }
        if (this.sample_size < 1) {
            this.sample_size = 2;
        }
        List<ParametersSet> list2 = this.getExperimentPlan(this.parameters, iScope);
        list2 = this.expendExperimentPlan(list2, iScope);
        this.currentExperiment.setKeepSimulations(false);
        this.res_outputs = this.currentExperiment.runSimulationsAndReturnResults(list2);
        this.outputs = Cast.asList(iScope, this.getFacet("outputs").value(iScope));
        HashMap<String, Map<IParameter.Batch, Double>> hashMap = new HashMap<String, Map<IParameter.Batch, Double>>();
        Object object3 = this.outputs.iterator();
        while (object3.hasNext()) {
            string = (String)object3.next();
            object2 = GamaMapFactory.create();
            for (Object object4 : this.res_outputs.keySet()) {
                object2.put(object4, (List)((Map)this.res_outputs.get(object4)).get(string));
            }
            object4 = new Betadistribution((IMap<ParametersSet, List<Object>>)object2, this.parameters);
            hashMap.put(string, ((Betadistribution)object4).evaluate());
        }
        if (this.hasFacet("results")) {
            this.saveRawResults(iScope, this.res_outputs);
        }
        if (!((File)(object2 = ((File)(object3 = new File(FileUtils.constructAbsoluteFilePath(iScope, string = Cast.asString(iScope, this.getFacet("report").value(iScope)), false)))).getParentFile())).exists()) {
            ((File)object2).mkdirs();
        }
        if (((File)object3).exists()) {
            ((File)object3).delete();
        }
        try {
            object4 = null;
            Iterator iterator = null;
            try (FileWriter fileWriter = new FileWriter((File)object3, false);){
                fileWriter.write(this.buildReportString(hashMap, FileNameUtils.getExtension((String)((File)object3).getPath())));
            }
            catch (Throwable throwable) {
                if (object4 == null) {
                    object4 = throwable;
                } else if (object4 != throwable) {
                    ((Throwable)object4).addSuppressed(throwable);
                }
                throw object4;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("File " + ((File)object3).toString() + " not found", iScope);
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, final BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Sampled points", "betad", 4){

            @Override
            public Object value() {
                if (BetaExploration.this.hasFacet(BetaExploration.BOOTSTRAP)) {
                    return Cast.asInt(batchAgent.getScope(), BetaExploration.this.getFacet("sample").value(batchAgent.getScope())) + Cast.asInt(batchAgent.getScope(), BetaExploration.this.getFacet("sample").value(batchAgent.getScope())) * Cast.asInt(batchAgent.getScope(), BetaExploration.this.getFacet(BetaExploration.BOOTSTRAP).value(batchAgent.getScope())) * BetaExploration.this.getParams(batchAgent).size();
                }
                if (BetaExploration.this.hasFacet("sample")) {
                    return Cast.asInt(batchAgent.getScope(), BetaExploration.this.getFacet("sample").value(batchAgent.getScope()));
                }
                return BetaExploration.this.sample_size;
            }
        });
        list.add(new ParameterAdapter("Sampling method", "betad", 4){

            @Override
            public Object value() {
                return BetaExploration.this.hasFacet("sampling") ? Cast.asString(batchAgent.getScope(), BetaExploration.this.getFacet("sampling").value(batchAgent.getScope())) : "Exhaustive";
            }
        });
    }

    private List<IParameter.Batch> getParams(BatchAgent batchAgent) {
        return batchAgent.getParametersToExplore().stream().filter(batch -> batch.getMinValue(batchAgent.getScope()) != null && batch.getMaxValue(batchAgent.getScope()) != null).map(batch -> batch).toList();
    }

    private List<ParametersSet> expendExperimentPlan(List<ParametersSet> list, IScope iScope) {
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>(list);
        if (this.hasFacet(BOOTSTRAP)) {
            this.bootstrap = Cast.asInt(iScope, this.getFacet(BOOTSTRAP).value(iScope));
        }
        for (IParameter.Batch batch : this.parameters) {
            for (ParametersSet parametersSet : list) {
                ArrayList<ParametersSet> arrayList2 = new ArrayList<ParametersSet>(list);
                arrayList2.remove(parametersSet);
                int n = 0;
                while (n < this.bootstrap) {
                    ParametersSet parametersSet2 = new ParametersSet((ParametersSet)arrayList2.remove((int)iScope.getRandom().next() * arrayList2.size()));
                    parametersSet2.addValueAtIndex(iScope, (Object)batch, parametersSet.get(batch.getName()));
                    arrayList.add(parametersSet2);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public String buildReportString(Map<String, Map<IParameter.Batch, Double>> map, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if ("txt".equalsIgnoreCase(string)) {
            stringBuilder.append("BETA b Kuiper based estimator :").append(Strings.LN);
            stringBuilder.append("##############################").append(Strings.LN);
            stringBuilder.append("inputs," + String.join((CharSequence)",", this.outputs)).append(Strings.LN);
            for (IParameter.Batch batch : this.parameters) {
                stringBuilder.append(batch.getName());
                for (String string2 : this.outputs) {
                    stringBuilder.append(",").append(map.get(string2).get(batch));
                }
                stringBuilder.append(Strings.LN);
            }
        } else {
            stringBuilder.append("output").append(",");
            stringBuilder.append("parameter").append(",");
            stringBuilder.append("\u03b2").append(Strings.LN);
            for (String string3 : this.outputs) {
                for (IParameter.Batch batch : this.parameters) {
                    stringBuilder.append(string3).append(",");
                    stringBuilder.append(batch.getName()).append(",");
                    stringBuilder.append(map.get(string3).get(batch)).append(Strings.LN);
                }
            }
        }
        return stringBuilder.toString();
    }
}

