/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.interfaces.IDisplayCreator;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.IGui;
import gama.core.common.interfaces.IOverlayProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.AbstractOutput;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.OverlayStatement;
import gama.core.outputs.layers.properties.CameraStatement;
import gama.core.outputs.layers.properties.LightStatement;
import gama.core.outputs.layers.properties.RotationStatement;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.statements.Facets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="virtual", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Declaring a display as virtual makes it invisible on screen, and only usable for display inheritance")}), @GamlAnnotations.facet(name="parent", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="Declares that this display inherits its layers and attributes from the parent display named as the argument. Expects the identifier of the parent display or a string if the name of the parent contains spaces")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Allows to fill the background of the display and its toolbar with a specific color. Beware that this color, used in the UI, will not be affected by the light used in the display.")}), @GamlAnnotations.facet(name="name", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the display")}), @GamlAnnotations.facet(name="type", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="Allows to use either Java2D (for planar models) or OpenGL (for 3D models) as the rendering subsystem")}), @GamlAnnotations.facet(name="antialias", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether to use advanced antialiasing for the display or not. The default value is the one indicated in the preferences of GAMA ('false' is its factory default). Antialising produces smoother outputs, but comes with a cost in terms of speed and memory used. ")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the condition under which this output should be refreshed (default is true)")}), @GamlAnnotations.facet(name="toolbar", type={3, 6}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether the top toolbar of the display view should be initially visible or not. If a color is passed, then the background of the toolbar takes this color")}), @GamlAnnotations.facet(name="fullscreen", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="Indicates, when using a boolean value, whether or not the display should cover the whole screen (default is false). If an integer is passed, specifies also the screen to use: 0 for the primary monitor, 1 for the secondary one, and so on and so forth. If the monitor is not available, the first one is used")}), @GamlAnnotations.facet(name="show_fps", internal=true, type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to enable/disable the drawing of the number of frames per second")}), @GamlAnnotations.facet(name="axes", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to enable/disable the drawing of the world shape and the ordinate axes. Default can be configured in Preferences")}), @GamlAnnotations.facet(name="orthographic_projection", internal=true, type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to enable/disable the orthographic projection. Default can be configured in Preferences")}), @GamlAnnotations.facet(name="light", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to enable/disable the light at once. Default is true")}), @GamlAnnotations.facet(name="locked", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to lock/unlock a 2D display when it opens. For 3D displays please use the `camera` statement")}), @GamlAnnotations.facet(name="draw_diffuse_light", type={3}, optional=true, doc={@GamlAnnotations.doc(deprecated="Define it in the various 'light' statements instead with 'show: true/false'", value="Allows to show/hide a representation of the lights. Default is false.")}), @GamlAnnotations.facet(name="camera", type={4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to define the name of the camera to use. Default value is 'default'. Accepted values are (1) the name of one of the cameras defined using the 'camera' statement or (2) one of the preset cameras, accessible using constants: #from_above, #from_left, #from_right, #from_up_left, #from_up_right, #from_front, #from_up_front, #isometric")}), @GamlAnnotations.facet(name="keystone", type={16}, optional=true, doc={@GamlAnnotations.doc(value="Set the position of the 4 corners of your screen ([topLeft,topRight,botLeft,botRight]), in (x,y) coordinate ( the (0,0) position is the top left corner, while the (1,1) position is the bottom right corner). The default value is : [{0,0},{1,0},{0,1},{1,1}]")}), @GamlAnnotations.facet(name="z_near", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Set the distances to the near depth clipping planes. Must be positive.")}), @GamlAnnotations.facet(name="z_far", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Set the distances to the far depth clipping planes. Must be positive.")}), @GamlAnnotations.facet(name="autosave", type={3, 7, 4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to save this display on disk. This facet accepts bool, point or string values. If it is false or nil, nothing happens. 'true' will save it at a resolution of 500x500 with a standard name (containing the name of the model, display, resolution, cycle and time). A non-nil point will change that resolution. A non-nil string will keep 500x500 and change the filename (if it is not dynamically built, the previous file will be erased). Note that setting autosave to true in a display will synchronize all the displays defined in the experiment")})}, omissible="name")
@GamlAnnotations.inside(symbols={"output", "permanent"})
@validator(value=DisplayValidator.class)
@serializer(value=DisplaySerializer.class)
@GamlAnnotations.doc(value="A display refers to an independent and mobile part of the interface that can display species, images, texts or charts.", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display [additional options] { ... }", isExecutable=false)}), @GamlAnnotations.usage(value="Each display can include different layers (like in a GIS).", examples={@GamlAnnotations.example(value="display gridWithElevationTriangulated type: opengl {", isExecutable=false), @GamlAnnotations.example(value="\tgrid cell elevation: true triangulation: true;", isExecutable=false), @GamlAnnotations.example(value="\tspecies people aspect: base;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class LayeredDisplayOutput
extends AbstractOutput {
    private final List<AbstractLayerStatement> layers;
    private final List<CameraStatement> cameras;
    private final List<LightStatement> lights;
    private RotationStatement rotation;
    protected IDisplaySurface surface;
    private int index;
    private final LayeredDisplayData data = new LayeredDisplayData();
    OverlayStatement overlayInfo;

    static {
        DEBUG.ON();
    }

    public LayeredDisplayOutput(IDescription iDescription) {
        super(iDescription);
        if (this.hasFacet("type")) {
            this.getData().setDisplayType(this.getLiteral("type"));
        }
        this.layers = new ArrayList<AbstractLayerStatement>();
        this.cameras = new ArrayList<CameraStatement>();
        this.lights = new ArrayList<LightStatement>();
    }

    public IOverlayProvider<OverlayStatement.OverlayInfo> getOverlayProvider() {
        return this.overlayInfo;
    }

    @Override
    public boolean init(IScope iScope) throws GamaRuntimeException {
        boolean bl = super.init(iScope);
        if (!bl) {
            return false;
        }
        if (this.rotation != null) {
            this.getData().setRotation(this.rotation.getDefinition());
            this.rotation.init(iScope);
        }
        for (CameraStatement iLayerStatement : this.cameras) {
            this.getData().addCameraDefinition(iLayerStatement.getDefinition());
            iLayerStatement.init(iScope);
        }
        for (LightStatement lightStatement : this.lights) {
            this.getData().addLightDefinition(lightStatement.getDefinition());
            lightStatement.init(iScope);
        }
        this.getData().initWith(this.getScope(), this.description);
        for (ILayerStatement iLayerStatement : this.getLayers()) {
            iLayerStatement.setDisplayOutput(this);
            if (this.getScope().init(iLayerStatement).passed()) continue;
            return false;
        }
        this.createSurface(this.getScope());
        return true;
    }

    @Override
    public boolean step(IScope iScope) throws GamaRuntimeException {
        for (ILayerStatement iLayerStatement : this.getLayers()) {
            try {
                this.getScope().setCurrentSymbol(iLayerStatement);
                this.getScope().step(iLayerStatement);
            }
            finally {
                iScope.setCurrentSymbol(null);
            }
        }
        return true;
    }

    @Override
    public void update() throws GamaRuntimeException {
        if (this.surface == null) {
            return;
        }
        this.getData().update(this.getScope(), this.description.getFacets());
        if (this.overlayInfo != null) {
            this.getScope().step(this.overlayInfo);
        }
        super.update();
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        super.dispose();
        if (this.surface != null) {
            this.surface.dispose();
        }
        this.surface = null;
        this.getLayers().clear();
        this.getData().dispose();
    }

    protected void createSurface(IScope iScope) {
        if (this.surface != null) {
            this.surface.outputReloaded();
            return;
        }
        if (iScope.getExperiment().isHeadless()) {
            this.getData().setDisplayType("image");
        } else if (this.getData().is3D()) {
            return;
        }
        this.surface = iScope.getGui().createDisplaySurfaceFor(this, new Object[0]);
    }

    @Override
    public String getViewId() {
        if (this.getData().isWeb()) {
            return "gama.ui.application.view.WebDisplayView";
        }
        if (this.getData().isOpenGL2()) {
            return "gama.ui.application.view.OpenGLDisplayView2";
        }
        if (this.getData().is3D()) {
            return "gama.ui.application.view.OpenGLDisplayView";
        }
        return "gama.ui.application.view.LayeredDisplayView";
    }

    public IDisplaySurface getSurface() {
        return this.surface;
    }

    @Override
    public List<? extends ISymbol> getChildren() {
        return this.getLayers();
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<AbstractLayerStatement> arrayList = new ArrayList<AbstractLayerStatement>();
        for (ISymbol iSymbol : iterable) {
            OverlayStatement overlayStatement;
            if (iSymbol instanceof CameraStatement) {
                CameraStatement cameraStatement = (CameraStatement)iSymbol;
                this.cameras.add(cameraStatement);
                continue;
            }
            if (iSymbol instanceof RotationStatement) {
                RotationStatement rotationStatement;
                this.rotation = rotationStatement = (RotationStatement)iSymbol;
                continue;
            }
            if (iSymbol instanceof LightStatement) {
                LightStatement lightStatement = (LightStatement)iSymbol;
                this.lights.add(lightStatement);
                continue;
            }
            if (iSymbol instanceof OverlayStatement && (overlayStatement = (OverlayStatement)iSymbol).hasInfo()) {
                this.overlayInfo = overlayStatement;
            }
            arrayList.add((AbstractLayerStatement)iSymbol);
        }
        this.setLayers(arrayList);
    }

    public void setSurface(IDisplaySurface iDisplaySurface) {
        this.surface = iDisplaySurface;
        if (iDisplaySurface == null) {
            this.view = null;
        }
    }

    public BufferedImage getImage() {
        return this.surface == null ? null : this.surface.getImage(this.surface.getWidth(), this.surface.getHeight());
    }

    public BufferedImage getImage(int n, int n2) {
        return this.surface == null ? null : this.surface.getImage(n, n2);
    }

    public void setLayers(List<AbstractLayerStatement> list) {
        this.layers.clear();
        this.layers.addAll(list);
    }

    public List<AbstractLayerStatement> getLayers() {
        return this.layers;
    }

    @Override
    public void setPaused(boolean bl) {
        boolean bl2 = this.isPaused();
        super.setPaused(bl);
        if (this.surface == null) {
            return;
        }
        if (this.getData().is3D()) {
            ((IDisplaySurface.OpenGL)this.surface).setPaused(bl);
        }
        if (bl2 && !bl) {
            this.surface.updateDisplay(false, null);
        }
    }

    public LayeredDisplayData getData() {
        return this.data;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public boolean isAutoSave() {
        IExpression iExpression = this.getFacet("autosave");
        return iExpression != null && iExpression != IExpressionFactory.FALSE_EXPR;
    }

    public void zoom(int n) {
        if (n < 0) {
            this.surface.zoomOut();
        } else if (n == 0) {
            this.surface.zoomFit();
        } else {
            this.surface.zoomIn();
        }
    }

    @Override
    public IGamaView.Display getView() {
        return (IGamaView.Display)super.getView();
    }

    public void releaseView() {
        this.view = null;
    }

    @Override
    protected IScope.IGraphicsScope buildScopeFrom(IScope iScope) {
        return iScope.copyForGraphics("of " + this.getDescription().getKeyword() + " " + this.getName());
    }

    @Override
    public IScope.IGraphicsScope getScope() {
        return (IScope.IGraphicsScope)super.getScope();
    }

    @Override
    protected boolean shouldOpenView() {
        return !"image".equals(this.getData().getDisplayType());
    }

    public void linkScopeWithGraphics() {
        IScope.IGraphicsScope iGraphicsScope = this.getScope();
        IDisplaySurface iDisplaySurface = this.getSurface();
        if (iGraphicsScope == null || iDisplaySurface == null) {
            return;
        }
        iGraphicsScope.setGraphics(iDisplaySurface.getIGraphics());
    }

    public static class DisplaySerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected void collectMetaInformationInFacetValue(SymbolDescription symbolDescription, String string, GamlProperties gamlProperties) {
            IExpressionDescription iExpressionDescription;
            super.collectMetaInformationInFacetValue(symbolDescription, string, gamlProperties);
            if ("type".equals(string) && (iExpressionDescription = symbolDescription.getFacet("type")).getExpression() != null) {
                String string2 = iExpressionDescription.getExpression().literalValue();
                IDisplayCreator.DisplayDescription displayDescription = GAMA.getGui().getDisplayDescriptionFor(string2);
                if (displayDescription != null) {
                    gamlProperties.put("plugins", displayDescription.getDefiningPlugin());
                }
            }
        }
    }

    public static class DisplayValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription2) {
            boolean bl;
            IExpressionDescription iExpressionDescription;
            IExpressionDescription iExpressionDescription2 = iDescription2.getFacet("parent");
            if (iExpressionDescription2 != null) {
                this.handleInheritance(iDescription2, iExpressionDescription2.toString());
            }
            if ((iExpressionDescription = iDescription2.getFacet("autosave")) != null && iExpressionDescription.getExpression().isConst() && "true".equals(iExpressionDescription.getExpression().literalValue())) {
                iDescription2.info("With autosave enabled, GAMA must remain the frontmost window and the display must not be covered or obscured by other windows", "gaml.general.issue", iExpressionDescription.getTarget(), "autosave");
            }
            IExpressionDescription iExpressionDescription3 = iDescription2.getFacet("type");
            boolean bl2 = bl = !"2d".equals(GamaPreferences.Displays.CORE_DISPLAY.getValue());
            if (iExpressionDescription3 == null) {
                iExpressionDescription3 = ConstantExpressionDescription.create(bl ? "3d" : "2d");
                iDescription2.setFacetExprDescription("type", iExpressionDescription3);
            }
            String string = "";
            String string2 = iExpressionDescription3.getExpression().literalValue();
            if (!IGui.DISPLAYS.containsKey(string2) && !GAMA.isInHeadLessMode()) {
                string = (String)IGui.DISPLAYS.keySet().stream().findFirst().get();
                iDescription2.warning(string2 + " is not a valid display type. Valid types are:" + String.valueOf(IGui.DISPLAYS.keySet()) + ". Gama will fallback to first valid type (" + string + ")", "gaml.unknown.keyword.issue", "type", new String[0]);
                iDescription2.setFacet("type", ConstantExpressionDescription.create(string));
            }
            if ("3d".equals(iExpressionDescription3.getExpression().literalValue()) && !Iterables.isEmpty(iDescription2.getOwnChildren()) && iDescription2.visitOwnChildren(iDescription -> "chart".equals(iDescription.getKeyword()) || "event".equals(iDescription.getKeyword()))) {
                iDescription2.warning("Consider switching to a 2d display if you only display charts", "gaml.conflicting.facets", "type", new String[0]);
            }
        }

        private void handleInheritance(IDescription iDescription, String string) {
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            for (IDescription iDescription3 : iDescription2.getChildrenWithKeyword("display")) {
                if (!iDescription3.getName().equals(string)) continue;
                this.handleInheritance(iDescription, iDescription3);
                return;
            }
            iDescription.error("No parent display named '" + string + "' found");
        }

        private void handleInheritance(IDescription iDescription, IDescription iDescription2) {
            Facets facets2 = iDescription.getFacets();
            boolean bl = facets2.containsKey("virtual");
            Facets facets3 = iDescription2.getFacets();
            facets2.complementWith(facets3);
            if (!bl) {
                facets2.remove("virtual");
            }
            iDescription.replaceChildrenWith(Iterables.concat(iDescription2.getOwnChildren(), iDescription.getOwnChildren()));
        }
    }
}

