/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.model.GamlModelSpecies;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.outputs.InspectDisplayOutput;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.ISpecies;
import java.util.Collection;

public class ValuedDisplayOutputFactory {
    public static void browse(Collection<? extends IAgent> collection) {
        IPopulation iPopulation = null;
        IMacroAgent iMacroAgent = null;
        if (collection instanceof IPopulation) {
            iPopulation = (IPopulation)collection;
            ValuedDisplayOutputFactory.browse(iPopulation.getHost(), iPopulation.getSpecies());
        } else {
            for (IAgent iAgent2 : collection) {
                IPopulation<? extends IAgent> iPopulation2;
                if (iAgent2 != null && (iMacroAgent = (iPopulation2 = iAgent2.getPopulation()).getHost()) != null) break;
            }
            if (iMacroAgent == null) {
                return;
            }
            IMacroAgent iMacroAgent2 = ValuedDisplayOutputFactory.findRootOf(iMacroAgent, collection);
            if (iMacroAgent2 == null) {
                throw GamaRuntimeException.error("Impossible to find a common host agent for " + String.valueOf(collection), iMacroAgent.getScope());
            }
            InspectDisplayOutput.browse(iMacroAgent2, collection, null).launch(iMacroAgent2.getScope());
        }
    }

    private static IMacroAgent findRootOf(IMacroAgent iMacroAgent, Collection<? extends IAgent> collection) {
        if (collection instanceof IPopulation) {
            return ((IPopulation)collection).getHost();
        }
        IMacroAgent iMacroAgent2 = null;
        for (IAgent iAgent : collection) {
            if (iAgent == null) continue;
            if (iMacroAgent2 == null) {
                iMacroAgent2 = iAgent.getHost();
                continue;
            }
            if (iAgent.getHost() == iMacroAgent2) continue;
            return null;
        }
        return iMacroAgent2;
    }

    public static void browse(IMacroAgent iMacroAgent, ISpecies iSpecies) {
        if (iMacroAgent instanceof IExperimentAgent && iSpecies instanceof GamlModelSpecies) {
            InspectDisplayOutput.browse(iMacroAgent, iSpecies, null).launch(iMacroAgent.getScope());
            return;
        }
        if (!iMacroAgent.getSpecies().getMicroSpecies().contains(iSpecies)) {
            if (!(iMacroAgent instanceof ExperimentAgent)) {
                throw GamaRuntimeException.error("Agent " + String.valueOf(iMacroAgent) + " has no access to populations of " + iSpecies.getName(), iMacroAgent.getScope());
            }
            SimulationAgent simulationAgent = ((ExperimentAgent)iMacroAgent).getSimulation();
            ValuedDisplayOutputFactory.browse(simulationAgent, iSpecies);
            return;
        }
        InspectDisplayOutput.browse(iMacroAgent, iSpecies, null).launch(iMacroAgent.getScope());
    }

    public static void browse(IMacroAgent iMacroAgent, IExpression iExpression, IExpression iExpression2) {
        SpeciesDescription speciesDescription;
        SpeciesDescription speciesDescription2 = speciesDescription = iExpression.getGamlType().isContainer() ? iExpression.getGamlType().getContentType().getSpecies() : iExpression.getGamlType().getSpecies();
        if (speciesDescription == null) {
            throw GamaRuntimeException.error("Expression '" + iExpression.serializeToGaml(true) + "' does not reference agents", iMacroAgent.getScope());
        }
        ISpecies iSpecies = iMacroAgent.getSpecies();
        if (iSpecies.getMicroSpecies(speciesDescription.getName()) == null) {
            if (!(iMacroAgent instanceof ExperimentAgent)) {
                throw GamaRuntimeException.error("Agent " + String.valueOf(iMacroAgent) + " has no access to populations of " + speciesDescription.getName(), iMacroAgent.getScope());
            }
            SimulationAgent simulationAgent = ((ExperimentAgent)iMacroAgent).getSimulation();
            ValuedDisplayOutputFactory.browse(simulationAgent, iExpression, iExpression2);
            return;
        }
        InspectDisplayOutput.browse(iMacroAgent, iExpression, iExpression2).launch(iMacroAgent.getScope());
    }

    public static void browseSimulations(ExperimentAgent experimentAgent) {
        InspectDisplayOutput.inspect(experimentAgent, null).launch(experimentAgent.getScope());
    }
}

