/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.DefaultServerCommands;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaWebSocketServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.enums.ReadyState;

public class CommandExecutor {
    private final GamaWebSocketServer server;
    private static Map<String, ISocketCommand> DEFAULT_COMMANDS = null;
    protected final Map<String, ISocketCommand> commands;
    protected volatile LinkedBlockingQueue<Map.Entry<WebSocket, IMap<String, Object>>> commandQueue;
    protected static final Json jsonEncoder = Json.getNew();

    public CommandExecutor(GamaWebSocketServer gamaWebSocketServer) {
        this.server = gamaWebSocketServer;
        this.commands = GAMA.getGui().getServerCommands();
        this.commandQueue = new LinkedBlockingQueue();
    }

    public void pushCommand(WebSocket webSocket, IMap<String, Object> iMap) {
        this.commandQueue.offer(new AbstractMap.SimpleEntry<WebSocket, IMap<String, Object>>(webSocket, iMap));
    }

    protected void process(WebSocket webSocket, IMap<String, Object> iMap) {
        String string = iMap.get("type").toString();
        ISocketCommand iSocketCommand = this.commands.get(string);
        if (iSocketCommand == null) {
            throw new IllegalArgumentException("Invalid command type: " + string);
        }
        GamaServerMessage gamaServerMessage = iSocketCommand.execute(this.server, webSocket, iMap);
        if (gamaServerMessage != null && ReadyState.OPEN.equals((Object)webSocket.getReadyState())) {
            webSocket.send(jsonEncoder.valueOf(gamaServerMessage).toString());
        }
    }

    public static CommandResponse checkLoadParameters(IList iList, IMap<String, Object> iMap) {
        if (iList != null) {
            int n = 1;
            for (Object e : iList.listValue((IScope)null, (IType)Types.MAP, false)) {
                IMap iMap2 = (IMap)e;
                Object v = iMap2.get("name");
                Object v2 = iMap2.get("value");
                if (v == null) {
                    return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "Parameter number " + n + " is missing its `name` field. Parameter received: " + String.valueOf(jsonEncoder.valueOf(iMap2)), iMap, false);
                }
                if (v2 == null) {
                    return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "Parameter number " + n + " is missing its `value` field. Parameter received: " + String.valueOf(jsonEncoder.valueOf(iMap2)), iMap, false);
                }
                ++n;
            }
        }
        return null;
    }

    public static synchronized Map<String, ISocketCommand> getDefaultCommands() {
        if (DEFAULT_COMMANDS == null) {
            DEFAULT_COMMANDS = Map.ofEntries(Map.entry("load", DefaultServerCommands::LOAD), Map.entry("play", DefaultServerCommands::PLAY), Map.entry("pause", DefaultServerCommands::PAUSE), Map.entry("step", DefaultServerCommands::STEP), Map.entry("back", DefaultServerCommands::BACK), Map.entry("stepBack", DefaultServerCommands::BACK), Map.entry("stop", DefaultServerCommands::STOP), Map.entry("reload", DefaultServerCommands::RELOAD), Map.entry("expression", DefaultServerCommands::EVAL), Map.entry("evaluate", DefaultServerCommands::EVAL), Map.entry("exit", DefaultServerCommands::EXIT), Map.entry("download", DefaultServerCommands::DOWNLOAD), Map.entry("upload", DefaultServerCommands::UPLOAD), Map.entry("ask", DefaultServerCommands::ASK), Map.entry("validate", DefaultServerCommands::VALIDATE), Map.entry("describe", DefaultServerCommands::DESCRIBE));
        }
        return DEFAULT_COMMANDS;
    }
}

