/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.constants.ColorCSS;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.util.GamaMapFactory;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="red", type=1, doc={@GamlAnnotations.doc(value="Returns the red component of the color (between 0 and 255)")}), @GamlAnnotations.variable(name="green", type=1, doc={@GamlAnnotations.doc(value="Returns the green component of the color (between 0 and 255)")}), @GamlAnnotations.variable(name="blue", type=1, doc={@GamlAnnotations.doc(value="Returns the blue component of the color (between 0 and 255)")}), @GamlAnnotations.variable(name="alpha", type=1, doc={@GamlAnnotations.doc(value="Returns the alpha component (transparency) of the color (between 0 for transparent and 255 for opaque)")}), @GamlAnnotations.variable(name="brighter", type=6, doc={@GamlAnnotations.doc(value="Returns a lighter color (with increased luminance)")}), @GamlAnnotations.variable(name="darker", type=6, doc={@GamlAnnotations.doc(value="Returns a darker color (with decreased luminance)")})})
public class GamaColor
extends Color
implements IValue,
Comparable<Color> {
    public static final Object[] array;
    public static final Map<String, GamaColor> colors;
    public static final Map<Integer, GamaColor> int_colors;
    static float BRIGHTNESS_FACTOR;

    static {
        GamaColor gamaColor;
        array = ColorCSS.array;
        colors = GamaMapFactory.createUnordered();
        int_colors = Collections.synchronizedMap(new HashMap());
        int n = 0;
        while (n < array.length) {
            gamaColor = GamaColor.get((String)array[n], (int[])array[n + 1]);
            colors.put((String)array[n], gamaColor);
            int_colors.put(gamaColor.getRGB(), gamaColor);
            n += 2;
        }
        GamaColor gamaColor2 = GamaColor.get("gamaorange", 244, 165, 40, 255);
        colors.put("gamaorange", gamaColor2);
        int_colors.put(gamaColor2.getRGB(), gamaColor2);
        gamaColor = GamaColor.get("gamared", 217, 72, 33, 255);
        colors.put("gamared", gamaColor);
        int_colors.put(gamaColor.getRGB(), gamaColor);
        GamaColor gamaColor3 = GamaColor.get("gamablue", 22, 94, 147, 255);
        colors.put("gamablue", gamaColor3);
        int_colors.put(gamaColor3.getRGB(), gamaColor3);
        GamaColor gamaColor4 = GamaColor.get("gamagreen", 81, 135, 56, 255);
        colors.put("gamagreen", gamaColor4);
        int_colors.put(gamaColor4.getRGB(), gamaColor4);
        BRIGHTNESS_FACTOR = 0.7f;
    }

    public static GamaColor get(int n) {
        GamaColor gamaColor = int_colors.get(n);
        if (gamaColor == null) {
            gamaColor = new GamaColor(n);
            int_colors.put(n, gamaColor);
        }
        return gamaColor;
    }

    public static GamaColor get(int n, int n2) {
        GamaColor gamaColor = GamaColor.get(n);
        return GamaColor.get(gamaColor.getRed(), gamaColor.getGreen(), gamaColor.getBlue(), n2);
    }

    public static GamaColor get(int n, int n2, int n3) {
        return GamaColor.get(n, n2, n3, 255);
    }

    public static GamaColor get(int n, int n2, int n3, int n4) {
        return GamaColor.get((GamaColor.normalize(n4) & 0xFF) << 24 | (GamaColor.normalize(n) & 0xFF) << 16 | (GamaColor.normalize(n2) & 0xFF) << 8 | (GamaColor.normalize(n3) & 0xFF) << 0);
    }

    public static GamaColor getWithDoubleAlpha(int n, int n2, int n3, double d) {
        return GamaColor.get(n, n2, n3, GamaColor.normalize(d));
    }

    public static GamaColor getWithDoubles(double d, double d2, double d3, double d4) {
        return GamaColor.get(GamaColor.normalize(d), GamaColor.normalize(d2), GamaColor.normalize(d3), GamaColor.normalize(d4));
    }

    public static GamaColor get(Color color, double d) {
        return GamaColor.get(color, GamaColor.normalize(d));
    }

    public static GamaColor get(Color color, int n) {
        return GamaColor.get(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static GamaColor get(Color color) {
        return GamaColor.get(color.getRGB());
    }

    public static GamaColor get(String string) {
        return colors.get(string);
    }

    public static GamaColor get(String string, int ... nArray) {
        GamaColor gamaColor = colors.get(string);
        if (gamaColor == null) {
            colors.put(string, new NamedGamaColor(string, nArray[0], nArray[1], nArray[2], nArray[3]));
        }
        return colors.get(string);
    }

    private static int normalize(int n) {
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    private static int normalize(double d) {
        return (int)(d < 0.0 ? 0.0 : (d > 1.0 ? 255.0 : 255.0 * d));
    }

    protected GamaColor(int n) {
        super(n, true);
    }

    protected GamaColor(int n, int n2, int n3, int n4) {
        super(GamaColor.normalize(n), GamaColor.normalize(n2), GamaColor.normalize(n3), GamaColor.normalize(n4));
    }

    @Override
    public String toString() {
        return this.serializeToGaml(true);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "rgb (" + String.valueOf(this.red()) + ", " + String.valueOf(this.green()) + ", " + String.valueOf(this.blue()) + ", " + this.getAlpha() + ")";
    }

    @Override
    public String stringValue(IScope iScope) {
        return this.toString();
    }

    @GamlAnnotations.getter(value="red")
    public Integer red() {
        return super.getRed();
    }

    @GamlAnnotations.getter(value="blue")
    public Integer blue() {
        return super.getBlue();
    }

    @GamlAnnotations.getter(value="green")
    public Integer green() {
        return super.getGreen();
    }

    @GamlAnnotations.getter(value="alpha")
    public Integer alpha() {
        return super.getAlpha();
    }

    @Override
    @GamlAnnotations.getter(value="brighter")
    public GamaColor brighter() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        int n4 = this.getAlpha();
        int n5 = (int)(1.0 / (1.0 - (double)BRIGHTNESS_FACTOR));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return GamaColor.get(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return GamaColor.get(Math.min((int)((float)n / BRIGHTNESS_FACTOR), 255), Math.min((int)((float)n2 / BRIGHTNESS_FACTOR), 255), Math.min((int)((float)n3 / BRIGHTNESS_FACTOR), 255), n4);
    }

    @Override
    @GamlAnnotations.getter(value="darker")
    public GamaColor darker() {
        return GamaColor.get(Math.max((int)((float)this.getRed() * BRIGHTNESS_FACTOR), 0), Math.max((int)((float)this.getGreen() * BRIGHTNESS_FACTOR), 0), Math.max((int)((float)this.getBlue() * BRIGHTNESS_FACTOR), 0), this.getAlpha());
    }

    @Override
    public GamaColor copy(IScope iScope) {
        return GamaColor.get(this);
    }

    public static GamaColor merge(GamaColor gamaColor, GamaColor gamaColor2) {
        return GamaColor.get(gamaColor.getRed() + gamaColor2.getRed(), gamaColor.getGreen() + gamaColor2.getGreen(), gamaColor.getBlue() + gamaColor2.getBlue(), gamaColor.getAlpha() + gamaColor2.getAlpha());
    }

    public int compareRgbTo(Color color) {
        return Integer.signum(this.getRGB() - color.getRGB());
    }

    public int compareLuminescenceTo(Color color) {
        return Double.compare((double)this.getRed() * 0.299 + (double)this.getGreen() * 0.587 + (double)this.getBlue() * 0.114, (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114);
    }

    public int compareBrightnessTo(Color color) {
        float[] fArray = GamaColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        float[] fArray2 = GamaColor.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Float.compare(fArray[2], fArray2[2]);
    }

    public int compareLumaTo(Color color) {
        return Double.compare((double)this.getRed() * 0.21 + (double)this.getGreen() * 0.72 + (double)this.getBlue() * 0.07, (double)color.getRed() * 0.21 + (double)color.getGreen() * 0.72 + (double)color.getBlue() * 0.07);
    }

    @Override
    public int compareTo(Color color) {
        return this.compareRgbTo(color);
    }

    @Override
    public IType<?> getGamlType() {
        return Types.COLOR;
    }

    public GamaColor withAlpha(double d) {
        return GamaColor.getWithDoubleAlpha(this.getRed(), this.getGreen(), this.getBlue(), d);
    }

    public boolean isZero() {
        return this.getRed() == 0 && this.getGreen() == 0 && this.getBlue() == 0;
    }

    @Override
    public int intValue(IScope iScope) {
        return super.getRGB();
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "red", this.getRed(), "green", this.getGreen(), "blue", this.getBlue(), "alpha", this.getAlpha());
    }

    public static class NamedGamaColor
    extends GamaColor {
        final String name;

        NamedGamaColor(String string, int ... nArray) {
            super(nArray[0], nArray[1], nArray[2], nArray[3]);
            this.name = string;
        }

        @Override
        public String toString() {
            return "color[" + this.name + "]";
        }

        @Override
        public String serializeToGaml(boolean bl) {
            return "#" + this.name;
        }

        @Override
        public String stringValue(IScope iScope) {
            return this.name;
        }
    }
}

