/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import com.google.common.primitives.Ints;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.ArrayUtils;

public class GamaIntMatrix
extends GamaMatrix<Integer>
implements IImageProvider {
    private double cellSize;
    int[] matrix;

    public static GamaIntMatrix from(IScope iScope, IMatrix iMatrix) {
        if (iMatrix instanceof GamaIntMatrix) {
            return (GamaIntMatrix)iMatrix;
        }
        if (iMatrix instanceof GamaObjectMatrix) {
            return new GamaIntMatrix(iScope, iMatrix.getCols(iScope), iMatrix.getRows(iScope), ((GamaObjectMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaFloatMatrix) {
            return new GamaIntMatrix(iMatrix.getCols(iScope), iMatrix.getRows(iScope), ((GamaFloatMatrix)iMatrix).getMatrix());
        }
        return null;
    }

    public static GamaIntMatrix from(IScope iScope, int n, int n2, IMatrix iMatrix) {
        if (iMatrix instanceof GamaIntMatrix) {
            return new GamaIntMatrix(n, n2, ((GamaIntMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaObjectMatrix) {
            return new GamaIntMatrix(iScope, n, n2, ((GamaObjectMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaFloatMatrix) {
            return new GamaIntMatrix(n, n2, ((GamaFloatMatrix)iMatrix).getMatrix());
        }
        return null;
    }

    public GamaIntMatrix(GamaPoint gamaPoint) {
        this((int)gamaPoint.x, (int)gamaPoint.y);
    }

    @Override
    public IContainerType getGamlType() {
        return Types.MATRIX.of(Types.INT);
    }

    public GamaIntMatrix(int n, int n2) {
        super(n, n2, Types.INT);
        this.matrix = new int[n * n2];
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public GamaIntMatrix(int n, int n2, double[] dArray) {
        this(n, n2);
        int n3 = 0;
        int n4 = Math.min(dArray.length, n2 * n);
        while (n3 < n4) {
            this.matrix[n3] = (int)dArray[n3];
            ++n3;
        }
    }

    public GamaIntMatrix(int n, int n2, int[] nArray) {
        this(n, n2);
        System.arraycopy(nArray, 0, this.matrix, 0, Math.min(nArray.length, n2 * n));
    }

    public GamaIntMatrix(IScope iScope, int n, int n2, Object[] objectArray) {
        this(n, n2);
        int n3 = 0;
        int n4 = Math.min(objectArray.length, n2 * n);
        while (n3 < n4) {
            this.matrix[n3] = Cast.asInt(iScope, objectArray[n3]);
            ++n3;
        }
    }

    public GamaIntMatrix(IScope iScope, int[] nArray) {
        super(1, nArray.length, Types.INT);
        this.matrix = nArray;
    }

    public GamaIntMatrix(IScope iScope, List list, GamaPoint gamaPoint) {
        super(iScope, list, gamaPoint, Types.INT);
        this.matrix = new int[this.numRows * this.numCols];
        if (gamaPoint != null) {
            int n = 0;
            int n2 = Math.min(this.matrix.length, list.size());
            while (n < n2) {
                this.matrix[n] = Cast.asInt(iScope, list.get(n));
                ++n;
            }
        } else if (GamaMatrix.isFlat(list)) {
            int n = 0;
            int n3 = list.size();
            while (n < n3) {
                this.matrix[n] = Cast.asInt(iScope, list.get(n));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numRows) {
                int n4 = 0;
                while (n4 < this.numCols) {
                    this.set(iScope, n4, n, Cast.asInt(iScope, ((List)list.get(n4)).get(n)));
                    ++n4;
                }
                ++n;
            }
        }
    }

    public GamaIntMatrix(IScope iScope, Object[] objectArray) {
        this(1, objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.matrix[n] = Cast.asInt(iScope, objectArray[n]);
            ++n;
        }
    }

    @Override
    public void _clear() {
        Arrays.fill(this.matrix, 0);
    }

    @Override
    protected void _putAll(IScope iScope, Object object) throws GamaRuntimeException {
        this.fillWith(Types.INT.cast(iScope, object, null, false));
    }

    @Override
    protected boolean _contains(IScope iScope, Object object) {
        int[] nArray = this.matrix;
        int n = this.matrix.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (object instanceof Integer && n3 == (Integer)object) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Integer _first(IScope iScope) {
        if (this.matrix.length == 0) {
            return 0;
        }
        return this.matrix[0];
    }

    @Override
    public Integer _last(IScope iScope) {
        if (this.matrix.length == 0) {
            return 0;
        }
        return this.matrix[this.matrix.length - 1];
    }

    @Override
    public Integer _length(IScope iScope) {
        return this.matrix.length;
    }

    public GamaIntMatrix _opAppendVertically(IScope iScope, GamaIntMatrix gamaIntMatrix) {
        int[] nArray = ArrayUtils.addAll((int[])this.getMatrix(), (int[])gamaIntMatrix.getMatrix());
        return new GamaIntMatrix(this.numCols, this.numRows + gamaIntMatrix.getRows(iScope), nArray);
    }

    public GamaIntMatrix _opAppendHorizontally(IScope iScope, GamaIntMatrix gamaIntMatrix) {
        GamaIntMatrix gamaIntMatrix2 = this._reverse(iScope);
        GamaIntMatrix gamaIntMatrix3 = gamaIntMatrix._reverse(iScope);
        GamaIntMatrix gamaIntMatrix4 = gamaIntMatrix2._opAppendVertically(iScope, gamaIntMatrix3);
        return gamaIntMatrix4._reverse(iScope);
    }

    @Override
    public boolean _isEmpty(IScope iScope) {
        int[] nArray = this.matrix;
        int n = this.matrix.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected IList _listValue(IScope iScope, IType iType, boolean bl) {
        return bl ? GamaListFactory.create(iScope, iType, this.matrix) : GamaListFactory.createWithoutCasting(iType, this.matrix);
    }

    @Override
    protected IMatrix _matrixValue(IScope iScope, GamaPoint gamaPoint, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, gamaPoint, bl);
    }

    public GamaIntMatrix _reverse(IScope iScope) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(this.numRows, this.numCols);
        int n = 0;
        while (n < this.numCols) {
            int n2 = 0;
            while (n2 < this.numRows) {
                gamaIntMatrix.set(iScope, n2, n, this.get(iScope, n, n2));
                ++n2;
            }
            ++n;
        }
        return gamaIntMatrix;
    }

    @Override
    public GamaIntMatrix copy(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        if (gamaPoint != null) {
            return new GamaIntMatrix((int)gamaPoint.getX(), (int)gamaPoint.getX(), Arrays.copyOf(this.matrix, this.matrix.length));
        }
        if (bl) {
            return new GamaIntMatrix(this.numCols, this.numRows, Arrays.copyOf(this.matrix, this.matrix.length));
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GamaIntMatrix)) {
            return false;
        }
        GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)object;
        return Arrays.equals(this.matrix, gamaIntMatrix.matrix);
    }

    public int hashCode() {
        return Arrays.hashCode(this.matrix);
    }

    public void fillWith(int n) {
        Arrays.fill(this.matrix, n);
    }

    @Override
    public Integer get(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return 0;
        }
        return this.matrix[n2 * this.numCols + n];
    }

    public double getSize() {
        return this.cellSize;
    }

    public void set(IScope iScope, int n, int n2, int n3) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return;
        }
        this.matrix[n2 * this.numCols + n] = n3;
    }

    @Override
    public void set(IScope iScope, int n, int n2, Object object) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return;
        }
        this.matrix[n2 * this.numCols + n] = Cast.asInt(iScope, object);
    }

    public boolean remove(int n) {
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] == n) {
                this.matrix[n2] = 0;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Integer remove(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return 0;
        }
        int n3 = this.matrix[n2 * this.numCols + n];
        this.matrix[n2 * this.numCols + n] = 0;
        return n3;
    }

    @Override
    public boolean _removeFirst(IScope iScope, Integer n) {
        return this.remove(n);
    }

    public boolean removeAll(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] == n) {
                this.matrix[n2] = 0;
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    @Override
    public boolean _removeAll(IScope iScope, IContainer<?, Integer> iContainer) {
        for (Integer n : iContainer.iterable(iScope)) {
            this.removeAll(n);
        }
        return true;
    }

    public void setCellSize(double d) {
        this.cellSize = d;
    }

    @Override
    public void shuffleWith(RandomUtils randomUtils) {
        randomUtils.shuffleInPlace(this.getMatrix());
    }

    @Override
    public Iterable<Integer> iterable(IScope iScope) {
        return Ints.asList((int[])this.matrix);
    }

    @Override
    public GamaIntMatrix plus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = GamaIntMatrix.from(iScope, iMatrix);
        if (gamaIntMatrix != null && this.numCols == gamaIntMatrix.numCols && this.numRows == gamaIntMatrix.numRows) {
            GamaIntMatrix gamaIntMatrix2 = new GamaIntMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaIntMatrix2.matrix[n] = this.matrix[n] + gamaIntMatrix.matrix[n];
                ++n;
            }
            return gamaIntMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaIntMatrix times(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = GamaIntMatrix.from(iScope, iMatrix);
        if (gamaIntMatrix != null && this.numCols == gamaIntMatrix.numCols && this.numRows == gamaIntMatrix.numRows) {
            GamaIntMatrix gamaIntMatrix2 = new GamaIntMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaIntMatrix2.matrix[n] = this.matrix[n] * gamaIntMatrix.matrix[n];
                ++n;
            }
            return gamaIntMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaIntMatrix minus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = GamaIntMatrix.from(iScope, iMatrix);
        if (gamaIntMatrix != null && this.numCols == gamaIntMatrix.numCols && this.numRows == gamaIntMatrix.numRows) {
            GamaIntMatrix gamaIntMatrix2 = new GamaIntMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaIntMatrix2.matrix[n] = this.matrix[n] - gamaIntMatrix.matrix[n];
                ++n;
            }
            return gamaIntMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix times(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        double[] dArray = gamaFloatMatrix.getMatrix();
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = (double)this.matrix[n] * d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaIntMatrix times(Integer n) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaIntMatrix.matrix[n2] = this.matrix[n2] * n;
            ++n2;
        }
        return gamaIntMatrix;
    }

    @Override
    public GamaFloatMatrix divides(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        double[] dArray = gamaFloatMatrix.getMatrix();
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = (double)this.matrix[n] / d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix divides(Integer n) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        double[] dArray = gamaFloatMatrix.getMatrix();
        int n2 = 0;
        while (n2 < this.matrix.length) {
            dArray[n2] = (double)this.matrix[n2] / (double)n.intValue();
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaIntMatrix divides(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = GamaIntMatrix.from(iScope, iMatrix);
        if (gamaIntMatrix != null && this.numCols == gamaIntMatrix.numCols && this.numRows == gamaIntMatrix.numRows) {
            GamaIntMatrix gamaIntMatrix2 = new GamaIntMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaIntMatrix2.matrix[n] = this.matrix[n] / gamaIntMatrix.matrix[n];
                ++n;
            }
            return gamaIntMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix plus(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        double[] dArray = gamaFloatMatrix.getMatrix();
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = (double)this.matrix[n] + d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaIntMatrix plus(Integer n) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaIntMatrix.matrix[n2] = this.matrix[n2] + n;
            ++n2;
        }
        return gamaIntMatrix;
    }

    @Override
    public GamaFloatMatrix minus(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        double[] dArray = gamaFloatMatrix.getMatrix();
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = (double)this.matrix[n] - d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaIntMatrix minus(Integer n) throws GamaRuntimeException {
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaIntMatrix.matrix[n2] = this.matrix[n2] - n;
            ++n2;
        }
        return gamaIntMatrix;
    }

    @Override
    public Integer getNthElement(Integer n) {
        if (n == null || n > this.getMatrix().length) {
            return 0;
        }
        return this.getMatrix()[n];
    }

    @Override
    protected void setNthElement(IScope iScope, int n, Object object) {
        this.getMatrix()[n] = Cast.asInt(iScope, object);
    }

    @Override
    public StreamEx<Integer> stream(IScope iScope) {
        return IntStreamEx.of((int[])this.matrix).boxed();
    }

    @Override
    public double[] getFieldData(IScope iScope) {
        double[] dArray = new double[this.matrix.length];
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = this.matrix[n];
            ++n;
        }
        return dArray;
    }

    public static BufferedImage constructBufferedImageFromMatrix(IScope iScope, IMatrix<Integer> iMatrix) {
        if (!(iMatrix instanceof GamaIntMatrix)) {
            return null;
        }
        GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)iMatrix;
        return gamaIntMatrix.getImage(iScope);
    }

    @Override
    public String getId() {
        return "matrix" + this.hashCode();
    }

    @Override
    public BufferedImage getImage(IScope iScope, boolean bl) {
        int n = this.getCols(iScope);
        int n2 = this.getRows(iScope);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                bufferedImage.setRGB(n3, n4, this.get(iScope, n3, n4));
                ++n4;
            }
            ++n3;
        }
        return bufferedImage;
    }
}

