/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import com.google.common.collect.ImmutableList;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.ArrayUtils;

public class GamaObjectMatrix
extends GamaMatrix<Object> {
    protected Object[] matrix;

    public static GamaObjectMatrix from(int n, int n2, IMatrix<?> iMatrix) {
        if (iMatrix instanceof GamaFloatMatrix) {
            return new GamaObjectMatrix(n, n2, ((GamaFloatMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaObjectMatrix) {
            return new GamaObjectMatrix(n, n2, ((GamaObjectMatrix)iMatrix).getMatrix(), iMatrix.getGamlType().getContentType());
        }
        if (iMatrix instanceof GamaIntMatrix) {
            return new GamaObjectMatrix(n, n2, ((GamaIntMatrix)iMatrix).matrix);
        }
        if (iMatrix instanceof GamaSpatialMatrix) {
            return new GamaObjectMatrix(n, n2, ((GamaSpatialMatrix)iMatrix).getMatrix(), iMatrix.getGamlType().getContentType());
        }
        return null;
    }

    public GamaObjectMatrix(GamaPoint gamaPoint, IType<?> iType) {
        this((int)gamaPoint.getX(), (int)gamaPoint.getY(), iType);
    }

    public GamaObjectMatrix(int n, int n2, IType<?> iType) {
        super(n, n2, iType);
        this.setMatrix(new Object[n * n2]);
    }

    public GamaObjectMatrix(int n, int n2, double[] dArray) {
        this(n, n2, Types.FLOAT);
        int n3 = Math.min(dArray.length, n2 * n);
        int n4 = 0;
        while (n4 < n3) {
            this.matrix[n4] = dArray[n4];
            ++n4;
        }
    }

    public GamaObjectMatrix(int n, int n2, int[] nArray) {
        this(n, n2, Types.INT);
        int n3 = Math.min(nArray.length, n2 * n);
        int n4 = 0;
        while (n4 < n3) {
            this.matrix[n4] = nArray[n4];
            ++n4;
        }
    }

    public GamaObjectMatrix(int n, int n2, Object[] objectArray, IType<?> iType) {
        this(n, n2, iType);
        System.arraycopy(objectArray, 0, this.getMatrix(), 0, Math.min(objectArray.length, n2 * n));
    }

    public GamaObjectMatrix(IScope iScope, IList<?> iList, GamaPoint gamaPoint, IType<?> iType) {
        super(iScope, iList, gamaPoint, iType);
        this.setMatrix(new Object[this.numRows * this.numCols]);
        boolean bl = GamaType.requiresCasting(iType, iList.getGamlType().getContentType());
        if (gamaPoint != null) {
            int n = 0;
            int n2 = Math.min(this.getMatrix().length, iList.size());
            while (n < n2) {
                this.getMatrix()[n] = bl ? iType.cast(iScope, iList.get(n), null, false) : iList.get(n);
                ++n;
            }
        } else if (GamaObjectMatrix.isFlat(iList)) {
            int n = 0;
            int n3 = iList.size();
            while (n < n3) {
                this.getMatrix()[n] = iType.cast(iScope, iList.get(n), null, false);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numRows) {
                int n4 = 0;
                while (n4 < this.numCols) {
                    this.set(iScope, n4, n, ((List)iList.get(n4)).get(n));
                    ++n4;
                }
                ++n;
            }
        }
    }

    @Override
    public void _clear() {
        Arrays.fill(this.getMatrix(), null);
    }

    @Override
    public boolean _contains(IScope iScope, Object object) {
        int n = 0;
        while (n < this.getMatrix().length) {
            if (this.getMatrix()[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public Object _first(IScope iScope) {
        if (this.getMatrix().length == 0) {
            return null;
        }
        return this.getMatrix()[0];
    }

    @Override
    public Object _last(IScope iScope) {
        if (this.getMatrix().length == 0) {
            return null;
        }
        return this.getMatrix()[this.getMatrix().length - 1];
    }

    @Override
    public Integer _length(IScope iScope) {
        return this.getMatrix().length;
    }

    public IMatrix<?> _opAppendVertically(IScope iScope, IMatrix<?> iMatrix) {
        Object[] objectArray = ArrayUtils.addAll((Object[])this.getMatrix(), (Object[])((GamaObjectMatrix)iMatrix).getMatrix());
        IType<?> iType = GamaType.findCommonType(this.getGamlType().getContentType(), iMatrix.getGamlType().getContentType());
        return new GamaObjectMatrix(this.numCols, this.numRows + iMatrix.getRows(iScope), objectArray, iType);
    }

    public GamaObjectMatrix _opAppendHorizontally(IScope iScope, IMatrix<?> iMatrix) {
        GamaObjectMatrix gamaObjectMatrix = this._reverse(iScope);
        GamaObjectMatrix gamaObjectMatrix2 = GamaObjectMatrix.from(iMatrix.getCols(iScope), iMatrix.getRows(iScope), iMatrix)._reverse(iScope);
        GamaObjectMatrix gamaObjectMatrix3 = (GamaObjectMatrix)gamaObjectMatrix._opAppendVertically(iScope, gamaObjectMatrix2);
        return gamaObjectMatrix3._reverse(iScope);
    }

    @Override
    public boolean _isEmpty(IScope iScope) {
        int n = 0;
        while (n < this.getMatrix().length) {
            if (this.getMatrix()[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected IList<Object> _listValue(IScope iScope, IType iType, boolean bl) {
        return bl ? GamaListFactory.create(iScope, iType, this.getMatrix()) : GamaListFactory.wrap(iType, this.getMatrix());
    }

    @Override
    protected IMatrix<Object> _matrixValue(IScope iScope, GamaPoint gamaPoint, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, gamaPoint, bl);
    }

    public GamaObjectMatrix _reverse(IScope iScope) throws GamaRuntimeException {
        GamaObjectMatrix gamaObjectMatrix = new GamaObjectMatrix(this.numRows, this.numCols, this.getGamlType().getContentType());
        int n = 0;
        while (n < this.numCols) {
            int n2 = 0;
            while (n2 < this.numRows) {
                gamaObjectMatrix.set(iScope, n2, n, this.get(iScope, n, n2));
                ++n2;
            }
            ++n;
        }
        return gamaObjectMatrix;
    }

    @Override
    public GamaObjectMatrix copy(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        if (gamaPoint == null) {
            if (bl) {
                return new GamaObjectMatrix(this.numCols, this.numRows, Arrays.copyOf(this.matrix, this.matrix.length), this.getGamlType().getContentType());
            }
            return this;
        }
        return new GamaObjectMatrix((int)gamaPoint.getX(), (int)gamaPoint.getY(), Arrays.copyOf(this.matrix, this.matrix.length), this.getGamlType().getContentType());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GamaObjectMatrix)) {
            return false;
        }
        GamaObjectMatrix gamaObjectMatrix = (GamaObjectMatrix)object;
        return Arrays.equals(this.getMatrix(), gamaObjectMatrix.getMatrix());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getMatrix());
    }

    @Override
    public void _putAll(IScope iScope, Object object) {
        this.fillWith(iScope, this.getGamlType().getContentType().cast(iScope, object, null, false));
    }

    public void fillWith(IScope iScope, Object object) {
        Arrays.fill(this.getMatrix(), object);
    }

    @Override
    public Object get(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return null;
        }
        return this.getMatrix()[n2 * this.numCols + n];
    }

    @Override
    public void set(IScope iScope, int n, int n2, Object object) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return;
        }
        this.getMatrix()[n2 * this.numCols + n] = GamaType.toType(iScope, object, this.getGamlType().getContentType(), false);
    }

    @Override
    public Object remove(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return null;
        }
        Object object = this.getMatrix()[n2 * this.numCols + n];
        this.getMatrix()[n2 * this.numCols + n] = null;
        return object;
    }

    @Override
    public boolean _removeFirst(IScope iScope, Object object) {
        int n = 0;
        while (n < this.getMatrix().length) {
            if (this.getMatrix()[n].equals(object)) {
                this.getMatrix()[n] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean _removeAll(IScope iScope, IContainer<?, Object> iContainer) throws GamaRuntimeException {
        boolean bl = false;
        int n = 0;
        while (n < this.getMatrix().length) {
            if (iContainer.contains(iScope, this.getMatrix()[n])) {
                this.getMatrix()[n] = null;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public void shuffleWith(RandomUtils randomUtils) {
        randomUtils.shuffleInPlace(this.getMatrix());
    }

    @Override
    public Iterable<Object> iterable(IScope iScope) {
        return ImmutableList.copyOf((Object[])this.getMatrix());
    }

    public Object[] getMatrix() {
        return this.matrix;
    }

    protected void setMatrix(Object[] objectArray) {
        this.matrix = objectArray;
    }

    @Override
    protected void setNthElement(IScope iScope, int n, Object object) {
        this.getMatrix()[n] = object;
    }

    @Override
    public Object getNthElement(Integer n) {
        if (n == null || n > this.getMatrix().length) {
            return null;
        }
        return this.getMatrix()[n];
    }

    @Override
    public StreamEx<Object> stream(IScope iScope) {
        return StreamEx.of((Object[])this.matrix);
    }

    @Override
    public double[] getFieldData(IScope iScope) {
        double[] dArray = new double[this.matrix.length];
        int n = 0;
        while (n < this.matrix.length) {
            dArray[n] = Cast.asFloat(iScope, this.matrix[n]);
            ++n;
        }
        return dArray;
    }
}

