/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.descriptions.IDescription;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import gama.gaml.types.GamaGeometryType;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

@GamlAnnotations.inside(kinds={0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="identifier of the aspect (it can be used in a display to identify which aspect should be used for the given species). Two special names can also be used: 'default' will allow this aspect to be used as a replacement for the default aspect defined in preferences; 'highlighted' will allow the aspect to be used when the agent is highlighted as a replacement for the default (application of a color)")})}, omissible="name")
@GamlAnnotations.doc(value="Aspect statement is used to define a way to draw the current agent. Several aspects can be defined in one species. It can use attributes to customize each agent's aspect. The aspect is evaluate for each agent each time it has to be displayed.", usages={@GamlAnnotations.usage(value="An example of use of the aspect statement:", examples={@GamlAnnotations.example(value="species one_species {", isExecutable=false), @GamlAnnotations.example(value="\tint a <- rnd(10);", isExecutable=false), @GamlAnnotations.example(value="\taspect aspect1 {", isExecutable=false), @GamlAnnotations.example(value="\t\tif(a mod 2 = 0) { draw circle(a);}", isExecutable=false), @GamlAnnotations.example(value="\t\telse {draw square(a);}", isExecutable=false), @GamlAnnotations.example(value="\t\tdraw text: \"a= \" + a color: #black size: 5;", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class AspectStatement
extends AbstractStatementSequence {
    boolean isHighlightAspect;
    static final Map<String, Integer> SHAPES = new HashMap<String, Integer>(){
        {
            this.put("circle", 1);
            this.put("square", 2);
            this.put("triangle", 3);
            this.put("sphere", 4);
            this.put("cube", 5);
            this.put("point", 6);
        }
    };
    public static final GamaColor borderColor = GamaColor.get(Color.black.getRGB());
    public static final IExecutable DEFAULT_ASPECT = iScope -> {
        if (!iScope.isGraphics()) {
            return null;
        }
        IScope.IGraphicsScope iGraphicsScope = (IScope.IGraphicsScope)iScope;
        IAgent iAgent = iGraphicsScope.getAgent();
        if (iAgent != null && !iAgent.dead()) {
            IGraphics iGraphics = iGraphicsScope.getGraphics();
            if (iGraphics == null) {
                return null;
            }
            try {
                IShape iShape;
                Object object;
                Object object2;
                GamaColor gamaColor;
                Object object3;
                boolean bl;
                if (iAgent == iGraphicsScope.getGui().getHighlightedAgent()) {
                    iGraphics.beginHighlight();
                }
                if (bl = iAgent.getSpecies().hasVar("color")) {
                    object3 = iAgent.getDirectVarValue(iGraphicsScope, "color");
                    gamaColor = Cast.asColor(iGraphicsScope, object3);
                } else {
                    gamaColor = GamaColor.get(GamaPreferences.Displays.CORE_COLOR.getValue().getRGB());
                }
                object3 = GamaPreferences.Displays.CORE_SHAPE.getValue();
                Integer n = SHAPES.get(object3);
                if (n != null) {
                    object2 = GamaPreferences.Displays.CORE_SIZE.getValue();
                    object = iAgent.getLocation();
                    iShape = switch (SHAPES.get(object3)) {
                        case 1 -> GamaGeometryType.buildCircle((Double)object2, (GamaPoint)object);
                        case 2 -> GamaGeometryType.buildSquare((Double)object2, (GamaPoint)object);
                        case 3 -> GamaGeometryType.buildTriangle((Double)object2, (GamaPoint)object);
                        case 4 -> GamaGeometryType.buildSphere((Double)object2, (GamaPoint)object);
                        case 5 -> GamaGeometryType.buildCube((Double)object2, (GamaPoint)object);
                        case 6 -> GamaGeometryType.createPoint((IShape)object);
                        default -> iAgent.getGeometry();
                    };
                } else {
                    iShape = iAgent.getGeometry();
                }
                object2 = iShape.copy(iGraphicsScope);
                object = new ShapeDrawingAttributes((IShape)object2, iAgent, gamaColor, borderColor);
                Rectangle2D rectangle2D = iGraphics.drawShape(object2.getInnerGeometry(), (DrawingAttributes)object);
                return rectangle2D;
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.printStackTrace();
            }
            finally {
                iGraphics.endHighlight();
            }
        }
        return null;
    };

    public AspectStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(this.getLiteral("name", "default"));
        this.isHighlightAspect = "highlighted".equals(this.getName());
    }

    @Override
    public Rectangle2D executeOn(IScope iScope) {
        boolean bl;
        if (!iScope.isGraphics()) {
            return null;
        }
        IScope.IGraphicsScope iGraphicsScope = (IScope.IGraphicsScope)iScope;
        IAgent iAgent = iGraphicsScope.getAgent();
        boolean bl2 = bl = iAgent == iGraphicsScope.getGui().getHighlightedAgent() && !this.isHighlightAspect;
        if (iAgent != null && !iAgent.dead()) {
            IGraphics iGraphics = iGraphicsScope.getGraphics();
            if (iGraphics == null) {
                return null;
            }
            try {
                if (iGraphicsScope.interrupted()) {
                    return null;
                }
                if (bl) {
                    iGraphics.beginHighlight();
                }
                Rectangle2D rectangle2D = (Rectangle2D)super.executeOn(iGraphicsScope);
                return rectangle2D;
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.printStackTrace();
            }
            finally {
                if (bl) {
                    iGraphics.endHighlight();
                }
            }
        }
        return null;
    }

    @Override
    public Rectangle2D privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (!iScope.isGraphics()) {
            return null;
        }
        IScope.IGraphicsScope iGraphicsScope = (IScope.IGraphicsScope)iScope;
        IGraphics iGraphics = iGraphicsScope.getGraphics();
        super.privateExecuteIn(iGraphicsScope);
        return iGraphics.getAndWipeTemporaryEnvelope();
    }
}

